/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.extensions.java.net.URL;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import manifold.api.json.Json;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.internal.runtime.Bootstrap;
import manifold.json.extensions.javax.script.Bindings.ManBindingsExt;
import manifold.util.JsonUtil;
import manifold.util.StreamUtil;

@Extension
public class ManUrlExt {
    @Extension
    public static URL makeUrl(String url, Bindings arguments) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : arguments.entrySet()) {
            sb.append(sb.length() == 0 ? (char)'?' : '&').append(entry.getKey()).append('=');
            Object value = entry.getValue();
            if (value instanceof Bindings) {
                value = ManBindingsExt.toJson((Bindings)value);
            } else if (value instanceof List) {
                value = ManBindingsExt.listToJson((List)value);
            }
            try {
                value = URLEncoder.encode((String)value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            sb.append(value);
        }
        try {
            return new URL(url + sb);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String postForTextContent(@This URL url, Bindings bindings) {
        try {
            byte[] bytes = ManBindingsExt.makeArguments(bindings).getBytes("UTF-8");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(bytes.length));
            conn.setDoOutput(true);
            try (OutputStream out = conn.getOutputStream();){
                out.write(bytes);
            }
            var5_6 = null;
            try (Reader in = StreamUtil.getInputStreamReader((InputStream)conn.getInputStream());){
                String string = StreamUtil.getContent((Reader)in);
                return string;
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Bindings postForJsonContent(@This URL url, Bindings bindings) {
        return Json.fromJson(ManUrlExt.postForTextContent(url, bindings));
    }

    private static String makeValue(Object value) throws UnsupportedEncodingException {
        if (value instanceof Bindings) {
            value = JsonUtil.toJson((Bindings)((Bindings)value));
        } else if (value instanceof List) {
            value = JsonUtil.listToJson((List)((List)value));
        }
        return URLEncoder.encode(value.toString(), "UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTextContent(@This URL thiz) {
        try (Reader reader = StreamUtil.getInputStreamReader((InputStream)thiz.openStream());){
            String string = StreamUtil.getContent((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getBinaryContent(@This URL thiz) {
        try (InputStream stream = thiz.openStream();){
            byte[] byArray = StreamUtil.getContent((InputStream)stream);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Bindings getJsonContent(@This URL thiz) {
        return Json.fromJson(ManUrlExt.getTextContent(thiz));
    }

    static {
        Bootstrap.init();
    }
}

