/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcMemberAccessExpression;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonListType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonSchemaType;
import manifold.api.json.schema.JsonUnionType;
import manifold.api.type.ActualName;
import manifold.api.type.SourcePosition;
import manifold.api.type.TypeReference;
import manifold.internal.runtime.Bootstrap;
import manifold.json.extensions.java.net.URL.ManUrlExt;
import manifold.json.extensions.javax.script.Bindings.ManBindingsExt;
import manifold.util.JsonUtil;
import manifold.util.ManStringUtil;

public class JsonStructureType
extends JsonSchemaType {
    private static final String FIELD_FILE_URL = "__FILE_URL_";
    private List<IJsonParentType> _superTypes;
    private Map<String, IJsonType> _membersByName = new HashMap<String, IJsonType>();
    private Map<String, Set<IJsonType>> _unionMembers;
    private Map<String, Token> _memberLocations = new HashMap<String, Token>();
    private Map<String, IJsonParentType> _innerTypes = Collections.emptyMap();
    private Token _token;

    public JsonStructureType(JsonSchemaType parent, URL source, String name) {
        super(name, source, parent);
        this._unionMembers = Collections.emptyMap();
        this._superTypes = Collections.emptyList();
    }

    @Override
    public String getFqn() {
        String result = "";
        if (!this.isParentRoot()) {
            result = this.getParent().getFqn();
            result = result + '.';
        }
        return result + JsonUtil.makeIdentifier((String)this.getLabel());
    }

    public void addSuper(IJsonParentType superType) {
        if (this._superTypes.isEmpty()) {
            this._superTypes = new ArrayList<IJsonParentType>();
        }
        this._superTypes.add(superType);
    }

    public List<IJsonParentType> getSuperTypes() {
        return this._superTypes;
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        if (this._innerTypes.isEmpty()) {
            this._innerTypes = new HashMap<String, IJsonParentType>();
        }
        this._innerTypes.put(name, type);
    }

    @Override
    public IJsonType findChild(String name) {
        List<IJsonType> definitions;
        IJsonParentType innerType = this._innerTypes.get(name);
        if (innerType == null && (definitions = this.getDefinitions()) != null) {
            for (IJsonType child : definitions) {
                if (!child.getIdentifier().equals(name)) continue;
                innerType = (IJsonParentType)child;
                break;
            }
        }
        return innerType;
    }

    public Map<String, IJsonType> getMembers() {
        return this._membersByName;
    }

    public Map<String, IJsonParentType> getInnerTypes() {
        return this._innerTypes;
    }

    public void addMember(String name, IJsonType type, Token token) {
        IJsonType existingType = this._membersByName.get(name);
        if (existingType != null && existingType != type) {
            if (type == DynamicType.instance()) {
                return;
            }
            if (existingType != DynamicType.instance() && (type = Json.mergeTypes(existingType, type)) == null) {
                throw new RuntimeException("Types disagree for '" + name + "' from array data: " + type.getName() + " vs: " + existingType.getName());
            }
        }
        this._membersByName.put(name, type);
        this._memberLocations.put(name, token);
        this.addUnionMemberAccess(name, type);
    }

    private void addUnionMemberAccess(String name, IJsonType type) {
        if (type instanceof JsonUnionType) {
            for (IJsonType iJsonType : ((JsonUnionType)type).getConstituents()) {
                if (this._unionMembers.isEmpty()) {
                    this._unionMembers = new HashMap<String, Set<IJsonType>>();
                }
                Set union = this._unionMembers.computeIfAbsent(name, k -> new HashSet());
                union.add(iJsonType);
            }
        } else if (type instanceof JsonListType) {
            this.addUnionMemberAccess(name, ((JsonListType)type).getComponentType());
        }
    }

    public IJsonType findMemberType(String name) {
        return this._membersByName.get(name);
    }

    public Token getToken() {
        return this._token;
    }

    public void setToken(Token token) {
        this._token = token;
    }

    JsonStructureType merge(JsonStructureType other) {
        if (!this.getName().equals(other.getName())) {
            return null;
        }
        JsonStructureType mergedType = new JsonStructureType(this.getParent(), this.getFile(), this.getName());
        for (Map.Entry<String, IJsonType> e : this._membersByName.entrySet()) {
            String memberName = e.getKey();
            IJsonType memberType = other.findMemberType(memberName);
            memberType = memberType != null ? Json.mergeTypes(e.getValue(), memberType) : e.getValue();
            if (memberType != null) {
                mergedType.addMember(memberName, memberType, this._memberLocations.get(memberName));
                continue;
            }
            return null;
        }
        if (!this.mergeInnerTypes(other, mergedType, this._innerTypes)) {
            return null;
        }
        return mergedType;
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        if (this.getParent() instanceof IJsonParentType) {
            sb.append('\n');
        }
        String name = this.getName();
        String identifier = this.addActualNameAnnotation(sb, indent, name, false);
        if (!(this.getParent() instanceof JsonStructureType && ((JsonStructureType)this.getParent()).addSourcePositionAnnotation(sb, indent, identifier) || this.getToken() == null)) {
            this.addSourcePositionAnnotation(sb, indent, identifier, this.getToken());
        }
        this.indent(sb, indent);
        sb.append("@Structural\n");
        this.indent(sb, indent);
        sb.append("public interface ").append(identifier).append(this.addSuperTypes(sb)).append(" {\n");
        this.renderFileField(sb, indent + 2);
        this.renderTopLevelFactoryMethods(sb, indent + 2);
        for (String key : this._membersByName.keySet()) {
            Set<IJsonType> union;
            sb.append('\n');
            IJsonType type = this._membersByName.get(key);
            String propertyType = type instanceof JsonUnionType ? "Object" : type.getIdentifier();
            this.addSourcePositionAnnotation(sb, indent + 2, key);
            identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
            this.indent(sb, indent + 2);
            sb.append(propertyType).append(" get").append(identifier).append("();\n");
            if (mutable) {
                this.addSourcePositionAnnotation(sb, indent + 2, key);
                this.addActualNameAnnotation(sb, indent + 2, key, true);
                this.indent(sb, indent + 2);
                sb.append("void set").append(identifier).append("(").append(propertyType).append(" $value);\n");
            }
            if ((union = this._unionMembers.get(key)) == null) continue;
            for (IJsonType constituentType : union) {
                sb.append('\n');
                String specificPropertyType = this.getConstituentQn(constituentType, type);
                this.addSourcePositionAnnotation(sb, indent + 2, key);
                if (constituentType instanceof JsonSchemaType) {
                    this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
                }
                identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
                this.indent(sb, indent + 2);
                String unionName = this.makeMemberIdentifier(constituentType);
                sb.append(specificPropertyType).append(" get").append(identifier).append("As").append(unionName).append("();\n");
                if (!mutable) continue;
                this.addSourcePositionAnnotation(sb, indent + 2, key);
                if (constituentType instanceof JsonSchemaType) {
                    this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
                }
                this.addActualNameAnnotation(sb, indent + 2, key, true);
                this.indent(sb, indent + 2);
                sb.append("void set").append(identifier).append("As").append(unionName).append("(").append(specificPropertyType).append(" $value);\n");
            }
        }
        for (IJsonParentType child : this._innerTypes.values()) {
            child.render(sb, indent + 2, mutable);
        }
        List<IJsonType> definitions = this.getDefinitions();
        if (definitions != null) {
            for (IJsonType child : definitions) {
                if (!(child instanceof IJsonParentType)) continue;
                ((IJsonParentType)child).render(sb, indent + 2, mutable);
            }
        }
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private String getConstituentQn(IJsonType constituentType, IJsonType propertyType) {
        String qn = this.getConstituentQn(constituentType);
        while (propertyType instanceof JsonListType) {
            qn = "java.util.List<" + qn + ">";
            propertyType = ((JsonListType)propertyType).getComponentType();
        }
        return qn;
    }

    private String getConstituentQn(IJsonType constituentType) {
        if (constituentType instanceof JsonListType) {
            return "java.util.List<" + this.getConstituentQn(((JsonListType)constituentType).getComponentType()) + ">";
        }
        String qn = "";
        if (constituentType.getParent() instanceof JsonUnionType) {
            qn = this.getConstituentQn(constituentType.getParent()) + '.';
        }
        return qn + constituentType.getIdentifier();
    }

    private IJsonType getConstituentQnComponent(IJsonType constituentType) {
        if (constituentType instanceof JsonListType) {
            return this.getConstituentQnComponent(((JsonListType)constituentType).getComponentType());
        }
        return constituentType;
    }

    private void renderFileField(StringBuilder sb, int indent) {
        this.indent(sb, indent);
        sb.append("String __FILE_URL_ = \"").append(this.getFile().toString()).append("\";\n");
    }

    private String addSuperTypes(StringBuilder sb) {
        List<IJsonParentType> superTypes = this.getSuperTypes();
        if (superTypes.isEmpty()) {
            return "";
        }
        sb.append(" extends ");
        for (int i = 0; i < superTypes.size(); ++i) {
            IJsonParentType superType = superTypes.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(superType.getIdentifier());
        }
        return "";
    }

    private String addActualNameAnnotation(StringBuilder sb, int indent, String name, boolean capitalize) {
        String identifier = this.makeIdentifier(name, capitalize);
        if (!identifier.equals(name)) {
            this.indent(sb, indent);
            sb.append("@").append(ActualName.class.getName()).append("( \"").append(name).append("\" )\n");
        }
        return identifier;
    }

    private String makeMemberIdentifier(IJsonType type) {
        if (type instanceof JsonListType) {
            return "ListOf" + this.makeMemberIdentifier(((JsonListType)type).getComponentType());
        }
        return this.makeIdentifier(type.getName(), false);
    }

    private String makeIdentifier(String name, boolean capitalize) {
        return capitalize ? ManStringUtil.capitalize((String)JsonUtil.makeIdentifier((String)name)) : JsonUtil.makeIdentifier((String)name);
    }

    private boolean addSourcePositionAnnotation(StringBuilder sb, int indent, String name) {
        Token token = this._memberLocations.get(name);
        if (token == null) {
            return false;
        }
        return this.addSourcePositionAnnotation(sb, indent, name, token);
    }

    private boolean addSourcePositionAnnotation(StringBuilder sb, int indent, String name, Token token) {
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(SourcePosition.class.getName()).addArgument((SrcArgument)new SrcArgument((SrcExpression)new SrcMemberAccessExpression(new String[]{this.getIdentifier(), FIELD_FILE_URL})).name("url")).addArgument("feature", String.class, (Object)name).addArgument("offset", Integer.TYPE, (Object)token.getOffset()).addArgument("length", Integer.TYPE, (Object)name.length());
        annotation.render(sb, indent);
        return true;
    }

    private void addTypeReferenceAnnotation(StringBuilder sb, int indent, JsonSchemaType type) {
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(TypeReference.class.getName()).addArgument("value", String.class, (Object)type.getIdentifier());
        annotation.render(sb, indent);
    }

    private void renderTopLevelFactoryMethods(StringBuilder sb, int indent) {
        this.indent(sb, indent);
        String typeName = this.getIdentifier();
        sb.append("static ").append(typeName).append(" create() {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")new javax.script.SimpleBindings();\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toJson() {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toJson(this);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toXml() {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toXml(this);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toXml(String name) {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toXml(this, name);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        if (!this.shouldRenderTopLevel(this)) {
            return;
        }
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJson(String jsonText) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(Json.class.getName()).append(".fromJson(jsonText);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(String url) {\n");
        this.indent(sb, indent);
        sb.append("  try {\n");
        this.indent(sb, indent);
        sb.append("    return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".getJsonContent(new java.net.URL(url));\n");
        this.indent(sb, indent);
        sb.append("  } catch(Exception e) {throw new RuntimeException(e);}\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(java.net.URL url) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".getJsonContent(url);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(java.net.URL url, javax.script.Bindings json) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".postForJsonContent(url, json);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonFile(java.io.File file) {\n");
        this.indent(sb, indent);
        sb.append("  try {\n");
        this.indent(sb, indent);
        sb.append("    return (").append(typeName).append(")fromJsonUrl(file.toURI().toURL());\n");
        this.indent(sb, indent);
        sb.append("  } catch(Exception e) {throw new RuntimeException(e);}\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private boolean shouldRenderTopLevel(IJsonParentType type) {
        IJsonParentType parent = type.getParent();
        if (parent == null) {
            return true;
        }
        if (parent instanceof JsonListType) {
            return this.shouldRenderTopLevel(parent);
        }
        return false;
    }

    private void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonStructureType type = (JsonStructureType)o;
        if (!this._superTypes.equals(type._superTypes)) {
            return false;
        }
        if (!this._membersByName.equals(type._membersByName)) {
            return false;
        }
        if (!this._unionMembers.equals(type._unionMembers)) {
            return false;
        }
        return this._innerTypes.equals(type._innerTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._superTypes.hashCode();
        result = 31 * result + this._membersByName.hashCode();
        result = 31 * result + this._unionMembers.hashCode();
        result = 31 * result + this._innerTypes.hashCode();
        return result;
    }

    public String toString() {
        return this.getFqn();
    }

    static {
        Bootstrap.init();
    }
}

