/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

public class OctetEncoding {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private String _encoded;
    private byte[] _bytes;

    public static OctetEncoding encoded(String encoded) {
        return new OctetEncoding(encoded, null);
    }

    public static OctetEncoding decoded(byte[] bytes) {
        return new OctetEncoding(null, bytes);
    }

    private OctetEncoding(String encoded, byte[] decoded) {
        this._encoded = encoded;
        this._bytes = decoded;
    }

    public byte[] getBytes() {
        if (this._bytes != null) {
            return this._bytes;
        }
        return this.decode(this._encoded);
    }

    public String toString() {
        if (this._encoded != null) {
            return this._encoded;
        }
        char[] hexChars = new char[this._bytes.length * 2];
        for (int j = 0; j < this._bytes.length; ++j) {
            int v = this._bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        this._bytes = null;
        this._encoded = new String(hexChars);
        return this._encoded;
    }

    private byte[] decode(String encoded) {
        int len = encoded.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(encoded.charAt(i), 16) << 4) + Character.digit(encoded.charAt(i + 1), 16));
        }
        return data;
    }
}

