/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import extensions.java.net.URL.ManUrlExt;
import extensions.javax.script.Bindings.ManBindingsExt;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import manifold.api.json.IJsonIO;
import manifold.api.json.Json;
import manifold.internal.runtime.Bootstrap;
import manifold.util.Pair;
import manifold.util.StreamUtil;

public class JsonImplBase
implements IJsonIO {
    protected Bindings _bindings;

    public JsonImplBase() {
        this(new SimpleBindings(new ConcurrentHashMap<String, Object>()));
    }

    public JsonImplBase(Bindings bindings) {
        this._bindings = bindings;
    }

    protected Bindings getBindings() {
        return this._bindings;
    }

    protected Bindings getBindings(Object value) {
        if (value instanceof Pair) {
            return this.getBindings(((Pair)value).getSecond());
        }
        if (value instanceof Bindings) {
            return (Bindings)value;
        }
        if (value instanceof JsonImplBase) {
            return ((JsonImplBase)value)._bindings;
        }
        throw new IllegalStateException("Unhandled type: " + value.getClass());
    }

    protected List wrapList(List list, Function<Bindings, ? extends JsonImplBase> ctor) {
        ArrayList wrappedList = new ArrayList();
        for (Object e : list) {
            if (e instanceof Pair) {
                e = ((Pair)e).getSecond();
            }
            Object elem = e instanceof List ? this.wrapList((List)e, ctor) : (e instanceof Bindings ? ctor.apply((Bindings)e) : e);
            wrappedList.add(elem);
        }
        return wrappedList;
    }

    protected List unwrapList(List list) {
        ArrayList<Object> unwrappedList = new ArrayList<Object>();
        for (Object e : list) {
            Object elem = e instanceof List ? this.unwrapList((List)e) : (e instanceof JsonImplBase ? ((JsonImplBase)e).getBindings() : e);
            unwrappedList.add(elem);
        }
        return unwrappedList;
    }

    public URL makeUrl(String url) {
        if (this._bindings.size() > 0) {
            url = url + '?';
        }
        try {
            return new URL(url + ManBindingsExt.makeArguments(this._bindings));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTextContent(String url) {
        try (Reader reader = StreamUtil.getInputStreamReader((InputStream)this.makeUrl(url).openStream());){
            String string = StreamUtil.getContent((Reader)reader);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Bindings getJsonContent(String url) {
        return Json.fromJson(this.getTextContent(url));
    }

    public String postForTextContent(URL url) {
        return ManUrlExt.postForTextContent(url, this._bindings);
    }

    public Bindings postForJsonContent(URL url) {
        return Json.fromJson(this.postForTextContent(url));
    }

    @Override
    public void load(Bindings bindings) {
        this._bindings = new SimpleBindings(bindings);
    }

    @Override
    public void save(Bindings bindings) {
        bindings.putAll(this._bindings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonImplBase that = (JsonImplBase)o;
        return this._bindings.equals(that._bindings);
    }

    public int hashCode() {
        return this._bindings.hashCode();
    }

    static {
        Bootstrap.init();
    }
}

