/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import manifold.api.gen.SrcElement;
import manifold.api.gen.SrcType;
import manifold.api.json.AbstractJsonTypeManifold;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonBasicType;
import manifold.api.json.JsonStructureType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonSchemaType;
import manifold.api.json.schema.Type;
import manifold.api.json.schema.TypeAttributes;
import manifold.ext.api.IBindingType;
import manifold.util.JsonUtil;
import manifold.util.Pair;

public class JsonEnumType
extends JsonStructureType {
    private final List<Object> _enumValues;
    private final boolean _hasNull;

    JsonEnumType(JsonSchemaType parent, URL source, String name, List<?> list, TypeAttributes attr) {
        super(parent, source, name, attr);
        this._enumValues = new ArrayList<Object>();
        boolean hasNull = false;
        for (Object value : list) {
            Token token;
            if (value instanceof Pair) {
                token = ((Token[])((Pair)value).getFirst())[0];
                value = ((Pair)value).getSecond();
            } else {
                token = null;
            }
            JsonBasicType type = JsonBasicType.get(value);
            if (!hasNull && type == null || type.getJsonType() == Type.Null) {
                hasNull = true;
                continue;
            }
            this.addMember(JsonUtil.makeIdentifier((String)String.valueOf(value)), type, token);
            this._enumValues.add(value);
        }
        this._hasNull = hasNull;
    }

    public JsonEnumType(JsonEnumType enum1, JsonEnumType enum2, JsonSchemaType parent, String name) {
        super(parent, enum1.getFile(), name, enum2 == null ? enum1.getTypeAttributes() : enum1.getTypeAttributes().blendWith(enum2.getTypeAttributes()));
        LinkedHashMap<String, IJsonType> members = new LinkedHashMap<String, IJsonType>(enum1.getMembers());
        LinkedHashMap<String, Token> memberLocations = new LinkedHashMap<String, Token>(enum1.getMemberLocations());
        LinkedHashSet<Object> enumValues = new LinkedHashSet<Object>(enum1._enumValues);
        if (enum2 != null) {
            members.putAll(enum2.getMembers());
            memberLocations.putAll(enum2.getMemberLocations());
            enumValues.addAll(enum2._enumValues);
        }
        members.forEach((m, v) -> this.addMember((String)m, (IJsonType)v, (Token)memberLocations.get(m)));
        this._enumValues = new ArrayList<Object>(enumValues);
        this._hasNull = enum1._hasNull || enum2 != null && enum2._hasNull;
        this.getTypeAttributes().setNullable(TypeAttributes.or(this._hasNull, TypeAttributes.and(enum1.getTypeAttributes().getNullable(), enum2 == null ? null : enum2.getTypeAttributes().getNullable())));
    }

    @Override
    public IJsonType merge(IJsonType that) {
        if (!this.getName().equals(that.getName())) {
            return null;
        }
        if (that instanceof JsonBasicType) {
            return that;
        }
        if (!(that instanceof JsonEnumType)) {
            return null;
        }
        return new JsonEnumType(this, (JsonEnumType)that, this.getParent(), this.getName());
    }

    @Override
    public void render(AbstractJsonTypeManifold tm, StringBuilder sb, int indent, boolean mutable) {
        this.setTm(tm);
        if (this.getParent() != null) {
            sb.append('\n');
        }
        String name = this.getName();
        String identifier = this.addActualNameAnnotation(sb, indent, name, false);
        if (!(this.getParent() instanceof JsonStructureType && ((JsonStructureType)this.getParent()).addSourcePositionAnnotation(sb, indent, identifier) || this.getToken() == null)) {
            this.addSourcePositionAnnotation(sb, indent, identifier, this.getToken());
        }
        this.indent(sb, indent);
        sb.append("public enum ").append(identifier).append(" implements ").append(IBindingType.class.getTypeName()).append(" {\n");
        int i = 0;
        for (String key : this.getMembers().keySet()) {
            this.addSourcePositionAnnotation(sb, indent + 2, key);
            this.indent(sb, indent + 2);
            Object objValue = this._enumValues.get(i);
            sb.append(key).append("(").append(objValue == null ? "null" : SrcElement.makeCompileTimeConstantValue((SrcType)new SrcType(objValue.getClass()), (Object)objValue)).append(")");
            if (++i == this.getMembers().size()) {
                sb.append(";\n\n");
                continue;
            }
            sb.append(",\n");
        }
        this.renderFileField(sb, indent + 2, "static final");
        this.indent(sb, indent + 2);
        sb.append("private final Object _value;\n");
        this.indent(sb, indent + 2);
        sb.append(identifier).append("(Object objValue) {\n");
        this.indent(sb, indent + 4);
        sb.append("_value = objValue;\n");
        this.indent(sb, indent + 2);
        sb.append("}\n");
        this.indent(sb, indent + 2);
        sb.append("public Object toBindingValue() {\n");
        this.indent(sb, indent + 4);
        sb.append("return _value;\n");
        this.indent(sb, indent + 2);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }
}

