/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.util.Map;
import javax.script.Bindings;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonSchemaType;
import manifold.api.json.JsonStructureType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonSchemaTransformer;
import manifold.internal.runtime.Bootstrap;
import manifold.util.Pair;

class ObjectTransformer {
    private final JsonSchemaTransformer _schemaTx;
    private final JsonStructureType _type;
    private final Bindings _jsonObj;

    static JsonStructureType transform(JsonSchemaTransformer schemaTx, String name, JsonSchemaType parent, Bindings jsonObj) {
        ObjectTransformer objectTx = new ObjectTransformer(schemaTx, name, parent, jsonObj);
        return objectTx.transform();
    }

    static JsonStructureType transform(JsonSchemaTransformer schemaTx, JsonStructureType type, Bindings jsonObj) {
        ObjectTransformer objectTx = new ObjectTransformer(schemaTx, type, jsonObj);
        return objectTx.transform();
    }

    private ObjectTransformer(JsonSchemaTransformer schemaTx, String name, JsonSchemaType parent, Bindings jsonObj) {
        this._schemaTx = schemaTx;
        this._jsonObj = jsonObj;
        this._type = new JsonStructureType(parent, name);
    }

    private ObjectTransformer(JsonSchemaTransformer schemaTx, JsonStructureType type, Bindings jsonObj) {
        this._schemaTx = schemaTx;
        this._jsonObj = jsonObj;
        this._type = type;
    }

    JsonStructureType getType() {
        return this._type;
    }

    private JsonStructureType transform() {
        JsonSchemaType parent = this._type.getParent();
        if (parent != null) {
            parent.addChild(this._type.getLabel(), this._type);
        }
        this._schemaTx.cache(this._type);
        this.addProperties();
        return this._type;
    }

    private void addProperties() {
        Object props = this._jsonObj.get("properties");
        if (props == null) {
            return;
        }
        Bindings properties = props instanceof Pair ? (Bindings)((Pair)props).getSecond() : (Bindings)props;
        for (Map.Entry entry : properties.entrySet()) {
            Bindings bindings;
            Token token;
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Pair) {
                token = (Token)((Pair)value).getFirst();
                bindings = (Bindings)((Pair)value).getSecond();
            } else {
                token = null;
                bindings = (Bindings)value;
            }
            IJsonType type = this._schemaTx.transformType(this._type, name, bindings);
            this._type.addMember(name, type, token);
        }
    }

    static {
        Bootstrap.init();
    }
}

