/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import extensions.java.net.URL.ManUrlExt;
import extensions.javax.script.Bindings.ManBindingsExt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcMemberAccessExpression;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonListType;
import manifold.api.json.JsonSchemaType;
import manifold.api.json.Token;
import manifold.api.type.ActualName;
import manifold.api.type.SourcePosition;
import manifold.internal.runtime.Bootstrap;
import manifold.util.JsonUtil;
import manifold.util.ManStringUtil;

public class JsonStructureType
extends JsonSchemaType {
    private static final String FIELD_FILE_URL = "__FILE_URL_";
    private List<IJsonParentType> _superTypes;
    private Map<String, IJsonType> _members = new HashMap<String, IJsonType>();
    private Map<String, Token> _memberLocations = new HashMap<String, Token>();
    private Map<String, IJsonParentType> _innerTypes = new HashMap<String, IJsonParentType>();
    private Token _token;

    public JsonStructureType(JsonSchemaType parent, String name) {
        super(name, parent);
        this._superTypes = new ArrayList<IJsonParentType>();
    }

    public void addSuper(IJsonParentType superType) {
        this._superTypes.add(superType);
    }

    public List<IJsonParentType> getSuperTypes() {
        return this._superTypes;
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        this._innerTypes.put(name, type);
    }

    @Override
    public IJsonParentType findChild(String name) {
        List<IJsonType> definitions;
        IJsonParentType innerType = this._innerTypes.get(name);
        if (innerType == null && (definitions = this.getDefinitions()) != null) {
            for (IJsonType child : definitions) {
                if (!child.getName().equals(name)) continue;
                innerType = (IJsonParentType)child;
                break;
            }
        }
        return innerType;
    }

    public Map<String, IJsonType> getMembers() {
        return this._members;
    }

    public Map<String, IJsonParentType> getInnerTypes() {
        return this._innerTypes;
    }

    public void addMember(String name, IJsonType type, Token token) {
        IJsonType existingType = this._members.get(name);
        if (existingType != null && existingType != type) {
            if (type == DynamicType.instance()) {
                return;
            }
            if (existingType != DynamicType.instance() && (type = Json.mergeTypes(existingType, type)) == null) {
                throw new RuntimeException("Types disagree for '" + name + "' from array data: " + type.getName() + " vs: " + existingType.getName());
            }
        }
        this._members.put(name, type);
        this._memberLocations.put(name, token);
    }

    public IJsonType findMemberType(String name) {
        return this._members.get(name);
    }

    public Token getToken() {
        return this._token;
    }

    public void setToken(Token token) {
        this._token = token;
    }

    JsonStructureType merge(JsonStructureType other) {
        if (!this.getName().equals(other.getName())) {
            return null;
        }
        JsonStructureType mergedType = new JsonStructureType(this.getParent(), this.getName());
        for (Map.Entry<String, IJsonType> e : this._members.entrySet()) {
            String memberName = e.getKey();
            IJsonType memberType = other.findMemberType(memberName);
            memberType = memberType != null ? Json.mergeTypes(e.getValue(), memberType) : e.getValue();
            if (memberType != null) {
                mergedType.addMember(memberName, memberType, this._memberLocations.get(memberName));
                continue;
            }
            return null;
        }
        if (!this.mergeInnerTypes(other, mergedType, this._innerTypes)) {
            return null;
        }
        return mergedType;
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        this.indent(sb, indent);
        String name = this.getName();
        String identifier = this.addActualNameAnnotation(sb, indent, name, false);
        if (!(this.getParent() instanceof JsonStructureType && ((JsonStructureType)this.getParent()).addSourcePositionAnnotation(sb, indent + 2, identifier) || this.getToken() == null)) {
            this.addSourcePositionAnnotation(sb, indent + 2, identifier, this.getToken());
        }
        this.indent(sb, indent);
        sb.append("@Structural\n");
        this.indent(sb, indent);
        sb.append("public interface ").append(identifier).append(this.addSuperTypes(sb)).append(" {\n");
        this.renderFileField(sb, indent + 2);
        this.renderTopLevelFactoryMethods(sb, indent + 2);
        for (String key : this._members.keySet()) {
            String propertyType = this._members.get(key).getIdentifier();
            this.addSourcePositionAnnotation(sb, indent + 2, key);
            identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
            this.indent(sb, indent + 2);
            sb.append(propertyType).append(" get").append(identifier).append("();\n");
            if (!mutable) continue;
            this.addSourcePositionAnnotation(sb, indent + 2, key);
            this.addActualNameAnnotation(sb, indent + 2, key, true);
            this.indent(sb, indent + 2);
            sb.append("void set").append(identifier).append("(").append(propertyType).append(" $value);\n");
        }
        for (IJsonParentType child : this._innerTypes.values()) {
            child.render(sb, indent + 2, mutable);
        }
        List<IJsonType> definitions = this.getDefinitions();
        if (definitions != null) {
            for (IJsonType child : definitions) {
                if (!(child instanceof IJsonParentType)) continue;
                ((IJsonParentType)child).render(sb, indent + 2, mutable);
            }
        }
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void renderFileField(StringBuilder sb, int indent) {
        this.indent(sb, indent);
        sb.append("String __FILE_URL_ = \"").append(this.getFile().toString()).append("\";\n");
    }

    private String addSuperTypes(StringBuilder sb) {
        for (int i = 0; i < this._superTypes.size(); ++i) {
            IJsonParentType superType = this._superTypes.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(superType.getIdentifier());
        }
        return "";
    }

    private String addActualNameAnnotation(StringBuilder sb, int indent, String name, boolean capitalize) {
        String identifier;
        String string = identifier = capitalize ? ManStringUtil.capitalize((String)JsonUtil.makeIdentifier((String)name)) : JsonUtil.makeIdentifier((String)name);
        if (!identifier.equals(name)) {
            this.indent(sb, indent);
            sb.append("@").append(ActualName.class.getName()).append("( \"").append(name).append("\" )\n");
        }
        return identifier;
    }

    private boolean addSourcePositionAnnotation(StringBuilder sb, int indent, String name) {
        Token token = this._memberLocations.get(name);
        if (token == null) {
            return false;
        }
        return this.addSourcePositionAnnotation(sb, indent, name, token);
    }

    private boolean addSourcePositionAnnotation(StringBuilder sb, int indent, String name, Token token) {
        this.indent(sb, indent);
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(SourcePosition.class.getName()).addArgument((SrcArgument)new SrcArgument((SrcExpression)new SrcMemberAccessExpression(new String[]{this.getName(), FIELD_FILE_URL})).name("url")).addArgument("feature", String.class, (Object)name).addArgument("offset", Integer.TYPE, (Object)token.getOffset()).addArgument("length", Integer.TYPE, (Object)name.length());
        annotation.render(sb, indent);
        sb.append('\n');
        return true;
    }

    private void renderTopLevelFactoryMethods(StringBuilder sb, int indent) {
        this.indent(sb, indent);
        String typeName = this.getIdentifier();
        sb.append("static ").append(typeName).append(" create() {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")new javax.script.SimpleBindings();\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toJson() {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toJson(this);\n");
        this.indent(sb, indent);
        sb.append("};\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toXml() {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toXml(this);\n");
        this.indent(sb, indent);
        sb.append("};\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toXml(String name) {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toXml(this, name);\n");
        this.indent(sb, indent);
        sb.append("};\n");
        if (!this.shouldRenderTopLevel(this)) {
            return;
        }
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJson(String jsonText) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(Json.class.getName()).append(".fromJson(jsonText);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(String url) {\n");
        this.indent(sb, indent);
        sb.append("  try {\n");
        this.indent(sb, indent);
        sb.append("    return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".getJsonContent(new java.net.URL(url));\n");
        this.indent(sb, indent);
        sb.append("  } catch(Exception e) {throw new RuntimeException(e);}\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(java.net.URL url) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".getJsonContent(url);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(java.net.URL url, javax.script.Bindings json) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".postForJsonContent(url, json);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonFile(java.io.File file) {\n");
        this.indent(sb, indent);
        sb.append("  try {\n");
        this.indent(sb, indent);
        sb.append("    return (").append(typeName).append(")fromJsonUrl(file.toURI().toURL());\n");
        this.indent(sb, indent);
        sb.append("  } catch(Exception e) {throw new RuntimeException(e);}\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private boolean shouldRenderTopLevel(IJsonParentType type) {
        IJsonParentType parent = type.getParent();
        if (parent == null) {
            return true;
        }
        if (parent instanceof JsonListType) {
            return this.shouldRenderTopLevel(parent);
        }
        return false;
    }

    private void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonStructureType type = (JsonStructureType)o;
        if (!this._superTypes.equals(type._superTypes)) {
            return false;
        }
        if (!this._members.equals(type._members)) {
            return false;
        }
        return this._innerTypes.equals(type._innerTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._superTypes.hashCode();
        result = 31 * result + this._members.hashCode();
        result = 31 * result + this._innerTypes.hashCode();
        return result;
    }

    static {
        Bootstrap.init();
    }
}

