/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.HashMap;
import java.util.Map;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonSchemaType;
import manifold.internal.runtime.Bootstrap;

public class JsonListType
extends JsonSchemaType {
    private IJsonType _componentType;
    private Map<String, IJsonParentType> _innerTypes = new HashMap<String, IJsonParentType>();

    public JsonListType(String label, JsonSchemaType parent) {
        super(label, parent);
    }

    @Override
    public String getLabel() {
        return super.getName();
    }

    @Override
    public String getName() {
        return "java.util.List<" + this._componentType.getIdentifier() + ">";
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        this._innerTypes.put(name, type);
    }

    @Override
    public IJsonParentType findChild(String name) {
        IJsonParentType inner = this._innerTypes.get(name);
        if (inner == null && this._componentType instanceof IJsonParentType) {
            inner = ((IJsonParentType)this._componentType).findChild(name);
        }
        return inner;
    }

    public IJsonType getComponentType() {
        return this._componentType;
    }

    public void setComponentType(IJsonType compType) {
        if (this._componentType != null && this._componentType != compType) {
            throw new IllegalStateException("Component type already set to: " + this._componentType.getIdentifier() + ", which is not the same as: " + compType.getIdentifier());
        }
        this._componentType = compType;
    }

    public Map<String, IJsonParentType> getInnerTypes() {
        return this._innerTypes;
    }

    IJsonType merge(JsonListType other) {
        JsonListType mergedType = new JsonListType(this.getLabel(), this.getParent());
        if (!this.getComponentType().equals(other.getComponentType())) {
            IJsonType componentType = Json.mergeTypes(this.getComponentType(), other.getComponentType());
            if (componentType != null) {
                mergedType.setComponentType(componentType);
            } else {
                return null;
            }
        }
        if (!this.mergeInnerTypes(other, mergedType, this._innerTypes)) {
            return null;
        }
        return mergedType;
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        for (IJsonParentType child : this._innerTypes.values()) {
            child.render(sb, indent, mutable);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonListType that = (JsonListType)o;
        if (!this._componentType.equals(that._componentType)) {
            return false;
        }
        return this._innerTypes.equals(that._innerTypes);
    }

    @Override
    public int hashCode() {
        int result = this._componentType.hashCode();
        result = 31 * result + this._innerTypes.hashCode();
        return result;
    }

    static {
        Bootstrap.init();
    }
}

