/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.extensions.java.net.URL;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import manifold.api.json.Json;
import manifold.api.json.Yaml;
import manifold.ext.ReflectionRuntimeMethods;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.json.extensions.javax.script.Bindings.ManBindingsExt;
import manifold.util.JsonUtil;
import manifold.util.StreamUtil;

@Extension
public class ManUrlExt {
    public static URL makeUrl(String url, Object jsonValue) {
        StringBuilder sb = new StringBuilder();
        if (jsonValue instanceof Bindings) {
            for (Map.Entry entry : ((Bindings)jsonValue).entrySet()) {
                sb.append(sb.length() == 0 ? (char)'?' : '&').append(entry.getKey()).append('=');
                Object value = entry.getValue();
                value = ManUrlExt.valueToJson(value);
                sb.append(value);
            }
        } else if (jsonValue instanceof List) {
            for (Object value : (List)jsonValue) {
                sb.append(sb.length() == 0 ? (char)'?' : '&');
                value = ManUrlExt.valueToJson(value);
                sb.append(value);
            }
        } else if (jsonValue != null) {
            String value = ManUrlExt.encode(String.valueOf(jsonValue));
            sb.append('?').append(value);
        }
        try {
            return new URL(url + sb);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object valueToJson(Object value) {
        if (value instanceof Bindings) {
            value = ManBindingsExt.toJson((Bindings)value);
        } else if (value instanceof List) {
            value = ManBindingsExt.listToJson((List)value);
        }
        return ManUrlExt.encode(String.valueOf(value));
    }

    @Extension
    public static String encode(String urlPart) {
        try {
            return URLEncoder.encode(urlPart, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String sendRequest(URL url, String httpMethod, Object jsonValue) {
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(httpMethod);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (jsonValue != null && !httpMethod.equals("GET") && !httpMethod.equals("DELETE")) {
                ManUrlExt.sendJsonValue(jsonValue, conn);
            }
            return ManUrlExt.receiveResponse(conn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void sendJsonValue(Object jsonValue, HttpURLConnection conn) throws IOException {
        String json = JsonUtil.toJson((Object)jsonValue);
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setDoOutput(true);
        try (OutputStream out = conn.getOutputStream();){
            out.write(bytes);
        }
    }

    private static String receiveResponse(HttpURLConnection conn) throws IOException {
        try (Reader in = StreamUtil.getInputStreamReader((InputStream)conn.getInputStream());){
            String string = StreamUtil.getContent((Reader)in);
            return string;
        }
    }

    public static Object sendJsonRequest(@This URL url, String httpMethod, Object jsonValue) {
        return Json.fromJson(ManUrlExt.sendRequest(url, httpMethod, jsonValue));
    }

    public static Object sendYamlRequest(@This URL url, String httpMethod, Object jsonValue) {
        return Yaml.fromYaml(ManUrlExt.sendRequest(url, httpMethod, jsonValue));
    }

    public static String sendPlainTextRequest(@This URL url, String httpMethod, Object jsonValue) {
        return ManUrlExt.sendRequest(url, httpMethod, jsonValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTextContent(@This URL thiz) {
        try (Reader reader = StreamUtil.getInputStreamReader((InputStream)thiz.openStream());){
            String string = StreamUtil.getContent((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getBinaryContent(@This URL thiz) {
        try (InputStream stream = thiz.openStream();){
            byte[] byArray = StreamUtil.getContent((InputStream)stream);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getJsonContent(@This URL thiz) {
        return Json.fromJson(ManUrlExt.getTextContent(thiz));
    }

    public static Object getYamlContent(@This URL thiz) {
        return Yaml.fromYaml(ManUrlExt.getTextContent(thiz));
    }

    static {
        Object cls = null;
        ReflectionRuntimeMethods.setFieldStatic_Object(HttpURLConnection.class, (String)"methods", (Object)new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE", "PATCH"});
    }
}

