/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.schema.JsonSchemaType;
import manifold.api.json.schema.JsonUnionType;
import manifold.api.json.schema.LazyRefJsonType;
import manifold.api.json.schema.TypeAttributes;

public class JsonListType
extends JsonSchemaType {
    private final State _state = new State();

    public JsonListType(String label, URL source, JsonSchemaType parent, TypeAttributes attr) {
        super(label, source, parent, attr);
        this._state._innerTypes = Collections.emptyMap();
    }

    @Override
    protected void resolveRefsImpl() {
        super.resolveRefsImpl();
        if (this._state._componentType instanceof JsonSchemaType) {
            ((JsonSchemaType)this._state._componentType).resolveRefs();
        } else if (this._state._componentType instanceof LazyRefJsonType) {
            this._state._componentType = ((LazyRefJsonType)this._state._componentType).resolve();
        }
        for (Map.Entry entry : new HashSet(this._state._innerTypes.entrySet())) {
            IJsonType type = (IJsonType)entry.getValue();
            if (type instanceof JsonSchemaType) {
                ((JsonSchemaType)type).resolveRefs();
                continue;
            }
            if (!(type instanceof LazyRefJsonType)) continue;
            this._state._innerTypes.put(entry.getKey(), (IJsonParentType)((LazyRefJsonType)type).resolve());
        }
    }

    @Override
    public String getLabel() {
        return super.getName();
    }

    @Override
    public String getName() {
        return "ListOf" + this.getComponentTypeName();
    }

    private String getComponentTypeName() {
        if (this._state._componentType == null || this._state._componentType instanceof LazyRefJsonType) {
            return "_undefined_";
        }
        return this._state._componentType instanceof JsonUnionType ? "Object" : this._state._componentType.getIdentifier();
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    @Override
    public String getFqn() {
        return this.getName();
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        if (this._state._innerTypes.isEmpty()) {
            this._state._innerTypes = new HashMap();
        }
        this._state._innerTypes.put(name, type);
    }

    @Override
    public IJsonType findChild(String name) {
        IJsonType innerType = (IJsonType)this._state._innerTypes.get(name);
        if (innerType == null) {
            List<IJsonType> definitions;
            if (this._state._componentType instanceof IJsonParentType) {
                innerType = ((IJsonParentType)this._state._componentType).findChild(name);
            }
            if (innerType == null && (definitions = this.getDefinitions()) != null) {
                for (IJsonType child : definitions) {
                    if (!child.getName().equals(name)) continue;
                    innerType = child;
                    break;
                }
            }
        }
        return innerType;
    }

    public IJsonType getComponentType() {
        return this._state._componentType;
    }

    public void setComponentType(IJsonType compType) {
        if (this._state._componentType != null && this._state._componentType != compType) {
            throw new IllegalStateException("Component type already set to: " + this._state._componentType.getIdentifier() + ", which is not the same as: " + compType.getIdentifier());
        }
        this._state._componentType = compType;
    }

    public Map<String, IJsonParentType> getInnerTypes() {
        return this._state._innerTypes;
    }

    @Override
    public JsonListType merge(IJsonType that) {
        if (!(that instanceof JsonListType)) {
            return null;
        }
        JsonListType other = (JsonListType)that;
        JsonListType mergedType = new JsonListType(this.getLabel(), this.getFile(), this.getParent(), this.getTypeAttributes().blendWith(that.getTypeAttributes()));
        if (!this.getComponentType().equalsStructurally(other.getComponentType())) {
            IJsonType componentType = Json.mergeTypes(this.getComponentType(), other.getComponentType());
            if (componentType != null) {
                mergedType.setComponentType(componentType);
            } else {
                return null;
            }
        }
        if (!this.mergeInnerTypes(other, mergedType, this._state._innerTypes)) {
            return null;
        }
        return mergedType;
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        for (IJsonParentType child : this._state._innerTypes.values()) {
            child.render(sb, indent, mutable);
        }
    }

    @Override
    public boolean equalsStructurally(IJsonType o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonListType that = (JsonListType)o;
        if (!this._state._componentType.equalsStructurally(that._state._componentType)) {
            return false;
        }
        return this._state._innerTypes.size() == that._state._innerTypes.size() && this._state._innerTypes.keySet().stream().allMatch(key -> that._state._innerTypes.containsKey(key) && ((IJsonParentType)this._state._innerTypes.get(key)).equalsStructurally((IJsonType)that._state._innerTypes.get(key)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.isSchemaType()) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonListType that = (JsonListType)o;
        if (!this._state._componentType.equals(that._state._componentType)) {
            return false;
        }
        return this._state._innerTypes.equals(that._state._innerTypes);
    }

    @Override
    public int hashCode() {
        int result = this._state._componentType.hashCode();
        result = 31 * result + this._state._innerTypes.hashCode();
        return result;
    }

    private static final class State {
        private IJsonType _componentType;
        private Map<String, IJsonParentType> _innerTypes;

        private State() {
        }
    }
}

