/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonIssue;
import manifold.api.json.JsonListType;
import manifold.api.json.schema.LazyRefJsonType;
import manifold.api.json.schema.TypeAttributes;
import manifold.util.JsonUtil;

public abstract class JsonSchemaType
implements IJsonParentType,
Cloneable {
    private final State _state;
    private TypeAttributes _typeAttributes;

    protected JsonSchemaType(String name, URL source, JsonSchemaType parent, TypeAttributes attr) {
        this._state = new State(name, parent, source);
        this._typeAttributes = attr;
    }

    public abstract String getFqn();

    public final void resolveRefs() {
        if (this._state._resolveState != ResolveState.Unresolved) {
            return;
        }
        this._state._resolveState = ResolveState.Resolving;
        try {
            this.resolveRefsImpl();
        }
        finally {
            this._state._resolveState = ResolveState.Resolved;
        }
    }

    protected void resolveRefsImpl() {
        List<IJsonType> definitions = this.getDefinitions();
        if (definitions != null && !definitions.isEmpty()) {
            ArrayList<IJsonType> resolved = new ArrayList<IJsonType>();
            for (IJsonType type : definitions) {
                if (type instanceof JsonSchemaType) {
                    ((JsonSchemaType)type).resolveRefs();
                } else if (type instanceof LazyRefJsonType) {
                    type = ((LazyRefJsonType)type).resolve();
                }
                resolved.add(type);
            }
            this._state._definitions = resolved;
        }
    }

    protected boolean isParentRoot() {
        return this.getParent() == null || this.getParent().getParent() == null && (this.getParent() instanceof JsonListType || !this.getParent().getName().equals("definitions"));
    }

    public URL getFile() {
        return this._state._file != null ? this._state._file : (this._state._parent != null ? this._state._parent.getFile() : null);
    }

    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this._state._name;
    }

    @Override
    public String getIdentifier() {
        return JsonUtil.makeIdentifier((String)this.getName());
    }

    @Override
    public JsonSchemaType getParent() {
        return this._state._parent;
    }

    public void setParent(IJsonParentType parent) {
        this._state._parent = (JsonSchemaType)parent;
    }

    @Override
    public List<IJsonType> getDefinitions() {
        return this._state._definitions;
    }

    @Override
    public void setDefinitions(List<IJsonType> definitions) {
        this._state._definitions = definitions;
    }

    protected boolean isSchemaType() {
        return this._state._bSchemaType;
    }

    protected void setJsonSchema() {
        this._state._bSchemaType = true;
    }

    @Override
    public TypeAttributes getTypeAttributes() {
        return this._typeAttributes;
    }

    @Override
    public JsonSchemaType copyWithAttributes(TypeAttributes attributes) {
        if (this.getTypeAttributes().equals(attributes)) {
            return this;
        }
        try {
            JsonSchemaType copy = (JsonSchemaType)this.clone();
            copy._typeAttributes = copy._typeAttributes.overrideWith(attributes);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean mergeInnerTypes(IJsonParentType other, IJsonParentType mergedType, Map<String, IJsonParentType> innerTypes) {
        for (Map.Entry<String, IJsonParentType> e : innerTypes.entrySet()) {
            String name = e.getKey();
            IJsonType innerType = other.findChild(name);
            innerType = innerType != null ? Json.mergeTypes(e.getValue(), innerType) : (IJsonType)e.getValue();
            if (innerType != null) {
                mergedType.addChild(name, (IJsonParentType)innerType);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public List<JsonIssue> getIssues() {
        if (this.getParent() != null) {
            return this.getParent().getIssues();
        }
        return this._state._issues;
    }

    @Override
    public void addIssue(JsonIssue issue) {
        if (this.getParent() != null) {
            this.getParent().addIssue(issue);
            return;
        }
        if (this._state._issues.isEmpty()) {
            this._state._issues = new ArrayList();
        }
        this._state._issues.add(issue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaType that = (JsonSchemaType)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    static enum ResolveState {
        Unresolved,
        Resolving,
        Resolved;

    }

    private static class State {
        private final String _name;
        private JsonSchemaType _parent;
        private final URL _file;
        private List<IJsonType> _definitions;
        private List<JsonIssue> _issues;
        private boolean _bSchemaType;
        private ResolveState _resolveState;

        private State(String name, JsonSchemaType parent, URL file) {
            this._name = name;
            this._parent = parent;
            this._file = file;
            this._issues = Collections.emptyList();
            this._resolveState = ResolveState.Unresolved;
        }
    }
}

