/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import manifold.api.json.schema.FormatTypeResolvers;
import manifold.api.json.schema.IJsonFormatTypeResolver;
import manifold.ext.RuntimeMethods;
import manifold.ext.api.IBindingType;
import manifold.ext.api.ICallHandler;
import manifold.ext.api.ICoercionProvider;
import manifold.util.ReflectUtil;

public class DefaultCoercionProvider
implements ICoercionProvider {
    public Object coerce(Object value, Class<?> type) {
        Object enumConst = this.coerceEnum(value, type);
        if (enumConst != ICallHandler.UNHANDLED) {
            return enumConst;
        }
        for (IJsonFormatTypeResolver resolver : FormatTypeResolvers.get()) {
            Object coercedValue = resolver.coerce(value, type);
            if (coercedValue == ICallHandler.UNHANDLED) continue;
            return coercedValue;
        }
        return ICallHandler.UNHANDLED;
    }

    public Object toBindingValue(Object value) {
        if (value instanceof IBindingType) {
            return ((IBindingType)value).toBindingValue();
        }
        for (IJsonFormatTypeResolver resolver : FormatTypeResolvers.get()) {
            Object coercedValue = resolver.toBindingValue(value);
            if (coercedValue == ICallHandler.UNHANDLED) continue;
            return coercedValue;
        }
        return ICallHandler.UNHANDLED;
    }

    private Object coerceEnum(Object value, Class<?> type) {
        if (type.isEnum() && IBindingType.class.isAssignableFrom(type) && IBindingType.class.isAssignableFrom(type)) {
            IBindingType[] values;
            for (IBindingType enumConst : values = (IBindingType[])ReflectUtil.method(type, (String)"values", (Class[])new Class[0]).invokeStatic(new Object[0])) {
                Object coercedValue;
                Object jsonValue = enumConst.toBindingValue();
                if (!jsonValue.equals(coercedValue = RuntimeMethods.coerce((Object)value, jsonValue.getClass()))) continue;
                return enumConst;
            }
        }
        return ICallHandler.UNHANDLED;
    }
}

