/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonSchemaType;
import manifold.api.json.JsonSimpleType;
import manifold.api.json.JsonStructureType;
import manifold.api.json.schema.ArrayTransformer;
import manifold.api.json.schema.ObjectTransformer;
import manifold.api.json.schema.Type;
import manifold.internal.runtime.Bootstrap;
import manifold.util.JsonUtil;
import manifold.util.cache.FqnCache;

public class JsonSchemaTransformer {
    private static final String JSCH_SCHEMA = "$schema";
    private static final String JSCH_TYPE = "type";
    private static final String JSCH_NAME = "name";
    private static final String JSCH_REF = "$ref";
    private static final String JSCH_DEFINITIONS = "definitions";
    private static final String JSCH_PROPERTIES = "properties";
    private static final String JSCH_ENUM = "enum";
    private static final String JSCH_ALL_OF = "allOf";
    private static final String JSCH_ONE_OF = "oneOf";
    private static final Map<URI, FqnCache<IJsonType>> _typesByUri;
    private FqnCache<IJsonType> _typeByFqn = new FqnCache("doc", true, JsonUtil::makeIdentifier);

    private JsonSchemaTransformer() {
    }

    public static boolean isSchema(Bindings bindings) {
        return bindings.get(JSCH_SCHEMA) != null;
    }

    public static IJsonType transform(String name, Bindings docObj) {
        JsonSchemaTransformer.assertSchema(docObj);
        JsonSchemaTransformer transformer = new JsonSchemaTransformer();
        List<IJsonType> definitions = transformer.transformDefinitions(docObj);
        name = name == null || name.isEmpty() ? (String)docObj.get(JSCH_NAME) : name;
        IJsonType type = transformer.transformType(null, name, docObj);
        type.setDefinitions(definitions);
        return type;
    }

    private List<IJsonType> transformDefinitions(Bindings docObj) {
        Bindings definitions = (Bindings)docObj.get(JSCH_DEFINITIONS);
        if (definitions == null) {
            return null;
        }
        JsonStructureType definitionsHolder = new JsonStructureType(null, JSCH_DEFINITIONS);
        ArrayList<IJsonType> result = new ArrayList<IJsonType>();
        this.cache(definitionsHolder);
        for (Map.Entry entry : definitions.entrySet()) {
            String name = (String)entry.getKey();
            Bindings value = (Bindings)entry.getValue();
            IJsonType type = this.transformType(definitionsHolder, name, value);
            result.add(type);
        }
        return result;
    }

    private IJsonType findRef(String localRef) {
        char firstChar = (localRef = localRef.replace('/', '.')).charAt(0);
        if (firstChar == '.' || firstChar == '#') {
            localRef = localRef.substring(1);
        }
        return (IJsonType)this._typeByFqn.get(localRef);
    }

    void cache(JsonSchemaType type) {
        this._typeByFqn.add(this.makeFqn(type), (Object)type);
    }

    private String makeFqn(JsonSchemaType type) {
        String result = "";
        if (type.getParent() != null) {
            result = this.makeFqn(type.getParent());
            result = result + '.';
        }
        return result + JsonUtil.makeIdentifier((String)type.getLabel());
    }

    private static void assertSchema(Bindings docObj) {
        if (docObj.get(JSCH_SCHEMA) == null) {
            throw new IllegalArgumentException("The Json object does not contain a '$schema' element.");
        }
    }

    IJsonType transformType(JsonSchemaType parent, String name, Bindings jsonObj) {
        IJsonType result;
        String type = (String)jsonObj.get(JSCH_TYPE);
        if (type == null) {
            return this.findReferenceType(parent, name, jsonObj);
        }
        if (jsonObj.get(JSCH_ONE_OF) != null) {
            return DynamicType.instance();
        }
        switch (Type.fromName(type)) {
            case Object: {
                if (jsonObj.get(JSCH_REF) != null) {
                    result = this.findReferenceType(parent, name, jsonObj);
                    break;
                }
                result = ObjectTransformer.transform(this, name, parent, jsonObj);
                break;
            }
            case Array: {
                result = ArrayTransformer.transform(this, name, parent, jsonObj);
                break;
            }
            case String: {
                result = JsonSimpleType.String;
                break;
            }
            case Number: {
                result = JsonSimpleType.Double;
                break;
            }
            case Integer: {
                result = JsonSimpleType.Integer;
                break;
            }
            case Boolean: {
                result = JsonSimpleType.Boolean;
                break;
            }
            case Dynamic: 
            case Null: {
                result = DynamicType.instance();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled type: " + type);
            }
        }
        return result;
    }

    private IJsonType findReferenceType(JsonSchemaType parent, String name, Bindings jsonObj) {
        IJsonType result = this.findReference(jsonObj);
        if (result == null && (result = this.transformCombination(parent, name, jsonObj)) == null && (result = this.deriveTypeFromEnum(jsonObj)) == null) {
            result = DynamicType.instance();
        }
        return result;
    }

    private IJsonType deriveTypeFromEnum(Bindings bindings) {
        List list = (List)bindings.get(JSCH_ENUM);
        if (list == null) {
            return null;
        }
        IJsonType type = null;
        for (Object elem : list) {
            IJsonType csr = Json.transformJsonObject("", null, elem);
            if (type == null) {
                type = csr;
                continue;
            }
            if (type.equals(csr)) continue;
            type = DynamicType.instance();
        }
        return type;
    }

    private IJsonType transformCombination(JsonSchemaType parent, String name, Bindings jsonObj) {
        List list = (List)jsonObj.get(JSCH_ALL_OF);
        if (list == null) {
            return null;
        }
        JsonStructureType type = this.buildHierarchy(parent, name, list);
        if (type != null) {
            for (Object elem : list) {
                if (!(elem instanceof Bindings)) continue;
                Bindings elemBindings = (Bindings)elem;
                Bindings properties = (Bindings)elemBindings.get(JSCH_PROPERTIES);
                if (properties == null) break;
                ObjectTransformer.transform(this, type, elemBindings);
                break;
            }
        }
        return type;
    }

    private JsonStructureType buildHierarchy(JsonSchemaType parent, String name, List list) {
        JsonStructureType type = null;
        for (Object elem : list) {
            Bindings elemBindings;
            IJsonType ref;
            if (!(elem instanceof Bindings) || (ref = this.findReference(elemBindings = (Bindings)elem)) == null) continue;
            if (type == null) {
                type = new JsonStructureType(parent, name);
            }
            type.addSuper((IJsonParentType)ref);
        }
        return type;
    }

    private IJsonType findReference(Bindings jsonObj) {
        String ref = (String)jsonObj.get(JSCH_REF);
        if (ref == null) {
            return null;
        }
        try {
            String fragment;
            URI uri = new URI(ref);
            String scheme = uri.getSchemeSpecificPart();
            if (scheme != null) {
                // empty if block
            }
            if ((fragment = uri.getFragment()) != null) {
                return this.findRef(fragment);
            }
            throw new UnsupportedOperationException("Unhandled URI: " + ref);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Bootstrap.init();
        _typesByUri = new ConcurrentHashMap<URI, FqnCache<IJsonType>>();
    }
}

