/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.extensions.javax.script.Bindings;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import manifold.api.json.Json;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.json.extensions.java.net.URL.ManUrlExt;
import manifold.util.JsonUtil;
import manifold.util.Pair;

@Extension
public class ManBindingsExt {
    public static String toJson(@This Bindings thiz) {
        StringBuilder sb = new StringBuilder();
        ManBindingsExt.toJson(thiz, sb, 0);
        return sb.toString();
    }

    public static void toJson(@This Bindings thiz, StringBuilder target, int indent) {
        int iKey = 0;
        if (ManBindingsExt.isNewLine(target)) {
            ManBindingsExt.indent(target, indent);
        }
        if (thiz.size() > 0) {
            target.append("{\n");
            for (String key : thiz.keySet()) {
                ManBindingsExt.indent(target, indent + 2);
                target.append('\"').append(key).append('\"').append(": ");
                Object value = thiz.get(key);
                JsonUtil.toJson((StringBuilder)target, (int)indent, (Object)value);
                ManBindingsExt.appendCommaNewLine(target, iKey < thiz.size() - 1);
                ++iKey;
            }
        }
        ManBindingsExt.indent(target, indent);
        target.append("}");
    }

    private static boolean isNewLine(StringBuilder sb) {
        return sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n';
    }

    public static void listToJson(StringBuilder target, int indent, List value) {
        target.append('[');
        if (value.size() > 0) {
            target.append("\n");
            int iSize = value.size();
            for (int i = 0; i < iSize; ++i) {
                Object comp = value.get(i);
                if (comp instanceof Pair) {
                    comp = ((Pair)comp).getSecond();
                }
                if (comp instanceof Bindings) {
                    ManBindingsExt.toJson((Bindings)comp, target, indent + 4);
                } else if (comp instanceof List) {
                    ManBindingsExt.listToJson(target, indent + 4, (List)comp);
                } else {
                    ManBindingsExt.indent(target, indent + 4);
                    JsonUtil.appendValue((StringBuilder)target, comp);
                }
                ManBindingsExt.appendCommaNewLine(target, i < iSize - 1);
            }
        }
        ManBindingsExt.indent(target, indent + 2);
        target.append("]");
    }

    public static String listToJson(List list) {
        StringBuilder sb = new StringBuilder();
        ManBindingsExt.listToJson(sb, 0, list);
        return sb.toString();
    }

    public static String toXml(@This Bindings thiz) {
        return ManBindingsExt.toXml(thiz, "object");
    }

    public static String toXml(@This Bindings thiz, String name) {
        StringBuilder sb = new StringBuilder();
        ManBindingsExt.toXml(thiz, name, sb, 0);
        return sb.toString();
    }

    public static void toXml(@This Bindings thiz, String name, StringBuilder target, int indent) {
        ManBindingsExt.indent(target, indent);
        target.append('<').append(name);
        if (thiz.size() > 0) {
            target.append(">\n");
            for (String key : thiz.keySet()) {
                Object value = thiz.get(key);
                if (value instanceof Pair) {
                    value = ((Pair)value).getSecond();
                }
                if (value instanceof Bindings) {
                    ManBindingsExt.toXml((Bindings)value, key, target, indent + 2);
                    continue;
                }
                if (value instanceof List) {
                    int len = ((List)value).size();
                    ManBindingsExt.indent(target, indent + 2);
                    target.append("<").append(key);
                    if (len > 0) {
                        target.append(">\n");
                        for (Object comp : (List)value) {
                            if (comp instanceof Pair) {
                                comp = ((Pair)comp).getSecond();
                            }
                            if (comp instanceof Bindings) {
                                ManBindingsExt.toXml((Bindings)comp, "li", target, indent + 4);
                                continue;
                            }
                            ManBindingsExt.indent(target, indent + 4);
                            target.append("<li>").append(comp).append("</li>\n");
                        }
                        ManBindingsExt.indent(target, indent + 2);
                        target.append("</").append(key).append(">\n");
                        continue;
                    }
                    target.append("/>\n");
                    continue;
                }
                ManBindingsExt.indent(target, indent + 2);
                target.append('<').append(key).append(">");
                target.append(value);
                target.append("</").append(key).append(">\n");
            }
            ManBindingsExt.indent(target, indent);
            target.append("</").append(name).append(">\n");
        } else {
            target.append("/>\n");
        }
    }

    public static URL makeUrl(@This Bindings thiz, String url) {
        return ManUrlExt.makeUrl(url, thiz);
    }

    public static Bindings postForJsonContent(@This Bindings thiz, String url) {
        try {
            return Json.fromJson(ManUrlExt.postForTextContent(new URL(url), thiz));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Bindings getJsonContent(@This Bindings thiz, String url) {
        return Json.fromJson(ManUrlExt.getTextContent(ManBindingsExt.makeUrl(thiz, url)));
    }

    public static String makeArguments(@This Bindings arguments) {
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : arguments.entrySet()) {
                if (sb.length() != 0) {
                    sb.append('&');
                }
                sb.append(URLEncoder.encode((String)entry.getKey(), "UTF-8")).append('=').append(ManBindingsExt.makeValue(entry.getValue()));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Extension
    public static String makeValue(Object value) {
        if (value instanceof Bindings) {
            value = JsonUtil.toJson((Bindings)((Bindings)value));
        } else if (value instanceof List) {
            value = JsonUtil.listToJson((List)((List)value));
        }
        try {
            return URLEncoder.encode(value.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void appendCommaNewLine(StringBuilder sb, boolean bComma) {
        if (bComma) {
            sb.append(',');
        }
        sb.append("\n");
    }

    private static void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }
}

