/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonStructureType;
import manifold.api.json.schema.JsonEnumType;
import manifold.api.json.schema.JsonSchemaType;
import manifold.api.json.schema.LazyRefJsonType;
import manifold.api.json.schema.TypeAttributes;
import manifold.util.concurrent.LocklessLazyVar;

public class JsonUnionType
extends JsonStructureType {
    private LocklessLazyVar<JsonEnumType> _collapsedEnumType = LocklessLazyVar.make(() -> {
        if (!this.getMembers().isEmpty()) {
            return null;
        }
        if (this.getConstituents().stream().allMatch(e -> e instanceof JsonEnumType)) {
            return this.makeEnumType(this.getConstituents());
        }
        return null;
    });
    private final State _state = new State();

    public JsonUnionType(JsonSchemaType parent, URL source, String name, TypeAttributes attr) {
        super(parent, source, name, attr);
        this._state._constituentTypes = Collections.emptyMap();
    }

    @Override
    protected void resolveRefsImpl() {
        super.resolveRefsImpl();
        for (Map.Entry entry : new HashSet(this._state._constituentTypes.entrySet())) {
            IJsonType type = (IJsonType)entry.getValue();
            if (type instanceof JsonSchemaType) {
                ((JsonSchemaType)type).resolveRefs();
                continue;
            }
            if (!(type instanceof LazyRefJsonType)) continue;
            type = ((LazyRefJsonType)type).resolve();
            this._state._constituentTypes.put(entry.getKey(), type);
        }
    }

    public Collection<? extends IJsonType> getConstituents() {
        return this._state._constituentTypes.values();
    }

    void addConstituent(String name, IJsonType type) {
        if (this._state._constituentTypes.isEmpty()) {
            this._state._constituentTypes = new HashMap();
        }
        this._state._constituentTypes.put(name, type);
        if (type instanceof IJsonParentType && !this.isDefinition(type)) {
            super.addChild(name, (IJsonParentType)type);
        }
    }

    private boolean isDefinition(IJsonType type) {
        return type.getParent() != null && type.getParent().getName().equals("definitions");
    }

    @Override
    public JsonUnionType merge(IJsonType type) {
        IJsonType c;
        IJsonType mergedType = null;
        Iterator<? extends IJsonType> iterator = this.getConstituents().iterator();
        while (iterator.hasNext() && ((mergedType = Json.mergeTypesNoUnion(c = iterator.next(), type)) == null || mergedType == DynamicType.instance())) {
        }
        if (mergedType == null) {
            mergedType = type;
        }
        this.addConstituent(mergedType.getName(), mergedType);
        return this;
    }

    public JsonEnumType getCollapsedEnumType() {
        return (JsonEnumType)this._collapsedEnumType.get();
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        JsonEnumType collapsedEnumType = this.getCollapsedEnumType();
        if (collapsedEnumType != null) {
            collapsedEnumType.render(sb, indent, mutable);
            return;
        }
        super.render(sb, indent, mutable);
    }

    private final class State {
        private Map<String, IJsonType> _constituentTypes;

        private State() {
        }
    }
}

