/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.net.URL;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptException;
import manifold.api.host.IManifoldHost;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonParser;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonListType;
import manifold.api.json.JsonSimpleType;
import manifold.api.json.JsonStructureType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonSchemaTransformer;
import manifold.api.json.schema.JsonSchemaTransformerSession;
import manifold.api.json.schema.JsonSchemaType;
import manifold.api.json.schema.JsonUnionType;
import manifold.util.Pair;
import manifold.util.concurrent.LocklessLazyVar;

public class Json {
    private static String _parser = System.getProperty("gosu.json.parser");
    private static final LocklessLazyVar<IJsonParser> PARSER = new LocklessLazyVar<IJsonParser>(){

        protected IJsonParser init() {
            String fqn = Json.getParserName();
            return fqn == null ? IJsonParser.getDefaultParser() : this.makeParser(fqn);
        }

        private IJsonParser makeParser(String fqn) {
            try {
                return (IJsonParser)Class.forName(fqn).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static String getParserName() {
        return _parser;
    }

    public static void setParserName(String fqn) {
        _parser = fqn;
        PARSER.clear();
    }

    public static Bindings fromJson(String json) {
        return Json.fromJson(json, false, false);
    }

    public static Bindings fromJson(String json, boolean withBigNumbers, boolean withTokens) {
        try {
            return ((IJsonParser)PARSER.get()).parseJson(json, withBigNumbers, withTokens);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public static String makeStructureTypes(IManifoldHost host, String nameForStructure, Bindings bindings, boolean mutable) {
        JsonStructureType type = (JsonStructureType)Json.transformJsonObject(host, nameForStructure, null, bindings);
        StringBuilder sb = new StringBuilder();
        type.render(sb, 0, mutable);
        return sb.toString();
    }

    public static IJsonType transformJsonObject(IManifoldHost host, String name, JsonSchemaType parent, Object jsonObj) {
        return Json.transformJsonObject(host, name, null, parent, jsonObj);
    }

    public static IJsonType transformJsonObject(IManifoldHost host, String name, URL source, JsonSchemaType parent, Object jsonObj) {
        IJsonType type = null;
        if (parent != null) {
            type = parent.findChild(name);
        }
        if (jsonObj instanceof Pair) {
            jsonObj = ((Pair)jsonObj).getSecond();
        }
        if (jsonObj == null) {
            return DynamicType.instance();
        }
        if (jsonObj instanceof Bindings) {
            if (JsonSchemaTransformer.isSchema((Bindings)jsonObj)) {
                type = JsonSchemaTransformer.transform(host, name, source, (Bindings)jsonObj);
            } else {
                if (!(type instanceof JsonStructureType)) {
                    type = new JsonStructureType(parent, source, name);
                }
                for (Object k : ((Bindings)jsonObj).keySet()) {
                    IJsonType memberType;
                    String key = (String)k;
                    Object value = ((Bindings)jsonObj).get(key);
                    Token token = null;
                    if (value instanceof Pair) {
                        token = ((Token[])((Pair)value).getFirst())[0];
                    }
                    if ((memberType = Json.transformJsonObject(host, key, (JsonSchemaType)type, value)) == null) continue;
                    ((JsonStructureType)type).addMember(key, memberType, token);
                }
                if (parent != null) {
                    parent.addChild(name, (IJsonParentType)type);
                }
            }
        } else if (jsonObj instanceof List) {
            if (!(type instanceof JsonListType)) {
                type = new JsonListType(name, source, parent);
            }
            IJsonType compType = ((JsonListType)type).getComponentType();
            if (!((List)jsonObj).isEmpty()) {
                int i = 0;
                boolean isDissimilar = Json.isDissimilar((List)jsonObj);
                for (Object elem : (List)jsonObj) {
                    IJsonType csr = Json.transformJsonObject(host, name + (isDissimilar ? Integer.valueOf(i++) : ""), (JsonSchemaType)type, elem);
                    if (compType != null && csr != compType && compType != DynamicType.instance()) {
                        csr = Json.mergeTypes(compType, csr);
                    }
                    compType = csr;
                }
            } else if (compType == null) {
                System.out.println("\nWarning: there are no sample elements in list: " + name + "\nThe component type for this list will be Dynamic.\n");
                compType = DynamicType.instance();
            }
            ((JsonListType)type).setComponentType(compType);
            if (parent != null) {
                parent.addChild(name, (IJsonParentType)type);
            }
        } else {
            type = JsonSimpleType.get(jsonObj);
        }
        if (parent == null && type instanceof JsonSchemaType) {
            ((JsonSchemaType)type).resolveRefs();
            JsonSchemaTransformerSession.instance().maybeClear();
        }
        return type;
    }

    private static boolean isDissimilar(List jsonObj) {
        Class<?> type = null;
        for (Object o : jsonObj) {
            Class<?> csr;
            if (type == null) {
                type = o == null ? null : o.getClass();
                continue;
            }
            Class<?> clazz = csr = o == null ? null : o.getClass();
            if (csr != null && csr != type) {
                return true;
            }
            type = csr;
        }
        return false;
    }

    public static IJsonType mergeTypes(IJsonType type1, IJsonType type2) {
        IJsonType mergedType = Json.mergeTypesNoUnion(type1, type2);
        if (mergedType == null && type1.getParent() instanceof JsonListType) {
            JsonListType listType = (JsonListType)type1.getParent();
            JsonUnionType unionType = new JsonUnionType(listType, listType.getFile(), "UnionType");
            unionType.merge(type1);
            unionType.merge(type2);
            mergedType = unionType;
        }
        if (mergedType != null) {
            return mergedType;
        }
        throw new RuntimeException("Incompatible types: " + type1.getIdentifier() + " vs: " + type2.getIdentifier());
    }

    public static IJsonType mergeTypesNoUnion(IJsonType type1, IJsonType type2) {
        if (type1 == null && type2 != null) {
            return type2;
        }
        if (type2 == null && type1 != null) {
            return type1;
        }
        if (type1.equalsStructurally(type2)) {
            return type1;
        }
        if (type1 == DynamicType.instance()) {
            return type2;
        }
        if (type2 == DynamicType.instance()) {
            return type1;
        }
        IJsonType mergedType = null;
        if (type1 instanceof JsonSimpleType && type2 instanceof JsonSimpleType) {
            mergedType = ((JsonSimpleType)type1).merge((JsonSimpleType)type2);
        } else if (type1 instanceof JsonStructureType && type2 instanceof JsonStructureType) {
            mergedType = ((JsonStructureType)type1).merge((JsonStructureType)type2);
        } else if (type1 instanceof JsonListType && type2 instanceof JsonListType) {
            mergedType = ((JsonListType)type1).merge((JsonListType)type2);
        } else if (type1 instanceof JsonUnionType) {
            mergedType = ((JsonUnionType)type1).merge(type2);
        } else if (type2 instanceof JsonUnionType) {
            mergedType = ((JsonUnionType)type2).merge(type1);
        }
        return mergedType;
    }
}

