/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.json.IJsonParentType;
import manifold.api.json.Json;
import manifold.api.json.JsonIssueContainer;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.internal.runtime.Bootstrap;
import manifold.util.JavacDiagnostic;

class JsonModel
extends AbstractSingleFileModel {
    private IJsonParentType _type;
    private JsonIssueContainer _issues;

    public JsonModel(String fqn, Set<IFile> files) {
        super(fqn, files);
        this.init();
    }

    private void init() {
        Bindings bindings;
        try {
            bindings = Json.fromJson(ResourceFileTypeManifold.getContent((IFile)this.getFile()));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof ScriptException) {
                this._issues = new JsonIssueContainer((ScriptException)cause, this.getFile());
            }
            bindings = new SimpleBindings();
        }
        this._type = (IJsonParentType)Json.transformJsonObject(this.getFile().getBaseName(), null, bindings);
    }

    public IJsonParentType getType() {
        return this._type;
    }

    public void updateFile(IFile file) {
        super.updateFile(file);
        this.init();
    }

    void report(DiagnosticListener<JavaFileObject> errorHandler) {
        if (this._issues == null || errorHandler == null) {
            return;
        }
        SourceJavaFileObject file = new SourceJavaFileObject(this.getFile().toURI());
        for (IIssue issue : this._issues.getIssues()) {
            Diagnostic.Kind kind = issue.getKind() == IIssue.Kind.Error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic((JavaFileObject)file, kind, (long)issue.getStartOffset(), (long)issue.getLine(), (long)issue.getColumn(), issue.getMessage()));
        }
    }

    static {
        Bootstrap.init();
    }
}

