/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.ExtIssueMsg;
import manifold.api.fs.IFile;
import manifold.api.fs.cache.PathCache;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcRawStatement;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcType;
import manifold.api.host.IModule;
import manifold.api.type.ITypeManifold;
import manifold.api.util.JavacDiagnostic;
import manifold.api.util.JavacUtil;
import manifold.ext.ExtensionManifold;
import manifold.ext.IExtensionClassProducer;
import manifold.ext.Model;
import manifold.ext.StaticStructuralTypeProxyGenerator;
import manifold.ext.rt.ExtensionMethod;
import manifold.ext.rt.ForwardingExtensionMethod;
import manifold.ext.rt.api.Expires;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.ExtensionMethodType;
import manifold.ext.rt.api.ExtensionSource;
import manifold.ext.rt.api.Intercept;
import manifold.ext.rt.api.This;
import manifold.ext.rt.api.ThisClass;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.JavacPlugin;
import manifold.rt.api.Array;
import manifold.rt.api.anno.any;
import manifold.rt.api.util.Pair;

class ExtCodeGen {
    public static final String GENERATEDPROXY_ = "generatedproxy_";
    public static final String OF_ = "_Of_";
    public static final String TO_ = "_To_";
    private JavaFileManager.Location _location;
    private final Model _model;
    private final String _fqn;
    private final boolean _genStubs;
    private String _existingSource;

    ExtCodeGen(JavaFileManager.Location location, Model model, String topLevelFqn, boolean genStubs, String existingSource) {
        this._location = location;
        this._model = model;
        this._fqn = topLevelFqn;
        this._genStubs = genStubs;
        this._existingSource = existingSource;
    }

    private IModule getModule() {
        return this._model.getTypeManifold().getModule();
    }

    String make(JavaFileManager.Location location, DiagnosticListener<JavaFileObject> errorHandler) {
        SrcClass srcExtended;
        if (this.isProxyFactory()) {
            return this.generateProxyFactory();
        }
        if (!this._existingSource.isEmpty()) {
            srcExtended = this.makeStubFromSource();
        } else {
            srcExtended = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(this._fqn, location, errorHandler);
            srcExtended.setBinary(true);
        }
        return this.addExtensions(srcExtended, errorHandler);
    }

    private boolean isProxyFactory() {
        return this._fqn.contains(GENERATEDPROXY_) && this._fqn.contains(OF_) && this._fqn.contains(TO_);
    }

    private String generateProxyFactory() {
        int genIndex = this._fqn.indexOf(GENERATEDPROXY_);
        String pkg = this._fqn.substring(0, genIndex - 1);
        String name = this._fqn.substring(genIndex);
        int ofIndex = this._fqn.indexOf(OF_, genIndex += GENERATEDPROXY_.length());
        String baseExtensionName = this._fqn.substring(genIndex, ofIndex);
        String extensionFqn = pkg + '.' + baseExtensionName;
        Symbol.ClassSymbol extensionSym = this.getExtensionSym(extensionFqn);
        Type ifaceType = this.getInterfaceType(ofIndex, extensionSym);
        Symbol.ClassSymbol extendedSym = this.getExtendedSym(pkg);
        Pair<String, String> fqnToCode = StaticStructuralTypeProxyGenerator.makeProxy(name, ifaceType, extendedSym, pkg, this.getModule());
        return (String)fqnToCode.getSecond();
    }

    private Symbol.ClassSymbol getExtendedSym(String pkg) {
        int extentionsIndex = pkg.indexOf("extensions.");
        if (extentionsIndex < 0) {
            throw new IllegalStateException("'extensions' package missing from extension auto proxy name");
        }
        String extendedType = pkg.substring(extentionsIndex + "extensions".length() + 1);
        Pair pair2 = ClassSymbols.instance((IModule)this.getModule()).getClassSymbol(JavacPlugin.instance().getJavacTask(), extendedType);
        if (pair2 == null || pair2.getFirst() == null) {
            throw new IllegalStateException("Failed to load extended type ClassSymbol for proxy: " + this._fqn);
        }
        Symbol.ClassSymbol extendedSym = (Symbol.ClassSymbol)pair2.getFirst();
        return extendedSym;
    }

    private Type getInterfaceType(int ofIndex, Symbol.ClassSymbol extensionSym) {
        int toIndex = this._fqn.indexOf(TO_, ofIndex);
        String baseIfaceName = this._fqn.substring(toIndex + TO_.length());
        Type ifaceType = null;
        for (Type csr : extensionSym.getInterfaces()) {
            if (!((Name)csr.tsym.getSimpleName()).toString().equals(baseIfaceName)) continue;
            ifaceType = csr;
            break;
        }
        if (ifaceType == null) {
            throw new IllegalStateException("Failed to load implemented interface ClassSymbol for proxy: " + this._fqn);
        }
        return ifaceType;
    }

    private Symbol.ClassSymbol getExtensionSym(String extensionFqn) {
        Pair pair = ClassSymbols.instance((IModule)this.getModule()).getClassSymbol(JavacPlugin.instance().getJavacTask(), extensionFqn);
        if (pair == null || pair.getFirst() == null) {
            throw new IllegalStateException("Failed to get extension class symbol: " + extensionFqn);
        }
        Symbol.ClassSymbol extensionSym = (Symbol.ClassSymbol)pair.getFirst();
        return extensionSym;
    }

    private SrcClass makeStubFromSource() {
        ArrayList trees = new ArrayList();
        this._model.getHost().getJavaParser().parseText(this._existingSource, trees, null, null, null);
        JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)((CompilationUnitTree)trees.get(0)).getTypeDecls().get(0);
        SrcClass srcExtended = (SrcClass)new SrcClass(this._fqn, AbstractSrcClass.Kind.from((Tree.Kind)classDecl.getKind())).modifiers(classDecl.getModifiers().getFlags());
        if (classDecl.extending != null) {
            srcExtended.superClass(classDecl.extending.toString());
        }
        for (JCTree.JCExpression iface : classDecl.implementing) {
            srcExtended.addInterface(iface.toString());
        }
        return srcExtended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addExtensions(SrcClass extendedClass, DiagnosticListener<JavaFileObject> errorHandler) {
        boolean methodExtensions = false;
        boolean interfaceExtensions = false;
        boolean annotationExtensions = false;
        Set<String> allExtensions = this.findAllExtensions();
        this._model.pushProcessing(this._fqn);
        try {
            String string;
            Iterator<String> iterator = allExtensions.iterator();
            while (iterator.hasNext()) {
                String extensionFqn = iterator.next();
                SrcClass srcExtension = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(extensionFqn);
                if (srcExtension != null) {
                    for (AbstractSrcMethod method : srcExtension.getMethods()) {
                        this.addExtensionMethod(method, extendedClass, errorHandler, false);
                        methodExtensions = true;
                    }
                    for (SrcType iface : srcExtension.getInterfaces()) {
                        this.addExtensionInteface(iface, extendedClass);
                        interfaceExtensions = true;
                    }
                    for (SrcAnnotationExpression anno : srcExtension.getAnnotations()) {
                        this.addExtensionAnnotation(anno, extendedClass);
                        annotationExtensions = true;
                        this.addExtensionSourceAnnotation(anno, extendedClass, errorHandler);
                    }
                    continue;
                }
                iterator.remove();
            }
            if (!this._existingSource.isEmpty()) {
                if (allExtensions.isEmpty()) {
                    string = this._existingSource;
                    return string;
                }
                string = this.addExtensionsToExistingClass(extendedClass, methodExtensions, interfaceExtensions, annotationExtensions);
                return string;
            }
            string = extendedClass.render(new StringBuilder(), 0).toString();
            return string;
        }
        finally {
            this._model.popProcessing(this._fqn);
        }
    }

    private void addExtensionSourceAnnotation(SrcAnnotationExpression anno, SrcClass extendedClass, DiagnosticListener<JavaFileObject> errorHandler) {
        if (!anno.getAnnotationType().equals(ExtensionSource.class.getName())) {
            return;
        }
        UnaryOperator getFqnFromClass = className -> className.substring(0, className.lastIndexOf(".class"));
        String source = anno.getArgument("source").getValue().toString();
        SrcClass srcClass = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub((String)getFqnFromClass.apply(source));
        SrcArgument overwriteExistingMethodsArg = anno.getArgument("overrideExistingMethods");
        boolean overrideExistingMethods = overwriteExistingMethodsArg != null && Boolean.parseBoolean(overwriteExistingMethodsArg.getValue().toString());
        SrcArgument typeArg = anno.getArgument("type");
        ExtensionMethodType type = typeArg == null ? ExtensionMethodType.EXCLUDE : ExtensionMethodType.valueOf((String)typeArg.getValue().toString().substring(typeArg.getValue().toString().lastIndexOf(46) + 1));
        SrcArgument methodsArg = anno.getArgument("methods");
        ArrayList methodDefinitions = new ArrayList();
        if (methodsArg != null) {
            ((SrcAnnotationExpression)methodsArg.getValue()).getArguments().forEach(methodDefinitionArg -> {
                List paramTypes;
                SrcAnnotationExpression methodDefinition = (SrcAnnotationExpression)methodDefinitionArg.getValue();
                String methodNameExpr = methodDefinition.getArgument("name").getValue().toString();
                methodNameExpr = methodNameExpr.substring(1, methodNameExpr.length() - 1);
                if (methodDefinition.getArgument("paramTypes") == null) {
                    paramTypes = null;
                } else {
                    List paramTypeArgs = ((SrcAnnotationExpression)methodDefinition.getArgument("paramTypes").getValue()).getArguments();
                    paramTypes = paramTypeArgs.stream().map(paramType -> (String)getFqnFromClass.apply(paramType.getValue().toString())).collect(Collectors.toList());
                }
                methodDefinitions.add(new SimpleMethodSignature(methodNameExpr, paramTypes));
            });
        }
        for (AbstractSrcMethod method : srcClass.getMethods()) {
            if (method.getParameters().isEmpty() || !((SrcParameter)method.getParameters().get(0)).getType().getFqName().equals(this._fqn)) continue;
            Optional<SimpleMethodSignature> configuredMethod = methodDefinitions.stream().filter(methodDef -> methodDef.isSameAs(method)).findAny();
            if (type == ExtensionMethodType.EXCLUDE && configuredMethod.isPresent() || type == ExtensionMethodType.INCLUDE && !configuredMethod.isPresent()) continue;
            ((SrcParameter)method.getParameters().get(0)).addAnnotation(This.class);
            AbstractSrcMethod duplicate = this.findMethod(method, extendedClass);
            if (duplicate != null) {
                if (!overrideExistingMethods) continue;
                method.addAnnotation(Intercept.class);
            }
            this.addExtensionMethod(method, extendedClass, errorHandler, true);
        }
    }

    private String addExtensionsToExistingClass(SrcClass srcClass, boolean methodExtensions, boolean interfaceExtensions, boolean annotationExtensions) {
        StringBuilder sb = new StringBuilder();
        if (methodExtensions) {
            this.addExtensionMethodsToExistingClass(srcClass, sb);
        }
        if (interfaceExtensions) {
            this.addExtensionInterfacesToExistingClass(srcClass, sb);
        }
        if (annotationExtensions) {
            this.addExtensionAnnotationsToExistingClass(srcClass, sb);
        }
        return sb.toString();
    }

    private void addExtensionInterfacesToExistingClass(SrcClass srcClass, StringBuilder sb) {
        String start = (srcClass.isInterface() ? "interface " : (srcClass.getKind() == AbstractSrcClass.Kind.Record ? "record " : "class ")) + srcClass.getSimpleName();
        int iStart = sb.indexOf(start);
        int iBrace = sb.indexOf("{", iStart);
        StringBuilder sbSrcClass = new StringBuilder();
        srcClass.render(sbSrcClass, 0);
        int iSrcClassStart = sbSrcClass.indexOf(start);
        int iSrcClassBrace = sbSrcClass.indexOf("{", iSrcClassStart);
        String fromSrcClass = sbSrcClass.substring(iSrcClassStart, iSrcClassBrace);
        sb.replace(iStart, iBrace, fromSrcClass);
    }

    private void addExtensionAnnotationsToExistingClass(SrcClass srcClass, StringBuilder sb) {
        int iStart;
        if (srcClass.getAnnotations().isEmpty()) {
            return;
        }
        StringBuilder sbAnnos = new StringBuilder();
        for (SrcAnnotationExpression anno : srcClass.getAnnotations()) {
            anno.render(sbAnnos, 0).append('\n');
        }
        String start = (srcClass.isInterface() ? "interface " : (srcClass.getKind() == AbstractSrcClass.Kind.Record ? "record " : "class ")) + srcClass.getSimpleName();
        for (iStart = sb.indexOf(start); iStart != 0 && sb.charAt(iStart) != '\n'; --iStart) {
        }
        if (sb.charAt(iStart) == '\n') {
            ++iStart;
        }
        sb.insert(iStart, sbAnnos);
    }

    private void addExtensionMethodsToExistingClass(SrcClass srcClass, StringBuilder sb) {
        int iBrace = this._existingSource.lastIndexOf(125);
        sb.append(this._existingSource, 0, iBrace);
        for (AbstractSrcMethod method : srcClass.getMethods()) {
            method.render(sb, 2);
        }
        sb.append("\n}");
    }

    private Set<String> findAllExtensions() {
        if (this._model.isProcessing(this._fqn)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> fqns = new LinkedHashSet<String>();
        this.findExtensionsOnDisk(fqns);
        this.findExtensionsFromExtensionClassProviders(fqns);
        return fqns;
    }

    private void findExtensionsOnDisk(Set<String> fqns) {
        PathCache pathCache = this.getModule().getPathCache();
        for (IFile file : this._model.getFiles()) {
            Set fqn = pathCache.getFqnForFile(file);
            for (String f : fqn) {
                if (f == null) continue;
                String innerExtFqn = this.findInnerClassInExtension(f);
                fqns.add(innerExtFqn);
            }
        }
    }

    private String findInnerClassInExtension(String extensionFqn) {
        String toplevel = this._model.getFqn();
        if (toplevel.length() == this._fqn.length()) {
            return extensionFqn;
        }
        int index = this._fqn.indexOf(toplevel);
        if (index >= 0) {
            return extensionFqn + this._fqn.substring(toplevel.length());
        }
        return extensionFqn;
    }

    private void findExtensionsFromExtensionClassProviders(Set<String> fqns) {
        ExtensionManifold extensionManifold = this._model.getTypeManifold();
        for (ITypeManifold tm : extensionManifold.getModule().getTypeManifolds()) {
            if (tm == extensionManifold || !(tm instanceof IExtensionClassProducer)) continue;
            Set<String> extensionClasses = ((IExtensionClassProducer)tm).getExtensionClasses(this._model.getFqn());
            extensionClasses = extensionClasses.stream().map(e -> this.findInnerClassInExtension((String)e)).collect(Collectors.toSet());
            fqns.addAll(extensionClasses);
        }
    }

    private void addExtensionInteface(SrcType iface, SrcClass extendedType) {
        extendedType.addInterface(iface);
    }

    private void addExtensionAnnotation(SrcAnnotationExpression anno, SrcClass extendedType) {
        if (anno.getAnnotationType().equals(Extension.class.getName()) || anno.getAnnotationType().equals(ExtensionSource.class.getName())) {
            return;
        }
        if (extendedType.getAnnotations().stream().noneMatch(e -> e.getAnnotationType().equals(anno.getAnnotationType()))) {
            extendedType.addAnnotation(anno.copy());
        }
    }

    private void addExtensionMethod(AbstractSrcMethod<?> method, SrcClass extendedType, DiagnosticListener<JavaFileObject> errorHandler, boolean isExtensionSource) {
        AbstractSrcMethod srcMethod;
        boolean isInterceptMethod;
        if (!this.isExtensionMethod(method, extendedType)) {
            return;
        }
        boolean delegateCalls = !this._existingSource.isEmpty() && !this._genStubs;
        boolean isInstanceExtensionMethod = this.isInstanceExtensionMethod(method, extendedType);
        boolean bl = isInterceptMethod = method.getAnnotation(Intercept.class) != null;
        if (isInterceptMethod) {
            srcMethod = this.findMethod(method, extendedType);
            if (srcMethod == null) {
                errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic(null, Diagnostic.Kind.ERROR, 0L, 0L, 0L, ExtIssueMsg.MSG_INTERCEPTION_NOT_FOUND.get(new Object[]{method.signature(), ((SrcClass)method.getOwner()).getName(), extendedType.getName()})));
                return;
            }
        } else {
            int firstParam;
            int i;
            if (this.warnIfDuplicate(method, extendedType, errorHandler)) {
                return;
            }
            srcMethod = new SrcMethod((AbstractSrcClass)extendedType);
            long modifiers = method.getModifiers();
            if (extendedType.isInterface() && isInstanceExtensionMethod) {
                modifiers |= 0x80000000000L;
            }
            if (isInstanceExtensionMethod) {
                modifiers &= 0xFFFFFFFFFFFFFFF7L;
            }
            srcMethod.modifiers(modifiers);
            srcMethod.returns(method.getReturnType());
            String name = method.getSimpleName();
            srcMethod.name(name);
            List typeParams = method.getTypeVariables();
            int extendedTypeVarCount = extendedType.getTypeVariables().size();
            int n = i = isInstanceExtensionMethod ? extendedTypeVarCount : 0;
            while (i < typeParams.size()) {
                SrcType typeVar = (SrcType)typeParams.get(i);
                srcMethod.addTypeVar(typeVar);
                ++i;
            }
            List params = method.getParameters();
            for (int i2 = firstParam = isInstanceExtensionMethod || this.hasThisClassAnnotation(method) ? 1 : 0; i2 < params.size(); ++i2) {
                SrcParameter param = (SrcParameter)params.get(i2);
                SrcParameter p = new SrcParameter(param.getSimpleName(), param.getType());
                for (SrcAnnotationExpression anno : param.getAnnotations()) {
                    p.addAnnotation(anno);
                }
                srcMethod.addParam(p);
            }
            for (Object throwType : method.getThrowTypes()) {
                srcMethod.addThrowType((SrcType)throwType);
            }
            if (delegateCalls) {
                this.delegateCall(method, isInstanceExtensionMethod, srcMethod);
            } else {
                srcMethod.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("throw new " + RuntimeException.class.getSimpleName() + "(\"Should not exist at runtime!\");")));
            }
            extendedType.addMethod(srcMethod);
        }
        if (!delegateCalls) {
            srcMethod.addAnnotation(new SrcAnnotationExpression(ExtensionMethod.class).addArgument("extensionClass", String.class, (Object)((SrcClass)method.getOwner()).getName()).addArgument("isStatic", Boolean.TYPE, (Object)(!isInstanceExtensionMethod ? 1 : 0)).addArgument("isSmartStatic", Boolean.TYPE, (Object)this.hasThisClassAnnotation(method)).addArgument("isIntercept", Boolean.TYPE, (Object)isInterceptMethod).addArgument("isExtensionSource", Boolean.TYPE, (Object)isExtensionSource));
        } else {
            srcMethod.addAnnotation(new SrcAnnotationExpression(ForwardingExtensionMethod.class));
        }
    }

    private void delegateCall(AbstractSrcMethod method, boolean isInstanceExtensionMethod, AbstractSrcMethod<?> srcMethod) {
        StringBuilder call = new StringBuilder();
        SrcType returnType = srcMethod.getReturnType();
        if (returnType != null && !returnType.getName().equals(Void.TYPE.getName())) {
            call.append("return ");
        }
        String extClassName = ((SrcClass)method.getOwner()).getName();
        call.append(extClassName).append('.').append(srcMethod.getSimpleName()).append('(');
        if (isInstanceExtensionMethod) {
            call.append("this");
        } else if (this.hasThisClassAnnotation(method)) {
            call.append(srcMethod.getOwner().getSimpleName()).append(".class");
        }
        for (SrcParameter param : srcMethod.getParameters()) {
            if (call.charAt(call.length() - 1) != '(') {
                call.append(", ");
            }
            call.append(param.getSimpleName());
        }
        call.append(");\n");
        srcMethod.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText(call.toString())));
    }

    private boolean warnIfDuplicate(AbstractSrcMethod method, SrcClass extendedType, DiagnosticListener<JavaFileObject> errorHandler) {
        AbstractSrcMethod duplicate = this.findMethod(method, extendedType);
        if (duplicate == null) {
            return false;
        }
        if (extendedType.getName().equals(Array.class.getTypeName()) && ((SrcClass)duplicate.getOwner()).getName().equals(Object.class.getTypeName())) {
            return false;
        }
        SrcAnnotationExpression anno = duplicate.getAnnotation(ExtensionMethod.class);
        if (anno != null) {
            errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic(null, Diagnostic.Kind.WARNING, 0L, 0L, 0L, ExtIssueMsg.MSG_EXTENSION_DUPLICATION.get(new Object[]{method.signature(), ((SrcClass)method.getOwner()).getName(), anno.getArgument("extensionClass").getValue()})));
        } else {
            errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic(null, Diagnostic.Kind.WARNING, 0L, 0L, 0L, ExtIssueMsg.MSG_EXTENSION_SHADOWS.get(new Object[]{method.signature(), ((SrcClass)method.getOwner()).getName(), extendedType.getName()})));
        }
        return true;
    }

    private AbstractSrcMethod findMethod(AbstractSrcMethod<?> method, SrcClass extendedType) {
        if (extendedType == null) {
            return null;
        }
        AbstractSrcMethod duplicate = null;
        int paramsToSubtract = 0;
        if (!method.getParameters().isEmpty()) {
            SrcParameter firstParam = (SrcParameter)method.getParameters().get(0);
            paramsToSubtract = firstParam.hasAnnotation(This.class) || firstParam.hasAnnotation(ThisClass.class) ? 1 : 0;
        }
        block0: for (AbstractSrcMethod m : extendedType.getMethods()) {
            if (!m.getSimpleName().equals(method.getSimpleName()) || m.getParameters().size() != method.getParameters().size() - paramsToSubtract) continue;
            List parameters = method.getParameters();
            List params = m.getParameters();
            for (int i = paramsToSubtract; i < parameters.size(); ++i) {
                SrcParameter param = (SrcParameter)parameters.get(i);
                SrcParameter p = (SrcParameter)params.get(i - paramsToSubtract);
                if (!param.getType().equals((Object)p.getType())) continue block0;
            }
            duplicate = m;
            break;
        }
        if (duplicate == null) {
            SrcType superClass;
            if (!extendedType.isInterface() && (superClass = extendedType.getSuperClass()) != null && superClass.getName().equals(Object.class.getName())) {
                SrcClass superSrcClass = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(superClass.getName());
                duplicate = this.findMethod(method, superSrcClass);
            }
            if (duplicate == null) {
                for (SrcType iface : extendedType.getInterfaces()) {
                    SrcClass superIface = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(iface.getName());
                    duplicate = this.findMethod(method, superIface);
                    if (duplicate == null) continue;
                    break;
                }
            }
        }
        return duplicate;
    }

    private boolean isExtensionMethod(AbstractSrcMethod method, SrcClass extendedType) {
        if (!Modifier.isStatic((int)method.getModifiers()) || Modifier.isPrivate((int)method.getModifiers())) {
            return false;
        }
        SrcAnnotationExpression expires = method.getAnnotation(Expires.class);
        if (expires != null && JavacUtil.getReleaseNumber() >= Integer.parseInt(expires.getArgument("value").getValue().toString())) {
            return false;
        }
        if (method.hasAnnotation(Extension.class)) {
            return true;
        }
        return this.hasThisAnnotation(method, extendedType) || this.hasThisClassAnnotation(method);
    }

    private boolean isInstanceExtensionMethod(AbstractSrcMethod method, SrcClass extendedType) {
        if (!Modifier.isStatic((int)method.getModifiers()) || Modifier.isPrivate((int)method.getModifiers())) {
            return false;
        }
        return this.hasThisAnnotation(method, extendedType);
    }

    private boolean hasThisAnnotation(AbstractSrcMethod method, SrcClass extendedType) {
        List params = method.getParameters();
        if (params.size() == 0) {
            return false;
        }
        SrcParameter param = (SrcParameter)params.get(0);
        if (!param.hasAnnotation(This.class)) {
            return false;
        }
        return param.getType().getName().endsWith(extendedType.getSimpleName()) || this.isArrayExtension(param, extendedType);
    }

    private boolean hasThisClassAnnotation(AbstractSrcMethod method) {
        List params = method.getParameters();
        if (params.size() == 0) {
            return false;
        }
        SrcParameter param = (SrcParameter)params.get(0);
        if (!param.hasAnnotation(ThisClass.class)) {
            return false;
        }
        return param.getType().getName().endsWith("Class") || param.getType().getName().contains("Class<");
    }

    private boolean isArrayExtension(SrcParameter param, SrcClass extendedType) {
        return extendedType.getName().equals("manifold.rt.api.Array") && param.getType().getFqName().equals(Object.class.getTypeName());
    }

    private static class SimpleMethodSignature {
        public final String methodNameExpr;
        public final List<String> parameterTypes;

        SimpleMethodSignature(String methodNameExpr, List<String> parameterTypes) {
            this.methodNameExpr = methodNameExpr;
            this.parameterTypes = parameterTypes;
        }

        public boolean isSameAs(AbstractSrcMethod<?> method) {
            if (!method.getSimpleName().matches(this.methodNameExpr)) {
                return false;
            }
            if (this.parameterTypes == null) {
                return true;
            }
            if (method.getParameters().size() != this.parameterTypes.size()) {
                return false;
            }
            Iterator<String> thisParamIter = this.parameterTypes.iterator();
            Iterator methodParamIter = method.getParameters().iterator();
            while (thisParamIter.hasNext()) {
                String thisParam = thisParamIter.next();
                String methodParam = ((SrcParameter)methodParamIter.next()).getType().getFqName();
                if (any.class.getName().equals(thisParam) || thisParam.equals(methodParam)) continue;
                return false;
            }
            return true;
        }
    }
}

