/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import manifold.rt.api.util.Pair;

public class TypeVarToTypeMap {
    public static final TypeVarToTypeMap EMPTY_MAP = new TypeVarToTypeMap(Collections.emptyMap());
    private Map<TypeVariable, Pair<Type, Boolean>> _map;
    private Set<TypeVariable> _typesInferredFromCovariance;
    private boolean _bStructural;
    private boolean _bReparsing;

    public TypeVarToTypeMap() {
        this._map = new LinkedHashMap<TypeVariable, Pair<Type, Boolean>>(2);
        this._typesInferredFromCovariance = new HashSet<TypeVariable>(2);
    }

    private TypeVarToTypeMap(Map<TypeVariable, Pair<Type, Boolean>> emptyMap) {
        this._map = emptyMap;
        this._typesInferredFromCovariance = new HashSet<TypeVariable>(2);
    }

    public TypeVarToTypeMap(TypeVarToTypeMap from) {
        this();
        this._map.putAll(from._map);
        this._typesInferredFromCovariance.addAll(from._typesInferredFromCovariance);
        this._bStructural = from._bStructural;
    }

    public Type get(TypeVariable tvType) {
        Pair<Type, Boolean> pair = this._map.get(tvType);
        return pair != null ? (Type)pair.getFirst() : null;
    }

    public Pair<Type, Boolean> getPair(TypeVariable tvType) {
        return this._map.get(tvType);
    }

    public <E> Type getByMatcher(E tv, ITypeVarMatcher<E> matcher) {
        for (TypeVariable key : this._map.keySet()) {
            if (!matcher.matches(tv, key)) continue;
            return this.get(key);
        }
        return null;
    }

    public Type getByString(String tv) {
        for (TypeVariable key : this._map.keySet()) {
            if (!tv.equals(key.getName()) && !tv.equals(key.getName())) continue;
            return key;
        }
        return null;
    }

    public boolean containsKey(TypeVariable tvType) {
        return this._map.containsKey(tvType);
    }

    public Type put(TypeVariable tvType, Type type) {
        return this.put(tvType, type, false);
    }

    public Type put(TypeVariable tvType, Type type, boolean bReverse) {
        Type existing = this.remove(tvType);
        this._map.put(tvType, (Pair<Type, Boolean>)(type == null ? null : new Pair((Object)type, (Object)bReverse)));
        return existing;
    }

    public void putAll(TypeVarToTypeMap from) {
        for (TypeVariable x : from._map.keySet()) {
            this.put(x, from.get(x));
        }
    }

    public void putAllAndInferred(TypeVarToTypeMap from) {
        for (TypeVariable x : from._map.keySet()) {
            this.put(x, from.get(x));
        }
        this._typesInferredFromCovariance.addAll(from._typesInferredFromCovariance);
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public int size() {
        return this._map.size();
    }

    public Set<TypeVariable> keySet() {
        return this._map.keySet();
    }

    public Set<Map.Entry<TypeVariable, Pair<Type, Boolean>>> entrySet() {
        return this._map.entrySet();
    }

    public Type remove(TypeVariable tvType) {
        Pair<Type, Boolean> pair = this._map.remove(tvType);
        return pair != null ? (Type)pair.getFirst() : null;
    }

    public Collection<Pair<Type, Boolean>> values() {
        return this._map.values();
    }

    public boolean isStructural() {
        return this._bStructural;
    }

    public void setStructural(boolean bStructural) {
        this._bStructural = bStructural;
    }

    public boolean isInferredForCovariance(TypeVariable tv) {
        return !this.isStructural() || this._typesInferredFromCovariance.contains(tv);
    }

    public void setInferredForCovariance(TypeVariable tv) {
        this._typesInferredFromCovariance.add(tv);
    }

    public boolean isReparsing() {
        return this._bReparsing;
    }

    public void setReparsing(boolean bReparsing) {
        this._bReparsing = bReparsing;
    }

    public static interface ITypeVarMatcher<E> {
        public boolean matches(E var1, TypeVariable var2);
    }
}

