/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.script.Bindings;

public class DataBindings
implements Bindings {
    private Map<String, Object> _map;

    public DataBindings(Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        this._map = map;
    }

    public DataBindings() {
        this(new LinkedHashMap<String, Object>());
    }

    public DataBindings(int size) {
        this(new LinkedHashMap<String, Object>(size));
    }

    @Override
    public Object put(String name, Object value) {
        this.checkKey(name);
        return this._map.put(name, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> toMerge) {
        if (toMerge == null) {
            throw new NullPointerException("toMerge map is null");
        }
        for (Map.Entry<String, ?> entry : toMerge.entrySet()) {
            String key = entry.getKey();
            this.checkKey(key);
            this.put(key, entry.getValue());
        }
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this._map.entrySet();
    }

    @Override
    public Object get(Object key) {
        this.checkKey(key);
        return this._map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this._map.keySet();
    }

    @Override
    public Object remove(Object key) {
        this.checkKey(key);
        return this._map.remove(key);
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public Collection<Object> values() {
        return this._map.values();
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key should be a String");
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("key can not be empty");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataBindings that = (DataBindings)o;
        return Objects.equals(this._map, that._map);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this._map);
    }
}

