/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.type.NoType;
import manifold.api.host.IModule;
import manifold.ext.DynamicTypeProxyGenerator;
import manifold.ext.StructuralTypeProxyGenerator;
import manifold.ext.api.ICallHandler;
import manifold.internal.host.RuntimeManifoldHost;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.IDynamicJdk;
import manifold.util.Pair;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.ConcurrentHashSet;
import manifold.util.concurrent.ConcurrentWeakHashMap;

public class RuntimeMethods {
    private static final String STRUCTURAL_PROXY = "_structuralproxy_";
    private static Map<Class, Map<Class, Constructor>> PROXY_CACHE = new ConcurrentHashMap<Class, Map<Class, Constructor>>();
    private static final Map<Object, Set<Class>> ID_MAP = new ConcurrentWeakHashMap();

    public static Object constructProxy(Object root, Class iface) {
        return RuntimeMethods.createNewProxy(root, iface);
    }

    public static Object assignStructuralIdentity(Object obj, Class iface) {
        if (obj != null) {
            Set ifaces = ID_MAP.computeIfAbsent(obj, k -> new ConcurrentHashSet());
            ifaces.add(iface);
        }
        return obj;
    }

    public static Object invokeUnhandled(Object thiz, Class proxiedIface, String name, Class returnType, Class[] paramTypes, Object[] args) {
        Set<Class> ifaces = ID_MAP.get(thiz);
        if (ifaces != null) {
            for (Class iface : ifaces) {
                Method m;
                if (iface == proxiedIface || (m = RuntimeMethods.findMethod(iface, name, paramTypes)) == null) continue;
                try {
                    Object result = m.invoke(RuntimeMethods.constructProxy(thiz, iface), args);
                    result = RuntimeMethods.coerce(result, returnType);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ICallHandler.UNHANDLED;
    }

    public static Object coerce(Object value, Class<?> type) {
        Class<?> valueClass;
        if (value == null) {
            return null;
        }
        if (type.isPrimitive()) {
            type = RuntimeMethods.box(type);
        }
        if ((valueClass = value.getClass()) == type || type.isAssignableFrom(valueClass)) {
            return value;
        }
        if (type == Boolean.class) {
            if (value instanceof Number) {
                return ((Number)value).intValue() != 0;
            }
            return Boolean.parseBoolean(value.toString());
        }
        if (type == Byte.class) {
            if (value instanceof Number) {
                return ((Number)value).byteValue() != 0;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? (byte)1 : 0;
            }
            return Byte.parseByte(value.toString());
        }
        if (type == Character.class) {
            if (value instanceof Number) {
                return Character.valueOf((char)((Number)value).intValue());
            }
            String s = value.toString();
            return Character.valueOf(s.isEmpty() ? (char)'\u0000' : s.charAt(0));
        }
        if (type == Short.class) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? (short)1 : 0;
            }
            return Short.parseShort(value.toString());
        }
        if (type == Integer.class) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1 : 0;
            }
            return Integer.parseInt(value.toString());
        }
        if (type == Long.class) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1L : 0L;
            }
            return Long.parseLong(value.toString());
        }
        if (type == Float.class) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof Boolean) {
                return Float.valueOf((Boolean)value != false ? 1.0f : 0.0f);
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (type == Double.class) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1.0 : 0.0;
            }
            return Double.parseDouble(value.toString());
        }
        if (type == BigInteger.class) {
            if (value instanceof Number) {
                return BigInteger.valueOf(((Number)value).longValue());
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
            }
            return new BigInteger(value.toString());
        }
        if (type == BigDecimal.class) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            return new BigDecimal(value.toString());
        }
        if (type == String.class) {
            return String.valueOf(value);
        }
        if (type.isArray() && valueClass.isArray()) {
            int length = Array.getLength(value);
            Class<?> componentType = type.getComponentType();
            Object array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, RuntimeMethods.coerce(Array.get(value, i), componentType));
            }
            return array;
        }
        return value;
    }

    private static Class<?> box(Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalStateException();
    }

    private static Method findMethod(Class<?> iface, String name, Class[] paramTypes) {
        try {
            Method m = iface.getDeclaredMethod(name, paramTypes);
            if (m == null) {
                Class<?> superIface;
                Class<?>[] classArray = iface.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (m = RuntimeMethods.findMethod(superIface = classArray[i], name, paramTypes)) == null; ++i) {
                }
            }
            if (m != null) {
                return m;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static Object createNewProxy(Object root, Class<?> iface) {
        Constructor<?> proxyClassCtor;
        if (root == null) {
            return null;
        }
        Class<?> rootClass = root.getClass();
        if (iface.isAssignableFrom(rootClass)) {
            return root;
        }
        Map<Class, Constructor> proxyByClass = PROXY_CACHE.get(iface);
        if (proxyByClass == null) {
            proxyByClass = new ConcurrentHashMap<Class, Constructor>();
            PROXY_CACHE.put(iface, proxyByClass);
        }
        if ((proxyClassCtor = proxyByClass.get(rootClass)) == null) {
            Class proxyClass = RuntimeMethods.createProxy(iface, rootClass);
            proxyClassCtor = proxyClass.getConstructors()[0];
            proxyByClass.put(rootClass, proxyClassCtor);
        }
        try {
            ReflectUtil.setAccessible((Constructor)proxyClassCtor);
            return proxyClassCtor.newInstance(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class createProxy(Class iface, Class rootClass) {
        String relativeProxyName = rootClass.getCanonicalName().replace('.', '_') + STRUCTURAL_PROXY + iface.getCanonicalName().replace('.', '_');
        if (RuntimeMethods.hasCallHandlerMethod(rootClass)) {
            return DynamicTypeProxyGenerator.makeProxy(iface, rootClass, relativeProxyName);
        }
        return StructuralTypeProxyGenerator.makeProxy(iface, rootClass, relativeProxyName);
    }

    private static boolean hasCallHandlerMethod(Class rootClass) {
        String fqn = rootClass.getCanonicalName();
        BasicJavacTask javacTask = RuntimeManifoldHost.get().getJavaParser().getJavacTask();
        Pair classSymbol = ClassSymbols.instance((IModule)RuntimeManifoldHost.get().getSingleModule()).getClassSymbol(javacTask, fqn);
        Pair callHandlerSymbol = ClassSymbols.instance((IModule)RuntimeManifoldHost.get().getSingleModule()).getClassSymbol(javacTask, ICallHandler.class.getCanonicalName());
        if (Types.instance(javacTask.getContext()).isAssignable((Type)((Symbol.ClassSymbol)classSymbol.getFirst()).asType(), (Type)((Symbol.ClassSymbol)callHandlerSymbol.getFirst()).asType())) {
            return true;
        }
        return RuntimeMethods.hasCallMethod(javacTask, (Symbol.ClassSymbol)classSymbol.getFirst());
    }

    private static boolean hasCallMethod(BasicJavacTask javacTask, Symbol.ClassSymbol classSymbol) {
        Name call = Names.instance(javacTask.getContext()).fromString("call");
        Iterable elems = IDynamicJdk.instance().getMembersByName(classSymbol, call);
        for (Symbol s : elems) {
            if (!(s instanceof Symbol.MethodSymbol)) continue;
            java.util.List parameters = ((Symbol.MethodSymbol)s).getParameters();
            if (((List)parameters).size() != 6) {
                return false;
            }
            Symtab symbols = Symtab.instance(javacTask.getContext());
            Types types = Types.instance(javacTask.getContext());
            return types.erasure((Type)((Symbol.VarSymbol)((List)parameters).get(0)).asType()).equals(types.erasure(symbols.classType)) && ((Type)((Symbol.VarSymbol)((List)parameters).get(1)).asType()).equals(symbols.stringType) && ((Type)((Symbol.VarSymbol)((List)parameters).get(2)).asType()).equals(symbols.stringType) && types.erasure((Type)((Symbol.VarSymbol)((List)parameters).get(3)).asType()).equals(types.erasure(symbols.classType)) && ((Symbol.VarSymbol)((List)parameters).get(4)).asType() instanceof Type.ArrayType && types.erasure(((Type.ArrayType)((Symbol.VarSymbol)((List)parameters).get(4)).asType()).getComponentType()).equals(types.erasure(symbols.classType)) && ((Symbol.VarSymbol)((List)parameters).get(5)).asType() instanceof Type.ArrayType && ((Type.ArrayType)((Symbol.VarSymbol)((List)parameters).get(5)).asType()).getComponentType().equals(symbols.objectType);
        }
        Type superclass = classSymbol.getSuperclass();
        if (!(superclass instanceof NoType) && RuntimeMethods.hasCallMethod(javacTask, (Symbol.ClassSymbol)superclass.tsym)) {
            return true;
        }
        for (Type iface : classSymbol.getInterfaces()) {
            if (!RuntimeMethods.hasCallMethod(javacTask, (Symbol.ClassSymbol)iface.tsym)) continue;
            return true;
        }
        return false;
    }

    public static Object invoke_Object(Object receiver, String name, Class[] paramTypes, Object[] args) {
        return ReflectUtil.method((Object)receiver, (String)name, (Class[])paramTypes).invoke(args);
    }

    public static boolean invoke_boolean(Object receiver, String name, Class[] paramTypes, Object[] args) {
        return (Boolean)RuntimeMethods.invoke_Object(receiver, name, paramTypes, args);
    }

    public static byte invoke_byte(Object receiver, String name, Class[] paramTypes, Object[] args) {
        return (Byte)RuntimeMethods.invoke_Object(receiver, name, paramTypes, args);
    }

    public static char invoke_char(Object receiver, String name, Class[] paramTypes, Object[] args) {
        return ((Character)RuntimeMethods.invoke_Object(receiver, name, paramTypes, args)).charValue();
    }

    public static int invoke_int(Object receiver, String name, Class[] paramTypes, Object[] args) {
        return (Integer)RuntimeMethods.invoke_Object(receiver, name, paramTypes, args);
    }

    public static long invoke_long(Object receiver, String name, Class[] paramTypes, Object[] args) {
        return (Long)RuntimeMethods.invoke_Object(receiver, name, paramTypes, args);
    }

    public static float invoke_float(Object receiver, String name, Class[] paramTypes, Object[] args) {
        return ((Float)RuntimeMethods.invoke_Object(receiver, name, paramTypes, args)).floatValue();
    }

    public static double invoke_double(Object receiver, String name, Class[] paramTypes, Object[] args) {
        return (Double)RuntimeMethods.invoke_Object(receiver, name, paramTypes, args);
    }

    public static void invoke_void(Object receiver, String name, Class[] paramTypes, Object[] args) {
        RuntimeMethods.invoke_Object(receiver, name, paramTypes, args);
    }

    public static Object invokeStatic_Object(Class cls, String name, Class[] paramTypes, Object[] args) {
        return ReflectUtil.method((Class)cls, (String)name, (Class[])paramTypes).invokeStatic(args);
    }

    public static boolean invokeStatic_boolean(Class cls, String name, Class[] paramTypes, Object[] args) {
        return (Boolean)RuntimeMethods.invokeStatic_Object(cls, name, paramTypes, args);
    }

    public static byte invokeStatic_byte(Class cls, String name, Class[] paramTypes, Object[] args) {
        return (Byte)RuntimeMethods.invokeStatic_Object(cls, name, paramTypes, args);
    }

    public static char invokeStatic_char(Class cls, String name, Class[] paramTypes, Object[] args) {
        return ((Character)RuntimeMethods.invokeStatic_Object(cls, name, paramTypes, args)).charValue();
    }

    public static int invokeStatic_int(Class cls, String name, Class[] paramTypes, Object[] args) {
        return (Integer)RuntimeMethods.invokeStatic_Object(cls, name, paramTypes, args);
    }

    public static long invokeStatic_long(Class cls, String name, Class[] paramTypes, Object[] args) {
        return (Long)RuntimeMethods.invokeStatic_Object(cls, name, paramTypes, args);
    }

    public static float invokeStatic_float(Class cls, String name, Class[] paramTypes, Object[] args) {
        return ((Float)RuntimeMethods.invokeStatic_Object(cls, name, paramTypes, args)).floatValue();
    }

    public static double invokeStatic_double(Class cls, String name, Class[] paramTypes, Object[] args) {
        return (Double)RuntimeMethods.invokeStatic_Object(cls, name, paramTypes, args);
    }

    public static void invokeStatic_void(Class cls, String name, Class[] paramTypes, Object[] args) {
        RuntimeMethods.invokeStatic_Object(cls, name, paramTypes, args);
    }

    public static Object getField_Object(Object receiver, String name) {
        return ReflectUtil.field((Object)receiver, (String)name).get();
    }

    public static boolean getField_boolean(Object receiver, String name) {
        return (Boolean)RuntimeMethods.getField_Object(receiver, name);
    }

    public static byte getField_byte(Object receiver, String name) {
        return (Byte)RuntimeMethods.getField_Object(receiver, name);
    }

    public static char getField_char(Object receiver, String name) {
        return ((Character)RuntimeMethods.getField_Object(receiver, name)).charValue();
    }

    public static int getField_int(Object receiver, String name) {
        return (Integer)RuntimeMethods.getField_Object(receiver, name);
    }

    public static long getField_long(Object receiver, String name) {
        return (Long)RuntimeMethods.getField_Object(receiver, name);
    }

    public static float getField_float(Object receiver, String name) {
        return ((Float)RuntimeMethods.getField_Object(receiver, name)).floatValue();
    }

    public static double getField_double(Object receiver, String name) {
        return (Double)RuntimeMethods.getField_Object(receiver, name);
    }

    public static Object getFieldStatic_Object(Class receiver, String name) {
        return ReflectUtil.field((Class)receiver, (String)name).getStatic();
    }

    public static boolean getFieldStatic_boolean(Class receiver, String name) {
        return (Boolean)RuntimeMethods.getFieldStatic_Object(receiver, name);
    }

    public static byte getFieldStatic_byte(Class receiver, String name) {
        return (Byte)RuntimeMethods.getFieldStatic_Object(receiver, name);
    }

    public static char getFieldStatic_char(Class receiver, String name) {
        return ((Character)RuntimeMethods.getFieldStatic_Object(receiver, name)).charValue();
    }

    public static int getFieldStatic_int(Class receiver, String name) {
        return (Integer)RuntimeMethods.getFieldStatic_Object(receiver, name);
    }

    public static long getFieldStatic_long(Class receiver, String name) {
        return (Long)RuntimeMethods.getFieldStatic_Object(receiver, name);
    }

    public static float getFieldStatic_float(Class receiver, String name) {
        return ((Float)RuntimeMethods.getFieldStatic_Object(receiver, name)).floatValue();
    }

    public static double getFieldStatic_double(Class receiver, String name) {
        return (Double)RuntimeMethods.getFieldStatic_Object(receiver, name);
    }

    public static void setField_Object(Object receiver, String name, Object value) {
        ReflectUtil.field((Object)receiver, (String)name).set(value);
    }

    public static void setField_boolean(Object receiver, String name, boolean value) {
        RuntimeMethods.setField_Object(receiver, name, value);
    }

    public static void setField_byte(Object receiver, String name, byte value) {
        RuntimeMethods.setField_Object(receiver, name, value);
    }

    public static void setField_char(Object receiver, String name, char value) {
        RuntimeMethods.setField_Object(receiver, name, Character.valueOf(value));
    }

    public static void setField_int(Object receiver, String name, int value) {
        RuntimeMethods.setField_Object(receiver, name, value);
    }

    public static void setField_long(Object receiver, String name, long value) {
        RuntimeMethods.setField_Object(receiver, name, value);
    }

    public static void setField_float(Object receiver, String name, float value) {
        RuntimeMethods.setField_Object(receiver, name, Float.valueOf(value));
    }

    public static void setField_double(Object receiver, String name, double value) {
        RuntimeMethods.setField_Object(receiver, name, value);
    }

    public static void setFieldStatic_Object(Class receiver, String name, Object value) {
        ReflectUtil.field((Class)receiver, (String)name).setStatic(value);
    }

    public static void setFieldStatic_boolean(Class receiver, String name, boolean value) {
        RuntimeMethods.setFieldStatic_Object(receiver, name, value);
    }

    public static void setFieldStatic_byte(Class receiver, String name, byte value) {
        RuntimeMethods.setFieldStatic_Object(receiver, name, value);
    }

    public static void setFieldStatic_char(Class receiver, String name, char value) {
        RuntimeMethods.setFieldStatic_Object(receiver, name, Character.valueOf(value));
    }

    public static void setFieldStatic_int(Class receiver, String name, int value) {
        RuntimeMethods.setFieldStatic_Object(receiver, name, value);
    }

    public static void setFieldStatic_long(Class receiver, String name, long value) {
        RuntimeMethods.setFieldStatic_Object(receiver, name, value);
    }

    public static void setFieldStatic_float(Class receiver, String name, float value) {
        RuntimeMethods.setFieldStatic_Object(receiver, name, Float.valueOf(value));
    }

    public static void setFieldStatic_double(Class receiver, String name, double value) {
        RuntimeMethods.setFieldStatic_Object(receiver, name, value);
    }

    public static Object construct(Class type, Class[] paramTypes, Object[] args) {
        return ReflectUtil.constructor((Class)type, (Class[])paramTypes).newInstance(args);
    }
}

