/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.ExtIssueMsg;
import manifold.api.fs.IFile;
import manifold.api.fs.cache.PathCache;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcRawStatement;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcType;
import manifold.api.host.IModule;
import manifold.ext.ExtensionMethod;
import manifold.ext.Model;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.JavaParser;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.internal.runtime.Bootstrap;
import manifold.util.JavacDiagnostic;

class ExtCodeGen {
    private final Model _model;
    private final String _fqn;
    private String _existingSource;

    ExtCodeGen(Model model, String topLevelFqn, String existingSource) {
        this._model = model;
        this._fqn = topLevelFqn;
        this._existingSource = existingSource;
    }

    private IModule getModule() {
        return this._model.getTypeManifold().getTypeLoader().getModule();
    }

    String make(DiagnosticListener<JavaFileObject> errorHandler) {
        SrcClass srcExtended = !this._existingSource.isEmpty() ? this.makeStubFromSource() : ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(this._fqn);
        return this.addExtensions(srcExtended, errorHandler);
    }

    private SrcClass makeStubFromSource() {
        ArrayList trees = new ArrayList();
        JavaParser.instance().parseText(this._existingSource, trees, null, null, null);
        JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)((CompilationUnitTree)trees.get(0)).getTypeDecls().get(0);
        SrcClass srcExtended = (SrcClass)new SrcClass(this._fqn, classDecl.getKind() == Tree.Kind.CLASS ? SrcClass.Kind.Class : SrcClass.Kind.Interface).modifiers(classDecl.getModifiers().getFlags());
        if (classDecl.extending != null) {
            srcExtended.superClass(classDecl.extending.toString());
        }
        for (JCTree.JCExpression iface : classDecl.implementing) {
            srcExtended.addInterface(iface.toString());
        }
        return srcExtended;
    }

    private String addExtensions(SrcClass extendedClass, DiagnosticListener<JavaFileObject> errorHandler) {
        boolean methodExtensions = false;
        boolean interfaceExtensions = false;
        boolean annotationExtensions = false;
        Set<String> allExtensions = this.findAllExtensions();
        BasicJavacTask[] javacTask = new JavacTaskImpl[1];
        for (String fqn : allExtensions) {
            SrcClass srcExtension = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(fqn, javacTask, null);
            if (srcExtension == null) continue;
            for (AbstractSrcMethod method : srcExtension.getMethods()) {
                this.addExtensionMethod(method, extendedClass, errorHandler, (JavacTaskImpl)javacTask[0]);
                methodExtensions = true;
            }
            for (SrcType iface : srcExtension.getInterfaces()) {
                this.addExtensionInteface(iface, extendedClass, errorHandler, (JavacTaskImpl)javacTask[0]);
                interfaceExtensions = true;
            }
            for (SrcAnnotationExpression anno : srcExtension.getAnnotations()) {
                this.addExtensionAnnotation(anno, extendedClass, errorHandler, (JavacTaskImpl)javacTask[0]);
                annotationExtensions = true;
            }
        }
        if (!this._existingSource.isEmpty()) {
            return this.addExtensionsToExistingClass(extendedClass, methodExtensions, interfaceExtensions, annotationExtensions);
        }
        return extendedClass.render(new StringBuilder(), 0).toString();
    }

    private String addExtensionsToExistingClass(SrcClass srcClass, boolean methodExtensions, boolean interfaceExtensions, boolean annotationExtensions) {
        StringBuilder sb = new StringBuilder();
        if (methodExtensions) {
            this.addExtensionMethodsToExistingClass(srcClass, sb);
        }
        if (interfaceExtensions) {
            this.addExtensionInterfacesToExistingClass(srcClass, sb);
        }
        if (annotationExtensions) {
            this.addExtensionAnnotationsToExistingClass(srcClass, sb);
        }
        return sb.toString();
    }

    private void addExtensionInterfacesToExistingClass(SrcClass srcClass, StringBuilder sb) {
        String start = (srcClass.isInterface() ? "interface " : "class ") + srcClass.getSimpleName();
        int iStart = sb.indexOf(start);
        int iBrace = sb.indexOf("{", iStart);
        StringBuilder sbSrcClass = new StringBuilder();
        srcClass.render(sbSrcClass, 0);
        int iSrcClassStart = sbSrcClass.indexOf(start);
        int iSrcClassBrace = sbSrcClass.indexOf("{", iSrcClassStart);
        String fromSrcClass = sbSrcClass.substring(iSrcClassStart, iSrcClassBrace);
        sb.replace(iStart, iBrace, fromSrcClass);
    }

    private void addExtensionAnnotationsToExistingClass(SrcClass srcClass, StringBuilder sb) {
        int iStart;
        if (srcClass.getAnnotations().isEmpty()) {
            return;
        }
        StringBuilder sbAnnos = new StringBuilder();
        for (SrcAnnotationExpression anno : srcClass.getAnnotations()) {
            anno.render(sbAnnos, 0).append('\n');
        }
        String start = (srcClass.isInterface() ? "interface " : "class ") + srcClass.getSimpleName();
        for (iStart = sb.indexOf(start); iStart != 0 && sb.charAt(iStart) != '\n'; --iStart) {
        }
        if (sb.charAt(iStart) == '\n') {
            ++iStart;
        }
        sb.insert(iStart, sbAnnos);
    }

    private void addExtensionMethodsToExistingClass(SrcClass srcClass, StringBuilder sb) {
        int iBrace = this._existingSource.lastIndexOf(125);
        sb.append(this._existingSource.substring(0, iBrace));
        for (AbstractSrcMethod method : srcClass.getMethods()) {
            method.render(sb, 2);
        }
        sb.append("\n}");
    }

    private Set<String> findAllExtensions() {
        LinkedHashSet<String> fqns = new LinkedHashSet<String>();
        PathCache pathCache = this.getModule().getPathCache();
        for (IFile file : this._model.getFiles()) {
            Set fqn = pathCache.getFqnForFile(file);
            for (String f : fqn) {
                if (f == null) continue;
                fqns.add(f);
            }
        }
        return fqns;
    }

    private void addExtensionInteface(SrcType iface, SrcClass extendedType, DiagnosticListener<JavaFileObject> errorHandler, JavacTaskImpl javacTask) {
        extendedType.addInterface(iface);
    }

    private void addExtensionAnnotation(SrcAnnotationExpression anno, SrcClass extendedType, DiagnosticListener<JavaFileObject> errorHandler, JavacTaskImpl javacTask) {
        if (anno.getAnnotationType().equals(Extension.class.getName())) {
            return;
        }
        if (extendedType.getAnnotations().stream().noneMatch(e -> e.getAnnotationType().equals(anno.getAnnotationType()))) {
            extendedType.addAnnotation(anno.copy());
        }
    }

    private void addExtensionMethod(AbstractSrcMethod method, SrcClass extendedType, DiagnosticListener<JavaFileObject> errorHandler, JavacTaskImpl javacTask) {
        int i;
        int i2;
        if (!this.isExtensionMethod(method, extendedType)) {
            return;
        }
        if (this.warnIfDuplicate(method, extendedType, errorHandler, javacTask)) {
            return;
        }
        boolean delegateCalls = !this._existingSource.isEmpty();
        boolean isInstanceExtensionMethod = this.isInstanceExtensionMethod(method, extendedType);
        SrcMethod srcMethod = new SrcMethod(extendedType);
        long modifiers = method.getModifiers();
        if (extendedType.isInterface() && isInstanceExtensionMethod) {
            modifiers |= 0x80000000000L;
        }
        if (isInstanceExtensionMethod) {
            modifiers &= 0xFFFFFFFFFFFFFFF7L;
        }
        srcMethod.modifiers(modifiers);
        if (!delegateCalls) {
            srcMethod.addAnnotation(new SrcAnnotationExpression(ExtensionMethod.class).addArgument("extensionClass", String.class, (Object)((SrcClass)method.getOwner()).getName()).addArgument("isStatic", Boolean.TYPE, (Object)(!isInstanceExtensionMethod ? 1 : 0)));
        }
        srcMethod.returns(method.getReturnType());
        String name = method.getSimpleName();
        srcMethod.name(name);
        List typeParams = method.getTypeVariables();
        int extendedTypeVarCount = extendedType.getTypeVariables().size();
        int n = i2 = isInstanceExtensionMethod ? extendedTypeVarCount : 0;
        while (i2 < typeParams.size()) {
            SrcType typeVar = (SrcType)typeParams.get(i2);
            srcMethod.addTypeVar(typeVar);
            ++i2;
        }
        List params = method.getParameters();
        int n2 = i = isInstanceExtensionMethod ? 1 : 0;
        while (i < params.size()) {
            SrcParameter param = (SrcParameter)params.get(i);
            srcMethod.addParam(param.getSimpleName(), param.getType());
            ++i;
        }
        for (Object throwType : method.getThrowTypes()) {
            srcMethod.addThrowType((SrcType)throwType);
        }
        if (delegateCalls) {
            this.delegateCall(method, isInstanceExtensionMethod, srcMethod);
        } else {
            srcMethod.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("throw new " + RuntimeException.class.getSimpleName() + "(\"Should not exist at runtime!\");")));
        }
        extendedType.addMethod((AbstractSrcMethod)srcMethod);
    }

    private void delegateCall(AbstractSrcMethod method, boolean isInstanceExtensionMethod, SrcMethod srcMethod) {
        StringBuilder call = new StringBuilder();
        SrcType returnType = srcMethod.getReturnType();
        if (returnType != null && !returnType.getName().equals(Void.TYPE.getName())) {
            call.append("return ");
        }
        String extClassName = ((SrcClass)method.getOwner()).getName();
        call.append(extClassName).append('.').append(srcMethod.getSimpleName()).append('(');
        if (isInstanceExtensionMethod) {
            call.append("this");
        }
        for (SrcParameter param : srcMethod.getParameters()) {
            if (call.charAt(call.length() - 1) != '(') {
                call.append(", ");
            }
            call.append(param.getSimpleName());
        }
        call.append(");\n");
        srcMethod.body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText(call.toString())));
    }

    private boolean warnIfDuplicate(AbstractSrcMethod method, SrcClass extendedType, DiagnosticListener<JavaFileObject> errorHandler, JavacTaskImpl javacTask) {
        AbstractSrcMethod duplicate = this.findMethod(method, extendedType, new JavacTaskImpl[]{javacTask});
        if (duplicate == null) {
            return false;
        }
        JavacElements elems = JavacElements.instance(javacTask.getContext());
        Symbol.ClassSymbol sym = elems.getTypeElement(((SrcClass)method.getOwner()).getName());
        JavaFileObject file = sym.sourcefile;
        SrcAnnotationExpression anno = duplicate.getAnnotation(ExtensionMethod.class);
        if (anno != null) {
            errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic((JavaFileObject)(file.toUri().getScheme() == null ? null : new SourceJavaFileObject(file.toUri())), Diagnostic.Kind.WARNING, 0L, 0L, 0L, ExtIssueMsg.MSG_EXTENSION_DUPLICATION.get(new Object[]{method.signature(), ((SrcClass)method.getOwner()).getName(), anno.getArgument("extensionClass").getValue()})));
        } else {
            errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic((JavaFileObject)(file.toUri().getScheme() == null ? null : new SourceJavaFileObject(file.toUri())), Diagnostic.Kind.WARNING, 0L, 0L, 0L, ExtIssueMsg.MSG_EXTENSION_SHADOWS.get(new Object[]{method.signature(), ((SrcClass)method.getOwner()).getName(), extendedType.getName()})));
        }
        return true;
    }

    private AbstractSrcMethod findMethod(AbstractSrcMethod method, SrcClass extendedType, JavacTaskImpl[] javacTask) {
        AbstractSrcMethod duplicate = null;
        block0: for (AbstractSrcMethod m : extendedType.getMethods()) {
            if (!m.getSimpleName().equals(method.getSimpleName()) || m.getParameters().size() != method.getParameters().size() - 1) continue;
            List parameters = method.getParameters();
            List params = m.getParameters();
            for (int i = 1; i < parameters.size(); ++i) {
                SrcParameter param = (SrcParameter)parameters.get(i);
                SrcParameter p = (SrcParameter)params.get(i - 1);
                if (!param.getType().equals((Object)p.getType())) continue block0;
            }
            duplicate = m;
            break;
        }
        if (duplicate == null) {
            SrcType superClass;
            if (!extendedType.isInterface() && (superClass = extendedType.getSuperClass()) != null && superClass.getName().equals(Object.class.getName())) {
                SrcClass superSrcClass = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(superClass.getName(), (BasicJavacTask[])javacTask, null);
                duplicate = this.findMethod(method, superSrcClass, javacTask);
            }
            if (duplicate == null) {
                for (SrcType iface : extendedType.getInterfaces()) {
                    SrcClass superIface = ClassSymbols.instance((IModule)this.getModule()).makeSrcClassStub(iface.getName(), (BasicJavacTask[])javacTask, null);
                    duplicate = this.findMethod(method, superIface, javacTask);
                    if (duplicate == null) continue;
                    break;
                }
            }
        }
        return duplicate;
    }

    private boolean isExtensionMethod(AbstractSrcMethod method, SrcClass extendedType) {
        if (!Modifier.isStatic((int)method.getModifiers()) || Modifier.isPrivate((int)method.getModifiers())) {
            return false;
        }
        if (method.hasAnnotation(Extension.class)) {
            return true;
        }
        return this.hasThisAnnotation(method, extendedType);
    }

    private boolean isInstanceExtensionMethod(AbstractSrcMethod method, SrcClass extendedType) {
        if (!Modifier.isStatic((int)method.getModifiers()) || Modifier.isPrivate((int)method.getModifiers())) {
            return false;
        }
        return this.hasThisAnnotation(method, extendedType);
    }

    private boolean hasThisAnnotation(AbstractSrcMethod method, SrcClass extendedType) {
        List params = method.getParameters();
        if (params.size() == 0) {
            return false;
        }
        SrcParameter param = (SrcParameter)params.get(0);
        if (!param.hasAnnotation(This.class)) {
            return false;
        }
        return param.getType().getName().endsWith(extendedType.getSimpleName());
    }

    static {
        Bootstrap.init();
    }
}

