/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.rt;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import manifold.ext.rt.CoercionProviders;
import manifold.ext.rt.ListProxy;
import manifold.ext.rt.api.IBindingType;
import manifold.ext.rt.api.IBindingsBacked;
import manifold.ext.rt.api.ICallHandler;
import manifold.ext.rt.api.ICoercionProvider;
import manifold.ext.rt.api.IDynamicProxyFactory;
import manifold.ext.rt.api.IListBacked;
import manifold.ext.rt.api.IProxyFactory;
import manifold.ext.rt.api.IProxyFactory_gen;
import manifold.ext.rt.api.Structural;
import manifold.ext.rt.extensions.java.util.Map.MapStructExt;
import manifold.ext.rt.proxy.Proxy;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.ServiceUtil;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class RuntimeMethods {
    private static Map<Class, Map<Class, IProxyFactory<?, ?>>> PROXY_CACHE = new ConcurrentHashMap();
    private static final LocklessLazyVar<Set<IProxyFactory>> _registeredProxyFactories = LocklessLazyVar.make(() -> {
        HashSet registered = new HashSet();
        ServiceUtil.loadRegisteredServices(registered, IProxyFactory.class, (ClassLoader)RuntimeMethods.class.getClassLoader());
        return registered;
    });
    private static final LocklessLazyVar<Set<IProxyFactory_gen>> _registeredProxyFactories_gen = LocklessLazyVar.make(() -> {
        HashSet registered = new HashSet();
        ServiceUtil.loadRegisteredServices(registered, IProxyFactory_gen.class, (ClassLoader)RuntimeMethods.class.getClassLoader());
        return registered;
    });
    private static final LocklessLazyVar<IDynamicProxyFactory> _dynamicProxyFactory = LocklessLazyVar.make(() -> {
        HashSet registered = new HashSet();
        ServiceUtil.loadRegisteredServices(registered, IDynamicProxyFactory.class, (ClassLoader)RuntimeMethods.class.getClassLoader());
        return registered.isEmpty() ? null : (IDynamicProxyFactory)registered.iterator().next();
    });

    public static Object constructProxy(Object root, Class iface) {
        return RuntimeMethods.createNewProxy(root, iface);
    }

    public static Object coerceFromBindingsValue(Object value, Type t) {
        return RuntimeMethods.coerce(value, t);
    }

    public static Object coerce(Object value, Type t) {
        Class<?> valueClass;
        Class type;
        Class clazz = type = t instanceof ParameterizedType ? (Class)((ParameterizedType)t).getRawType() : (Class)t;
        if (value == null) {
            if (type.isPrimitive()) {
                return RuntimeMethods.defaultPrimitiveValue(type);
            }
            return null;
        }
        if (value instanceof List) {
            Object result = RuntimeMethods.callCoercionProviders(value, t);
            if (result != ICallHandler.UNHANDLED) {
                return result;
            }
            return value;
        }
        if (type.isPrimitive()) {
            type = ManClassUtil.box((Class)type);
        }
        if ((valueClass = value.getClass()) == type || type.isAssignableFrom(valueClass)) {
            return value;
        }
        Object result = RuntimeMethods.callCoercionProviders(value, t);
        if (result != ICallHandler.UNHANDLED) {
            return result;
        }
        if (value instanceof String && ((String)value).isEmpty() && type != String.class) {
            return null;
        }
        Object boxedValue = RuntimeMethods.coerceBoxed(value, type);
        if (boxedValue != null) {
            return boxedValue;
        }
        if (type == BigInteger.class) {
            if (value instanceof Number) {
                return BigInteger.valueOf(((Number)value).longValue());
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
            }
            return new BigInteger(value.toString());
        }
        if (type == BigDecimal.class) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            return new BigDecimal(value.toString());
        }
        if (type == String.class) {
            return String.valueOf(value);
        }
        if (type.isEnum()) {
            String name = String.valueOf(value);
            return Enum.valueOf(type, name);
        }
        if (type.isArray() && valueClass.isArray()) {
            int length = Array.getLength(value);
            Class<?> componentType = type.getComponentType();
            Object array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, RuntimeMethods.coerce(Array.get(value, i), componentType));
            }
            return array;
        }
        return value;
    }

    private static Object defaultPrimitiveValue(Class<?> type) {
        if (type == Integer.TYPE || type == Short.TYPE) {
            return 0;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Void.TYPE) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported primitive type: " + type.getSimpleName());
    }

    private static Object coerceBoxed(Object value, Class<?> type) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue() != 0;
            }
            return Boolean.parseBoolean(value.toString());
        }
        if (type == Byte.class || type == Byte.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).byteValue() != 0;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? (byte)1 : 0;
            }
            return Byte.parseByte(value.toString());
        }
        if (type == Character.class || type == Character.TYPE) {
            if (value instanceof Number) {
                return Character.valueOf((char)((Number)value).intValue());
            }
            String s = value.toString();
            return Character.valueOf(s.isEmpty() ? (char)'\u0000' : s.charAt(0));
        }
        if (type == Short.class || type == Short.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? (short)1 : 0;
            }
            return Short.parseShort(value.toString());
        }
        if (type == Integer.class || type == Integer.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1 : 0;
            }
            return Integer.parseInt(value.toString());
        }
        if (type == Long.class || type == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1L : 0L;
            }
            return Long.parseLong(value.toString());
        }
        if (type == Float.class || type == Float.TYPE) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof Boolean) {
                return Float.valueOf((Boolean)value != false ? 1.0f : 0.0f);
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (type == Double.class || type == Double.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1.0 : 0.0;
            }
            return Double.parseDouble(value.toString());
        }
        return null;
    }

    private static Object callCoercionProviders(Object value, Type type) {
        for (ICoercionProvider coercer : CoercionProviders.get()) {
            Object coercedValue = coercer.coerce(value, type);
            if (coercedValue == ICallHandler.UNHANDLED) continue;
            return coercedValue;
        }
        return ICallHandler.UNHANDLED;
    }

    private static Method findMethod(Class<?> iface, String name, Class[] paramTypes) {
        try {
            Method m = iface.getDeclaredMethod(name, paramTypes);
            if (m == null) {
                Class<?> superIface;
                Class<?>[] classArray = iface.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (m = RuntimeMethods.findMethod(superIface = classArray[i], name, paramTypes)) == null; ++i) {
                }
            }
            if (m != null) {
                return m;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static Object createNewProxy(Object root, Class<?> iface) {
        IProxyFactory proxyFactory;
        if (root == null) {
            return null;
        }
        Class<?> rootClass = root.getClass();
        if (iface.isAssignableFrom(rootClass)) {
            return root;
        }
        Map<Class, IProxyFactory<?, ?>> proxyByClass = PROXY_CACHE.get(iface);
        if (proxyByClass == null) {
            proxyByClass = new ConcurrentHashMap();
            PROXY_CACHE.put(iface, proxyByClass);
        }
        if ((proxyFactory = proxyByClass.get(rootClass)) == null) {
            proxyFactory = RuntimeMethods.createProxy(iface, rootClass);
            proxyByClass.put(rootClass, proxyFactory);
        }
        try {
            return proxyFactory.proxy(root, iface);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IProxyFactory createProxy(Class iface, Class rootClass) {
        IProxyFactory proxyFactory = RuntimeMethods.maybeSelfProxyClass(rootClass, iface);
        if (proxyFactory == null) {
            IDynamicProxyFactory dynamicProxyFactory = (IDynamicProxyFactory)_dynamicProxyFactory.get();
            if (dynamicProxyFactory == null || rootClass.isAnonymousClass()) {
                return RuntimeMethods.makeDynamicProxyNoManifoldRuntimeHost(rootClass, iface);
            }
            proxyFactory = dynamicProxyFactory.makeProxyFactory(iface, rootClass);
        }
        return proxyFactory;
    }

    private static IProxyFactory makeDynamicProxyNoManifoldRuntimeHost(Class rootClass, Class intface) {
        if (Map.class.isAssignableFrom(rootClass)) {
            return (target, iface) -> Proxy.newProxyInstance(intface.getClassLoader(), new Class[]{iface}, (proxy, method, args) -> MapStructExt.invoke((Map)target, proxy, method, args));
        }
        if (List.class.isAssignableFrom(rootClass)) {
            return (target, iface) -> Proxy.newProxyInstance(intface.getClassLoader(), new Class[]{iface}, (proxy, method, args) -> ListProxy.invoke((List)target, proxy, method, args));
        }
        return (target, iface) -> Proxy.newProxyInstance(intface.getClassLoader(), new Class[]{iface}, (proxy, method, args) -> ReflectUtil.structuralCallByProxy((Method)method, (Object)proxy, (Object)target, (Object[])args));
    }

    public static IProxyFactory maybeSelfProxyClass(Class<?> rootClass, Class<?> iface) {
        IProxyFactory proxyFactory;
        Class factoryClass;
        Structural anno = iface.getAnnotation(Structural.class);
        if (anno != null && (factoryClass = anno.factoryClass()) != Void.class && (proxyFactory = RuntimeMethods.maybeMakeProxyFactory(rootClass, iface, factoryClass, RuntimeMethods::constructProxyFactory)) != null) {
            return proxyFactory;
        }
        return RuntimeMethods.findRegisteredFactory(rootClass, iface);
    }

    private static IProxyFactory findRegisteredFactory(Class<?> rootClass, Class<?> iface) {
        return ((Set)_registeredProxyFactories.get()).stream().filter(e -> !(e instanceof IDynamicProxyFactory)).filter(e -> RuntimeMethods.maybeMakeProxyFactory(rootClass, iface, e.getClass(), c -> e) != null).findFirst().orElse(((Set)_registeredProxyFactories_gen.get()).stream().filter(e -> RuntimeMethods.maybeMakeProxyFactory(rootClass, iface, e.getClass(), c -> e) != null).findFirst().orElse(null));
    }

    private static IProxyFactory maybeMakeProxyFactory(Class<?> rootClass, Class<?> ifaceClass, Class factoryClass, Function<Class<?>, IProxyFactory> proxyFactoryMaker) {
        Type type = Arrays.stream(factoryClass.getGenericInterfaces()).filter(e -> e.getTypeName().startsWith(IProxyFactory.class.getTypeName())).findFirst().orElse(null);
        if (type instanceof ParameterizedType) {
            Type typeArg1 = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (typeArg1 instanceof ParameterizedType) {
                typeArg1 = ((ParameterizedType)typeArg1).getRawType();
            }
            if (!((Class)typeArg1).isAssignableFrom(rootClass)) {
                return null;
            }
            Type typeArg2 = ((ParameterizedType)type).getActualTypeArguments()[1];
            if (typeArg2 instanceof ParameterizedType) {
                typeArg2 = ((ParameterizedType)typeArg2).getRawType();
            }
            if (((Class)typeArg2).isAssignableFrom(ifaceClass)) {
                return proxyFactoryMaker.apply(factoryClass);
            }
        }
        return null;
    }

    private static IProxyFactory constructProxyFactory(Class factoryClass) {
        try {
            Constructor<?> constructor = factoryClass.getConstructors()[0];
            ReflectUtil.setAccessible(constructor);
            return (IProxyFactory)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object coerceToBindingValue(Object arg) {
        if (arg instanceof IBindingType) {
            return ((IBindingType)arg).toBindingValue();
        }
        if (arg instanceof IBindingsBacked) {
            return ((IBindingsBacked)arg).getBindings();
        }
        if (arg instanceof IListBacked) {
            return ((IListBacked)arg).getList();
        }
        if (arg instanceof List) {
            return ((List)arg).stream().map(e -> RuntimeMethods.coerceToBindingValue(e)).collect(Collectors.toList());
        }
        if (RuntimeMethods.needsCoercion(arg)) {
            for (ICoercionProvider coercer : CoercionProviders.get()) {
                Object coercedValue = coercer.toBindingValue(arg);
                if (coercedValue == ICallHandler.UNHANDLED) continue;
                return coercedValue;
            }
        }
        return arg;
    }

    private static boolean needsCoercion(Object arg) {
        return arg != null && !(arg instanceof Bindings) && !RuntimeMethods.isPrimitiveType(arg.getClass());
    }

    private static boolean isPrimitiveType(Class<?> type) {
        return type == String.class || type == Boolean.class || type == Character.class || type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class;
    }

    public static Object unFakeProxy(Object proxy) {
        if (proxy == null || !java.lang.reflect.Proxy.isProxyClass(proxy.getClass())) {
            return proxy;
        }
        InvocationHandler invocationHandler = java.lang.reflect.Proxy.getInvocationHandler(proxy);
        if (invocationHandler instanceof ReflectUtil.FakeProxy) {
            return ((ReflectUtil.FakeProxy)invocationHandler).getTarget();
        }
        return proxy;
    }

    public static <T> Iterable<T> makeIterable(Iterator<T> iter) {
        return () -> iter;
    }
}

