/*
 * Decompiled with CFR 0.152.
 */
package manifold.xml.rt;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import manifold.json.rt.Json;
import manifold.json.rt.api.DataBindings;
import manifold.json.rt.parser.Token;
import manifold.json.rt.parser.TokenType;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.Pair;
import manifold.xml.rt.parser.XmlAttribute;
import manifold.xml.rt.parser.XmlElement;
import manifold.xml.rt.parser.XmlParser;
import manifold.xml.rt.parser.XmlTerminal;

public class Xml {
    public static final String XML_DEFAULT_ROOT = "root_object";
    public static final String XML_ELEM_CONTENT = "textContent";

    public static String toXml(Object jsonValue) {
        StringBuilder sb = new StringBuilder();
        if ((jsonValue = Json.toBindings(jsonValue)) instanceof Map) {
            Xml.toXml(jsonValue, null, sb, 0);
        } else if (jsonValue instanceof Iterable) {
            Xml.toXml(jsonValue, "list", sb, 0);
        } else {
            Xml.toXml(jsonValue, "item", sb, 0);
        }
        return sb.toString();
    }

    public static void toXml(Object jsonValue, String name, StringBuilder target, int indent) {
        if ((jsonValue = Json.toBindings(jsonValue)) instanceof Map) {
            if (name == null) {
                Map map = (Map)jsonValue;
                if (map.size() == 1) {
                    Object rootKey = map.keySet().iterator().next();
                    Object rootValue = map.get(rootKey);
                    if (rootValue instanceof Pair) {
                        rootValue = ((Pair)rootValue).getSecond();
                    }
                    Xml.toXml(rootValue, rootKey.toString(), target, indent);
                    return;
                }
                name = XML_DEFAULT_ROOT;
            }
            Xml.toXml((Map)jsonValue, name, target, indent);
        } else if (jsonValue instanceof Iterable) {
            Xml.toXml((Iterable)jsonValue, name, target, indent);
        } else {
            Xml.toXml(String.valueOf(jsonValue), name, target, indent);
        }
    }

    private static void toXml(Map bindings, String name, StringBuilder target, int indent) {
        Json.indent(target, indent);
        target.append('<').append(name);
        if (bindings.size() > 0) {
            for (Object key : bindings.keySet()) {
                Object value = bindings.get(key);
                if (value instanceof Pair) {
                    value = ((Pair)value).getSecond();
                }
                if ((value = Json.toBindings(value)) instanceof Map || value instanceof Iterable || key.equals(XML_ELEM_CONTENT)) continue;
                target.append(" ").append(key).append("=\"").append(value).append('\"');
            }
            int count = 0;
            for (Object key : bindings.keySet()) {
                Object value = bindings.get(key);
                if (value instanceof Pair) {
                    value = ((Pair)value).getSecond();
                }
                if ((value = Json.toBindings(value)) instanceof Map) {
                    if (count == 0) {
                        target.append(">\n");
                    }
                    Xml.toXml((Map)value, key.toString(), target, indent + 2);
                    ++count;
                    continue;
                }
                if (value instanceof Iterable) {
                    if (count == 0) {
                        target.append(">\n");
                    }
                    Xml.toXml((Iterable)value, key.toString(), target, indent + 2);
                    ++count;
                    continue;
                }
                if (!(value instanceof String) || !key.equals(XML_ELEM_CONTENT)) continue;
                if (count == 0) {
                    target.append(">\n");
                }
                Json.indent(target, indent + 2);
                target.append(value).append("\n");
                ++count;
            }
            if (count == 0) {
                target.append("/>\n");
            } else {
                Json.indent(target, indent);
                target.append("</").append(name).append(">\n");
            }
        } else {
            target.append("/>\n");
        }
    }

    private static void toXml(Iterable value, String name, StringBuilder target, int indent) {
        for (Object comp : value) {
            if (comp instanceof Pair) {
                comp = ((Pair)comp).getSecond();
            }
            if ((comp = Json.toBindings(comp)) instanceof Map) {
                Xml.toXml((Map)comp, name, target, indent);
                continue;
            }
            if (comp instanceof Iterable) {
                Xml.toXml((Iterable)comp, name, target, indent);
                continue;
            }
            Xml.toXml(String.valueOf(comp), name, target, indent);
        }
    }

    private static void toXml(String value, String name, StringBuilder target, int indent) {
        Json.indent(target, indent);
        target.append('<').append(name).append(">");
        target.append(value);
        target.append("</").append(name).append(">\n");
    }

    public static Bindings fromXml(String xml) {
        return Xml.fromXml(xml, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bindings fromXml(String xml, boolean withTokens) {
        try (BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(xml.getBytes()));){
            Object root;
            XmlElement elem = XmlParser.parse(inputStream);
            DataBindings bindings = Xml.transform(new DataBindings(), elem, withTokens);
            if (bindings.size() == 1 && (root = bindings.get(XML_DEFAULT_ROOT)) instanceof DataBindings) {
                bindings = (DataBindings)bindings.get(XML_DEFAULT_ROOT);
            }
            DataBindings dataBindings = bindings;
            return dataBindings;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static DataBindings transform(DataBindings parent, XmlElement elem, boolean withTokens) {
        DataBindings children = new DataBindings();
        parent.put(elem.getName().getRawText(), withTokens ? Xml.makeTokensValue(elem, children) : children);
        for (Map.Entry<String, XmlAttribute> entry : elem.getAttributes().entrySet()) {
            children.put(entry.getKey(), withTokens ? Xml.makeTokensValue(entry.getValue()) : entry.getValue().getValue());
        }
        if (elem.getRawContent() != null) {
            children.put(XML_ELEM_CONTENT, (Object)elem.getRawContent().getRawText().trim());
        }
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        for (XmlElement xmlElement : elem.getChildren()) {
            map.computeIfAbsent(xmlElement.getName().getRawText(), k -> new ArrayList()).add(Xml.transform(new DataBindings(), xmlElement, withTokens));
        }
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() == 1) {
                children.putAll((Map)list.get(0));
                continue;
            }
            List<Object> listValues = list.stream().map(e -> e.get(entry.getKey())).collect(Collectors.toList());
            children.put((String)entry.getKey(), withTokens ? Xml.makeTokensValue(listValues) : listValues);
        }
        return parent;
    }

    private static Object makeTokensValue(XmlElement elem, Bindings value) {
        Token keyToken = Xml.makeToken(elem.getName());
        return new Pair<Token[], Bindings>(new Token[]{keyToken, null}, value);
    }

    private static Object makeTokensValue(List<Object> value) {
        Object item = value.get(0);
        if (item instanceof Pair) {
            return new Pair(((Pair)item).getFirst(), value);
        }
        return value;
    }

    private static Object makeTokensValue(XmlAttribute attr) {
        Token keyToken = Xml.makeToken(attr.getName());
        XmlTerminal rawValue = attr.getRawValue();
        Token valueToken = rawValue == null ? null : Xml.makeToken(rawValue);
        return new Pair<Token[], String>(new Token[]{keyToken, valueToken}, attr.getValue());
    }

    private static Token makeToken(XmlTerminal value) {
        return new Token(TokenType.STRING, value.getRawText(), value.getOffset(), value.getLine(), -1);
    }
}

