/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.AreaUnit;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.MassUnit;
import manifold.science.measures.Pressure;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class PressureUnit
extends AbstractQuotientUnit<MassUnit, AreaUnit, Pressure, PressureUnit> {
    private static final UnitCache<PressureUnit> CACHE = new UnitCache();
    public static final PressureUnit Pa = PressureUnit.get(MassUnit.Kilogram, AreaUnit.BASE, CoercionConstants.r.postfixBind(1), "Pascal", "Pa");
    public static final PressureUnit bar = PressureUnit.get(MassUnit.Kilogram, AreaUnit.BASE, CoercionConstants.r.postfixBind("1.0e5"), "Bar", "bar");
    public static final PressureUnit at = PressureUnit.get(MassUnit.Kilogram, AreaUnit.BASE, CoercionConstants.r.postfixBind("9.80665e4"), "TechnicalAtm", "at");
    public static final PressureUnit atm = PressureUnit.get(MassUnit.Kilogram, AreaUnit.BASE, CoercionConstants.r.postfixBind("1.01325e5"), "StandardAtm", "atm");
    public static final PressureUnit Torr = PressureUnit.get(MassUnit.Kilogram, AreaUnit.BASE, CoercionConstants.r.postfixBind("133.3224"), "Torr", "Torr");
    public static final PressureUnit psi = PressureUnit.get(MassUnit.Pound, AreaUnit.get(LengthUnit.Inch), CoercionConstants.r.postfixBind(1), "Psi", "psi");
    public static final PressureUnit BASE = Pa;

    public static PressureUnit get(MassUnit massUnit, AreaUnit areaUnit) {
        return PressureUnit.get(massUnit, areaUnit, null, null, null);
    }

    public static PressureUnit get(MassUnit massUnit, AreaUnit areaUnit, Rational factor, String name, String symbol) {
        PressureUnit unit = new PressureUnit(massUnit, areaUnit, factor, name, symbol);
        return (PressureUnit)CACHE.get(unit);
    }

    private PressureUnit(MassUnit massUnit, AreaUnit areaUnit, Rational factor, String name, String symbol) {
        super(massUnit, areaUnit, factor, name, symbol);
    }

    @Override
    public Pressure makeDimension(Number amount) {
        return new Pressure(Rational.get(amount), this);
    }

    public MassUnit getMassUnit() {
        return (MassUnit)this.getLeftUnit();
    }

    public AreaUnit getAreaUnit() {
        return (AreaUnit)this.getRightUnit();
    }
}

