/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt.api;

import java.io.IOException;
import manifold.json.rt.Json;
import manifold.json.rt.api.IJsonBindingsTranslator;
import manifold.rt.api.Bindings;

public class Writer {
    private final Object _value;

    public Writer(Bindings jsonBindings) {
        this._value = jsonBindings;
    }

    public Writer(Iterable<?> jsonList) {
        this._value = jsonList;
    }

    public Writer(Object jsonValue) {
        this._value = jsonValue;
    }

    public String toJson() {
        return Json.toJson(this._value);
    }

    public void toJson(Appendable target) {
        try {
            target.append(Json.toJson(this._value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        IJsonBindingsTranslator yaml = IJsonBindingsTranslator.get("YAML");
        StringBuilder sb = new StringBuilder();
        yaml.fromBindings(this._value, sb);
        return sb.toString();
    }

    public void toYaml(Appendable target) {
        try {
            target.append(this.toYaml());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXml() {
        IJsonBindingsTranslator xml = IJsonBindingsTranslator.get("XML");
        return xml.fromBindings(this._value);
    }

    public void toXml(Appendable target) {
        try {
            IJsonBindingsTranslator xml = IJsonBindingsTranslator.get("XML");
            target.append(xml.fromBindings(this._value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXml(String name) {
        IJsonBindingsTranslator xml = IJsonBindingsTranslator.get("XML");
        StringBuilder sb = new StringBuilder();
        xml.fromBindings(this._value, name, sb, 0);
        return sb.toString();
    }

    public String toCsv() {
        IJsonBindingsTranslator csv = IJsonBindingsTranslator.get("CSV");
        return csv.fromBindings(this._value);
    }

    public void toCsv(Appendable target) {
        try {
            IJsonBindingsTranslator csv = IJsonBindingsTranslator.get("CSV");
            target.append(csv.fromBindings(this._value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toCsv(String name) {
        IJsonBindingsTranslator csv = IJsonBindingsTranslator.get("CSV");
        StringBuilder sb = new StringBuilder();
        csv.fromBindings(this._value, name, sb, 0);
        return sb.toString();
    }
}

