/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import manifold.internal.javac.ILetExpr;
import manifold.rt.api.util.Stack;

public class ParentTreePathScanner
extends TreeScanner<Tree, Void> {
    private final Map<Tree, Tree> _parents;
    private final Map<Integer, List<Tree>> _parentsByPos;
    private final Stack<Tree> _parent;

    ParentTreePathScanner(Map<Tree, Tree> parents, Map<Integer, List<Tree>> parentsByPos) {
        this._parents = parents;
        this._parentsByPos = parentsByPos;
        this._parent = new Stack();
        this._parent.push(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tree scan(Tree path, Void p) {
        if (path == null) {
            return null;
        }
        this._parents.put(path, this._parent.peek());
        if (path instanceof JCTree) {
            this._parentsByPos.computeIfAbsent(((JCTree)path).pos, __ -> new ArrayList()).add(this._parent.peek());
        }
        this._parent.push(path);
        try {
            Tree tree = (Tree)super.scan(path, null);
            return tree;
        }
        finally {
            this._parent.pop();
        }
    }

    @Override
    public Tree visitOther(Tree node, Void p) {
        if (node instanceof ILetExpr) {
            ILetExpr letExpr = (ILetExpr)((Object)node);
            Tree r = (Tree)this.scan(letExpr.getDefs(), p);
            return this.reduce(this.scan((Tree)letExpr.getExpr(), p), r);
        }
        return (Tree)super.visitOther(node, p);
    }
}

