/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.element.ElementKind;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.RecursiveTypeVarEraser;
import manifold.rt.api.util.TypesUtil;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public interface ManTypes {
    public static final ThreadLocal<Map<Pair<String, String>, Boolean>> CACHED_PAIRS = ThreadLocal.withInitial(HashMap::new);

    public Types types();

    default public boolean isAssignableToStructuralType(Type t, Type s) {
        try {
            return this._isAssignableToStructuralType(t, s);
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean _isAssignableToStructuralType(Type t, Type s) {
        Pair<String, String> pair;
        t = this.eraseTypeVars(t);
        s = this.eraseTypeVars(s);
        if (!(t instanceof Type.ClassType)) {
            return false;
        }
        if (!TypesUtil.isStructuralInterface(this.types(), s.tsym)) {
            return false;
        }
        Map<Pair<String, String>, Boolean> cache = CACHED_PAIRS.get();
        if (cache.containsKey(pair = new Pair<String, String>(t.toString(), s.toString()))) {
            Boolean result = cache.get(pair);
            return result == null || result != false;
        }
        cache.put(pair, null);
        try {
            HashSet<Symbol.MethodSymbol> sMethods = new HashSet<Symbol.MethodSymbol>();
            ManTypes.getAllMethods(s, m -> !m.isStatic() && (m.flags() & 0x80000000000L) == 0L && (m.flags() & 1L) != 0L && (m.flags() & 0x1000L) == 0L, sMethods);
            HashSet<Symbol.MethodSymbol> tMethods = new HashSet<Symbol.MethodSymbol>();
            ManTypes.getAllMethods(t, m -> !m.isStatic() && (m.flags() & 1L) != 0L, tMethods);
            HashSet<Symbol.VarSymbol> tFields = new HashSet<Symbol.VarSymbol>();
            ManTypes.getAllFields(t, v -> !v.isStatic() && (v.flags() & 1L) != 0L, tFields);
            boolean result = true;
            for (Symbol.MethodSymbol sm : sMethods) {
                if (!tMethods.stream().noneMatch(tm -> this.isStructuralMatch(sm, (Symbol.MethodSymbol)tm)) || !tMethods.stream().noneMatch(tm -> this.isGetterRecordAccessorMatch(sm, (Symbol.MethodSymbol)tm)) || !tFields.stream().noneMatch(tf -> this.isGetterMatch(sm, tf.flatName().toString(), tf.type)) || !tFields.stream().noneMatch(tf -> this.isSetterFieldMatch(sm, (Symbol.VarSymbol)tf))) continue;
                result = false;
                break;
            }
            result = result && this.verifyTuple(t, s, tFields);
            cache.put(pair, result);
            boolean bl = result;
            return bl;
        }
        finally {
            cache.remove(pair);
        }
    }

    default public boolean verifyTuple(Type t, Type s, Set<Symbol.VarSymbol> tFields) {
        if (!((Name)t.tsym.getSimpleName()).toString().contains("manifold_tuple_")) {
            return true;
        }
        HashSet<Symbol.MethodSymbol> sMethods = new HashSet<Symbol.MethodSymbol>();
        ManTypes.getAllMethods(s, m -> !m.isStatic() && (m.flags() & 1L) != 0L && (m.flags() & 0x1000L) == 0L, sMethods);
        boolean allMatch = true;
        for (Symbol.MethodSymbol sm2 : sMethods) {
            if (!tFields.stream().noneMatch(tf -> this.isGetterMatch(sm2, tf.flatName().toString(), tf.type) || this.isSetterFieldMatch(sm2, (Symbol.VarSymbol)tf))) continue;
            allMatch = false;
            break;
        }
        if (!allMatch) {
            for (Symbol.VarSymbol tf2 : tFields) {
                if (!sMethods.stream().noneMatch(sm -> this.isGetterMatch((Symbol.MethodSymbol)sm, tf2.flatName().toString(), tf.type))) continue;
                return false;
            }
        }
        return true;
    }

    default public Type eraseTypeVars(Type type) {
        return RecursiveTypeVarEraser.eraseTypeVars(this.types(), type);
    }

    default public boolean isStructuralMatch(Symbol.MethodSymbol sm, Symbol.MethodSymbol tm) {
        return sm.flatName().equals(tm.flatName()) && this.types().isAssignable(this.eraseTypeVars(tm.getReturnType()), this.eraseTypeVars(sm.getReturnType())) && this.hasStructurallyEquivalentArgs(tm, sm);
    }

    default public boolean isGetterMatch(Symbol.MethodSymbol sm, String tName, Type tType) {
        Symtab symtab = Symtab.instance(JavacPlugin.instance().getContext());
        Type returnType = sm.getReturnType();
        if (returnType == symtab.voidType || !sm.params().isEmpty()) {
            return false;
        }
        String smName = sm.flatName().toString();
        if (smName.length() >= 3 && smName.startsWith("is") && Character.isUpperCase(smName.charAt(2)) && (returnType == symtab.booleanType || returnType == this.types().boxedTypeOrType(symtab.booleanType))) {
            smName = smName.substring(2).toLowerCase();
        } else if (smName.length() >= 4 && smName.startsWith("get") && Character.isUpperCase(smName.charAt(3))) {
            smName = smName.substring(3).toLowerCase();
        } else {
            return false;
        }
        return smName.equals(tName) && this.types().isAssignable(this.eraseTypeVars(tType), this.eraseTypeVars(returnType));
    }

    default public boolean isSetterFieldMatch(Symbol.MethodSymbol sm, Symbol.VarSymbol tf) {
        if ((tf.flags() & 0x10L) != 0L) {
            return false;
        }
        Symtab symtab = Symtab.instance(JavacPlugin.instance().getContext());
        Type returnType = sm.getReturnType();
        if (returnType != symtab.voidType || sm.params().size() != 1) {
            return false;
        }
        String smName = sm.flatName().toString();
        String tfName = tf.flatName().toString();
        if (smName.length() < 4 || !smName.startsWith("set") || !Character.isUpperCase(smName.charAt(3))) {
            return false;
        }
        smName = smName.substring(3).toLowerCase();
        return smName.equals(tfName) && this.types().isAssignable(this.eraseTypeVars(tf.type), this.eraseTypeVars(sm.params().get((int)0).type));
    }

    public static void getAllMethods(Type t, Predicate<Symbol.MethodSymbol> filter, Set<Symbol.MethodSymbol> tMethods) {
        if (!(t instanceof Type.ClassType)) {
            return;
        }
        Symbol.ClassSymbol tsym = (Symbol.ClassSymbol)t.tsym;
        for (Symbol sym : IDynamicJdk.instance().getMembers(tsym, m -> m instanceof Symbol.MethodSymbol && filter.test((Symbol.MethodSymbol)m))) {
            tMethods.add((Symbol.MethodSymbol)sym);
        }
        ManTypes.getAllMethods(tsym.getSuperclass(), filter, tMethods);
        for (Type iface : tsym.getInterfaces()) {
            ManTypes.getAllMethods(iface, filter, tMethods);
        }
    }

    default public boolean isGetterRecordAccessorMatch(Symbol.MethodSymbol sm, Symbol.MethodSymbol t) {
        if (!JreUtil.isJava17orLater()) {
            return false;
        }
        if (t.getKind() != ReflectUtil.field(ElementKind.class, "RECORD_COMPONENT").getStatic()) {
            return false;
        }
        return this.isGetterMatch(sm, t.flatName().toString(), t.getReturnType());
    }

    public static void getAllFields(Type t, Predicate<Symbol.VarSymbol> filter, Set<Symbol.VarSymbol> tFields) {
        if (!(t instanceof Type.ClassType)) {
            return;
        }
        Symbol.ClassSymbol tsym = (Symbol.ClassSymbol)t.tsym;
        for (Symbol sym : IDynamicJdk.instance().getMembers(tsym, m -> m instanceof Symbol.VarSymbol && filter.test((Symbol.VarSymbol)m))) {
            tFields.add((Symbol.VarSymbol)sym);
        }
        ManTypes.getAllFields(tsym.getSuperclass(), filter, tFields);
    }

    default public boolean hasStructurallyEquivalentArgs(Symbol.MethodSymbol t, Symbol.MethodSymbol s) {
        java.util.List tParams = t.getParameters();
        java.util.List sParams = s.getParameters();
        if (((List)tParams).size() != ((List)sParams).size()) {
            return false;
        }
        for (int i = 0; i < ((List)sParams).size(); ++i) {
            Symbol.VarSymbol sParam = (Symbol.VarSymbol)((List)sParams).get(i);
            Symbol.VarSymbol tParam = (Symbol.VarSymbol)((List)tParams).get(i);
            if (this.types().isAssignable(this.eraseTypeVars(sParam.type), this.eraseTypeVars(tParam.type))) continue;
            return false;
        }
        return true;
    }
}

