/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.tools.Diagnostic;

public class BootstrapPackages {
    private final Kind _kind;
    private final Set<String> _packages;

    public BootstrapPackages(Set<String> values, JavacProcessingEnvironment jpe) {
        if (values == null || values.isEmpty()) {
            this._kind = Kind.All;
            this._packages = null;
            return;
        }
        char kindChar = values.iterator().next().charAt(0);
        Kind kind = this._kind = kindChar == '+' ? Kind.Whitelist : Kind.Blacklist;
        if (values.stream().anyMatch(e -> e.charAt(0) != kindChar)) {
            jpe.getMessager().printMessage(Diagnostic.Kind.ERROR, "Manifold plugin --bootstrap arguments must be consistently + or -, not both");
        }
        this._packages = this.parsePackages(values);
    }

    private Set<String> parsePackages(Set<String> values) {
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        for (String value : values) {
            StringTokenizer tokenizer = new StringTokenizer(value.substring(1), ";, ");
            while (tokenizer.hasMoreTokens()) {
                String pkg = tokenizer.nextToken();
                if (pkg.isEmpty()) continue;
                packages.add(pkg);
            }
        }
        return packages;
    }

    public boolean contains(String pkg) {
        switch (this._kind) {
            case Whitelist: {
                return this._packages.stream().anyMatch(e -> pkg.equals(e) || pkg.startsWith(e + '.'));
            }
            case Blacklist: {
                return this._packages.stream().noneMatch(e -> pkg.equals(e) || pkg.startsWith(e + '.'));
            }
            case All: {
                return true;
            }
        }
        throw new IllegalStateException("Unknown kind: " + (Object)((Object)this._kind));
    }

    static enum Kind {
        Whitelist,
        Blacklist,
        All;

    }
}

