/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum Arg {
    bootstrap("--bootstrap", false, false, null, "Bootstrap package list"){

        @Override
        public void validate(String value, Map<Arg, Set<String>> map) {
            if (value == null || value.isEmpty()) {
                throw new RuntimeException("Manifold plugin argument: '" + bootstrap.getName() + "' requires one or more package names");
            }
            if (!value.startsWith("+") && !value.startsWith("-")) {
                throw new RuntimeException("Manifold plugin argument: '" + bootstrap.getName() + "' must begin with a + or - indicating a whitelist or blacklist");
            }
            if (map.containsKey((Object)no_bootstrap) || map.containsKey((Object)no_bootstrap_deprecated)) {
                throw new RuntimeException("Manifold plugin argument: '" + bootstrap.getName() + "' must not be used with '" + no_bootstrap.getName() + "'");
            }
        }
    }
    ,
    no_bootstrap("--no-bootstrap", false, true, null, "Turns off runtime bootstrapping code generation"){

        @Override
        protected void validate(String arg, Map<Arg, Set<String>> map) {
            if (map.containsKey((Object)bootstrap)) {
                throw new RuntimeException("Manifold plugin argument: '" + bootstrap.getName() + "' must not be used with '" + no_bootstrap.getName() + "'");
            }
        }
    }
    ,
    no_bootstrap_deprecated("no-bootstrap", false, true, true, null, "Deprecated. Use --no-bootstrap"){

        @Override
        protected void validate(String arg, Map<Arg, Set<String>> map) {
            if (map.containsKey((Object)bootstrap)) {
                throw new RuntimeException("Manifold plugin argument: '" + bootstrap.getName() + "' must not be used with '" + no_bootstrap.getName() + "'");
            }
        }
    }
    ,
    dynamic("--dynamic", false, true, null, "Turns on runtime compilation mode"),
    dynamic_deprecated("dynamic", false, true, true, null, "Deprecated. Use --dynamic");

    private final String _name;
    private final boolean _required;
    private final boolean _isFlag;
    private final boolean _deprecated;
    private final String _description;
    private final String _defaultValue;

    private Arg(String name, boolean required, boolean isFlag, String defaultValue, String description) {
        this(name, required, isFlag, false, defaultValue, description);
    }

    private Arg(String name, boolean required, boolean isFlag, boolean deprecated, String defaultValue, String description) {
        this._name = name;
        this._required = required;
        this._isFlag = isFlag;
        this._deprecated = deprecated;
        this._description = description;
        this._defaultValue = defaultValue;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public boolean isRequired() {
        return this._required;
    }

    public boolean isFlag() {
        return this._isFlag;
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public static Set<Arg> allRequired() {
        return Arrays.stream(Arg.values()).filter(a -> a.isRequired() && !a.isDeprecated()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Arg> allOptional() {
        return Arrays.stream(Arg.values()).filter(a -> !a.isRequired() && !a.isDeprecated()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Arg byName(String name) {
        return Arrays.stream(Arg.values()).filter(e -> e.getName().equals(name)).findFirst().orElse(null);
    }

    protected void validate(String arg, Map<Arg, Set<String>> map) {
    }

    private static String usage() {
        StringBuilder sb = new StringBuilder("--Usage--\n");
        if (!Arg.allRequired().isEmpty()) {
            sb.append("Required parameters:\n");
            for (Arg arg : Arg.allRequired()) {
                sb.append(arg.getName()).append(": ").append(arg.getDescription()).append("\n");
            }
        }
        if (!Arg.allOptional().isEmpty()) {
            sb.append("Optional parameters:\n");
            for (Arg arg : Arg.allOptional()) {
                sb.append(arg.getName()).append(": ").append(arg.getDescription()).append("\n");
            }
        }
        sb.append("Example:\n").append("-Xplugin:Manifold --no-bootstrap");
        return sb.toString();
    }

    static Map<Arg, Set<String>> processArgs(String[] args) {
        HashMap<Arg, Set<String>> map = new HashMap<Arg, Set<String>>();
        if (args == null || args.length == 0) {
            return map;
        }
        Arg valueArg = null;
        for (String arg2 : args) {
            if (valueArg != null) {
                map.computeIfAbsent(valueArg, __ -> new LinkedHashSet()).add(arg2);
                valueArg.validate(arg2, map);
                valueArg = null;
                continue;
            }
            Arg a = Arg.byName(arg2);
            if (a != null) {
                map.putIfAbsent(a, null);
                if (!a.isFlag()) {
                    valueArg = a;
                    continue;
                }
                a.validate(arg2, map);
                continue;
            }
            throw new RuntimeException("Error:  Invalid Manifold plugin argument: " + arg2 + "\n" + Arg.usage());
        }
        if (valueArg != null) {
            throw new RuntimeException("Error:  Expecting value for Manifold plugin " + args[args.length - 1]);
        }
        List missingArgs = Arg.allRequired().stream().filter(arg -> !map.containsKey(arg)).map(arg -> "\n  " + arg.getName() + "  '" + arg.getDescription() + "'").collect(Collectors.toList());
        if (!missingArgs.isEmpty()) {
            String errorMsg = missingArgs.stream().reduce("Error:  Missing required Manifold plugin argument[s]:", String::concat);
            throw new RuntimeException(errorMsg);
        }
        Arg.assignDefaults(map);
        return map;
    }

    private static void assignDefaults(Map<Arg, Set<String>> map) {
        for (Arg arg : Arg.values()) {
            String defaultValue;
            if (map.containsKey((Object)arg) || arg.isRequired() || (defaultValue = arg.getDefaultValue()) == null) continue;
            map.put(arg, Collections.singleton(defaultValue));
        }
    }
}

