/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.host;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import manifold.api.fs.IFile;
import manifold.api.host.ITypeSystemListener;
import manifold.api.host.RefreshKind;
import manifold.api.host.RefreshRequest;
import manifold.internal.host.SingleModuleManifoldHost;

public class TypeRefreshListener {
    private final SingleModuleManifoldHost _host;
    private final CopyOnWriteArrayList<WeakReference<ITypeSystemListener>> _listeners;

    TypeRefreshListener(SingleModuleManifoldHost host) {
        this._host = host;
        this._listeners = new CopyOnWriteArrayList();
    }

    void addTypeSystemListenerAsWeakRef(ITypeSystemListener l) {
        if (!this.hasListener(l)) {
            this._listeners.add(new WeakReference<ITypeSystemListener>(l));
        }
    }

    public void removeTypeSystemListener(ITypeSystemListener l) {
        for (WeakReference<ITypeSystemListener> ref : this._listeners) {
            if (ref.get() != l) continue;
            this._listeners.remove(ref);
            break;
        }
    }

    private List<ITypeSystemListener> getListeners() {
        ArrayList<ITypeSystemListener> listeners = new ArrayList<ITypeSystemListener>(this._listeners.size());
        ArrayList<WeakReference<ITypeSystemListener>> obsoleteListeners = null;
        for (WeakReference<ITypeSystemListener> ref : this._listeners) {
            ITypeSystemListener typeSystemListener = (ITypeSystemListener)ref.get();
            if (typeSystemListener != null) {
                listeners.add(typeSystemListener);
                continue;
            }
            if (obsoleteListeners == null) {
                obsoleteListeners = new ArrayList<WeakReference<ITypeSystemListener>>();
            }
            obsoleteListeners.add(ref);
        }
        if (obsoleteListeners != null) {
            this._listeners.removeAll(obsoleteListeners);
        }
        return listeners;
    }

    private boolean hasListener(ITypeSystemListener l) {
        for (WeakReference<ITypeSystemListener> ref : this._listeners) {
            if (ref.get() != l) continue;
            return true;
        }
        return false;
    }

    void created(IFile file, String[] fqns) {
        this.notify(file, fqns, RefreshKind.CREATION);
    }

    private void notify(IFile file, String[] fqns, RefreshKind kind) {
        RefreshRequest request = new RefreshRequest(file, fqns, this._host.getSingleModule(), kind);
        List<ITypeSystemListener> listeners = this.getListeners();
        switch (kind) {
            case CREATION: 
            case MODIFICATION: {
                this.notifyEarlyListeners(request, listeners);
                this.notifyNonearlyListeners(request, listeners);
                break;
            }
            case DELETION: {
                this.notifyNonearlyListeners(request, listeners);
                this.notifyEarlyListeners(request, listeners);
            }
        }
    }

    private void notifyNonearlyListeners(RefreshRequest request, List<ITypeSystemListener> listeners) {
        for (ITypeSystemListener listener : listeners) {
            if (listener.notifyEarly()) continue;
            listener.refreshedTypes(request);
        }
    }

    private void notifyEarlyListeners(RefreshRequest request, List<ITypeSystemListener> listeners) {
        for (ITypeSystemListener listener : listeners) {
            if (!listener.notifyEarly()) continue;
            listener.refreshedTypes(request);
        }
    }
}

