/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

@PublicApi
public class DataFetcherResult<T> {
    private final T data;
    private final List<GraphQLError> errors;
    private final Object localContext;

    @Internal
    @Deprecated
    public DataFetcherResult(T data, List<GraphQLError> errors) {
        this(data, errors, null);
    }

    private DataFetcherResult(T data, List<GraphQLError> errors, Object localContext) {
        this.data = data;
        this.errors = ImmutableList.copyOf((Collection)Assert.assertNotNull(errors));
        this.localContext = localContext;
    }

    public T getData() {
        return this.data;
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Object getLocalContext() {
        return this.localContext;
    }

    public DataFetcherResult<T> transform(Consumer<Builder<T>> builderConsumer) {
        Builder<DataFetcherResult> builder = new Builder<DataFetcherResult>(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static <T> Builder<T> newResult() {
        return new Builder();
    }

    public static class Builder<T> {
        private T data;
        private Object localContext;
        private final List<GraphQLError> errors = new ArrayList<GraphQLError>();

        public Builder(DataFetcherResult<T> existing) {
            this.data = existing.getData();
            this.localContext = existing.getLocalContext();
            this.errors.addAll(existing.getErrors());
        }

        public Builder(T data) {
            this.data = data;
        }

        public Builder() {
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public Builder<T> errors(List<GraphQLError> errors) {
            this.errors.addAll(errors);
            return this;
        }

        public Builder<T> error(GraphQLError error) {
            this.errors.add(error);
            return this;
        }

        public Builder<T> clearErrors() {
            this.errors.clear();
            return this;
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public Builder<T> localContext(Object localContext) {
            this.localContext = localContext;
            return this;
        }

        public DataFetcherResult<T> build() {
            return new DataFetcherResult(this.data, this.errors, this.localContext);
        }
    }
}

