/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractProductUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.Inductance;
import manifold.science.measures.ResistanceUnit;
import manifold.science.measures.TimeUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class InductanceUnit
extends AbstractProductUnit<ResistanceUnit, TimeUnit, Inductance, InductanceUnit> {
    private static final UnitCache<InductanceUnit> CACHE = new UnitCache();
    public static final InductanceUnit H;
    public static final InductanceUnit BASE;

    public static InductanceUnit get(ResistanceUnit resistanceUnit, TimeUnit timeUnit) {
        return InductanceUnit.get(resistanceUnit, timeUnit, null, null, null);
    }

    public static InductanceUnit get(ResistanceUnit resistanceUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        InductanceUnit unit = new InductanceUnit(resistanceUnit, timeUnit, factor, name, symbol);
        return (InductanceUnit)CACHE.get(unit);
    }

    private InductanceUnit(ResistanceUnit resistanceUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        super(resistanceUnit, timeUnit, factor, name, symbol);
    }

    @Override
    public Inductance makeDimension(Number amount) {
        return new Inductance(Rational.get(amount), this);
    }

    public ResistanceUnit getResistanceUnit() {
        return (ResistanceUnit)this.getLeftUnit();
    }

    public TimeUnit getTimeUnit() {
        return (TimeUnit)this.getRightUnit();
    }

    @Override
    public ResistanceUnit div(TimeUnit w) {
        return this.getResistanceUnit();
    }

    static {
        BASE = H = InductanceUnit.get(ResistanceUnit.BASE, TimeUnit.BASE, CoercionConstants.r.postfixBind(1), "Henry", "H");
    }
}

