/*
 * Decompiled with CFR 0.152.
 */
package manifold.io.extensions.java.io.InputStream;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import manifold.io.extensions.java.io.Reader.ManReaderExt;

@Extension
public class ManInputStreamExt {
    public static InputStreamReader reader(@This InputStream thiz) {
        return ManInputStreamExt.reader(thiz, StandardCharsets.UTF_8);
    }

    public static InputStreamReader reader(@This InputStream thiz, Charset charset) {
        return new InputStreamReader(thiz, charset);
    }

    public static BufferedReader bufferedReader(@This InputStream thiz) {
        return ManInputStreamExt.bufferedReader(thiz, StandardCharsets.UTF_8);
    }

    public static BufferedReader bufferedReader(@This InputStream thiz, Charset charset) {
        return ManReaderExt.buffered(ManInputStreamExt.reader(thiz, charset));
    }

    public static long copyTo(@This InputStream thiz, OutputStream out) {
        return ManInputStreamExt.copyTo(thiz, out, 8192);
    }

    public static long copyTo(@This InputStream thiz, OutputStream out, int bufferSize) {
        try {
            long bytesCopied = 0L;
            byte[] buffer = new byte[bufferSize];
            int bytes = thiz.read(buffer);
            while (bytes >= 0) {
                out.write(buffer, 0, bytes);
                bytesCopied += (long)bytes;
                bytes = thiz.read(buffer);
            }
            return bytesCopied;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

