/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.SymbolMetadata;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.AttrContextEnv;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import manifold.ExtIssueMsg;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.host.IManifoldHost;
import manifold.api.type.ContributorKind;
import manifold.api.type.ITypeManifold;
import manifold.ext.ExtensionManifold;
import manifold.ext.StructuralTypeEraser;
import manifold.ext.TypeUtil;
import manifold.ext.rt.ExtensionMethod;
import manifold.ext.rt.ReflectionRuntimeMethods;
import manifold.ext.rt.RuntimeMethods;
import manifold.ext.rt.api.ComparableUsing;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.Intercept;
import manifold.ext.rt.api.Jailbreak;
import manifold.ext.rt.api.Self;
import manifold.ext.rt.api.Structural;
import manifold.ext.rt.api.This;
import manifold.ext.rt.api.ThisClass;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.FragmentProcessor;
import manifold.internal.javac.GeneratedJavaStubFileObject;
import manifold.internal.javac.HostKind;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.ILetExpr;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManAttr;
import manifold.internal.javac.MethodRefToLambda;
import manifold.internal.javac.OverloadOperatorSymbol;
import manifold.internal.javac.ParserFactoryFiles;
import manifold.internal.javac.StaticCompiler;
import manifold.internal.javac.TypeProcessor;
import manifold.rt.api.Array;
import manifold.rt.api.FragmentValue;
import manifold.rt.api.IncrementalCompile;
import manifold.rt.api.Precompile;
import manifold.rt.api.util.Pair;
import manifold.rt.api.util.TypesUtil;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.ConcurrentHashSet;

public class ExtensionTransformer
extends TreeTranslator {
    private final ExtensionManifold _sp;
    private final TypeProcessor _tp;
    private boolean _bridgeMethod;
    private boolean _lambdaMethod;
    private JCTree.JCVariableDecl _parameter;
    private int tempVarIndex = 0;

    public ExtensionTransformer(ExtensionManifold sp, TypeProcessor typeProcessor) {
        this._sp = sp;
        this._tp = typeProcessor;
    }

    public TypeProcessor getTypeProcessor() {
        return this._tp;
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        super.visitIndexed(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (this._tp.getTypes().isArray(tree.indexed.type)) {
            return;
        }
        Symbol.MethodSymbol operatorMethod = ManAttr.resolveIndexGetMethod(this._tp.getTypes(), tree.indexed.type, tree.index.type);
        if (operatorMethod != null) {
            Tree parent = this._tp.getParent(tree);
            if (parent instanceof JCTree.JCAssign && ((JCTree.JCAssign)parent).lhs == tree) {
                return;
            }
            if (parent instanceof JCTree.JCAssignOp && ((JCTree.JCAssignOp)parent).lhs == tree) {
                return;
            }
            if (parent instanceof JCTree.JCUnary) {
                switch (((JCTree.JCUnary)parent).getTag()) {
                    case POSTDEC: 
                    case POSTINC: 
                    case PREDEC: 
                    case PREINC: {
                        return;
                    }
                }
            }
            TreeMaker make = this._tp.getTreeMaker();
            JCTree.JCExpression receiver = tree.indexed;
            JCTree.JCExpression arg = tree.index;
            arg = this.boxUnboxIfNeeded(this._tp.getTypes(), this._tp.getTreeMaker(), Names.instance(this._tp.getContext()), arg, operatorMethod.params().get((int)0).type);
            JCTree.JCMethodInvocation methodCall = make.Apply(List.nil(), IDynamicJdk.instance().Select(make, receiver, operatorMethod), List.of(arg));
            methodCall = this.configMethod(tree, operatorMethod, methodCall);
            this.result = methodCall;
        }
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        super.visitBinary(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        IDynamicJdk dynJdk = IDynamicJdk.instance();
        Symbol op = dynJdk.getOperator(tree);
        if (op instanceof OverloadOperatorSymbol) {
            TreeMaker make = this._tp.getTreeMaker();
            Symtab symbols = this._tp.getSymtab();
            Symbol.MethodSymbol operatorMethod = (Symbol.MethodSymbol)op;
            boolean swap = false;
            while (operatorMethod instanceof OverloadOperatorSymbol) {
                swap = ((OverloadOperatorSymbol)operatorMethod).isSwapped();
                operatorMethod = ((OverloadOperatorSymbol)operatorMethod).getMethod();
            }
            if (operatorMethod != null) {
                JCTree.JCMethodInvocation methodCall;
                operatorMethod = this.favorStringsWithNumberCoercion(tree, operatorMethod);
                JCTree.JCExpression expr = null;
                JCTree.JCExpression receiver = swap ? tree.rhs : tree.lhs;
                JCTree.JCExpression arg = swap ? tree.lhs : tree.rhs;
                arg = this.boxUnboxIfNeeded(this._tp.getTypes(), this._tp.getTreeMaker(), Names.instance(this._tp.getContext()), arg, operatorMethod.params().get((int)0).type);
                if (ManAttr.isComparableOperator(tree.getTag())) {
                    Context ctx = JavacPlugin.instance().getContext();
                    if (tree.getTag() == JCTree.Tag.EQ || tree.getTag() == JCTree.Tag.NE) {
                        JCTree[] argTemp;
                        ++this.tempVarIndex;
                        Symbol owner = this.getEnclosingSymbol(tree, ctx);
                        List<Object> tempVars = List.nil();
                        JCTree[] receiverTemp = this.tempify(tree, make, receiver, ctx, owner, "$receiverExprTemp" + this.tempVarIndex);
                        if (receiverTemp != null) {
                            tempVars = tempVars.append((JCTree.JCVariableDecl)receiverTemp[0]);
                            receiver = (JCTree.JCExpression)receiverTemp[1];
                        }
                        if ((argTemp = this.tempify(tree, make, arg, ctx, owner, "$argExprTemp" + this.tempVarIndex)) != null) {
                            tempVars = tempVars.append((JCTree.JCVariableDecl)argTemp[0]);
                            arg = (JCTree.JCExpression)argTemp[1];
                        }
                        JCTree.JCBinary cond = make.Binary(JCTree.Tag.EQ, receiver, arg);
                        cond.type = symbols.booleanType;
                        dynJdk.setOperatorSymbol(ctx, cond, JCTree.Tag.EQ, "==", symbols.objectType.tsym);
                        JCTree.JCLiteral nullLiteral = make.Literal(TypeTag.BOT, null);
                        nullLiteral.type = symbols.objectType;
                        JCTree.JCBinary eqNull1 = make.Binary(JCTree.Tag.EQ, receiver, nullLiteral);
                        eqNull1.type = symbols.booleanType;
                        dynJdk.setOperatorSymbol(ctx, eqNull1, JCTree.Tag.EQ, "==", symbols.objectType.tsym);
                        JCTree.JCBinary eqNull2 = make.Binary(JCTree.Tag.EQ, arg, nullLiteral);
                        eqNull2.type = symbols.booleanType;
                        dynJdk.setOperatorSymbol(ctx, eqNull2, JCTree.Tag.EQ, "==", symbols.objectType.tsym);
                        JCTree.JCBinary elsePart = make.Binary(JCTree.Tag.OR, eqNull1, eqNull2);
                        elsePart.type = symbols.booleanType;
                        dynJdk.setOperatorSymbol(ctx, elsePart, JCTree.Tag.OR, "||", symbols.booleanType.tsym);
                        methodCall = make.Apply(List.nil(), IDynamicJdk.instance().Select(make, receiver, operatorMethod), List.from(new JCTree.JCExpression[]{arg, this.getRelationalOpEnumConst(make, tree)}));
                        methodCall = this.configMethod(tree, operatorMethod, methodCall);
                        JCTree.JCConditional elsePart2 = make.Conditional(elsePart, make.Literal(tree.getTag() == JCTree.Tag.NE), methodCall);
                        elsePart2.type = symbols.booleanType;
                        expr = make.Conditional(cond, make.Literal(tree.getTag() == JCTree.Tag.EQ), elsePart2);
                        expr.type = symbols.booleanType;
                        expr.pos = tree.pos;
                        if (!tempVars.isEmpty()) {
                            expr = ILetExpr.makeLetExpr(make, tempVars, expr, expr.type, expr.pos);
                        }
                    } else if (operatorMethod.name.toString().equals("compareTo")) {
                        methodCall = make.Apply(List.nil(), IDynamicJdk.instance().Select(make, receiver, operatorMethod), List.of(arg));
                        methodCall.type = symbols.intType;
                        methodCall.pos = tree.pos;
                        JCTree.JCLiteral zeroLiteral = make.Literal(TypeTag.INT, 0);
                        zeroLiteral.type = symbols.intType;
                        JCTree.JCBinary compareToCond = make.Binary(tree.getTag(), methodCall, zeroLiteral);
                        compareToCond.type = symbols.booleanType;
                        dynJdk.setOperatorSymbol(ctx, compareToCond, tree.getTag(), this.relOpString(tree.getTag()), symbols.intType.tsym);
                        compareToCond.pos = tree.pos;
                        expr = compareToCond;
                    } else {
                        methodCall = make.Apply(List.nil(), IDynamicJdk.instance().Select(make, receiver, operatorMethod), List.from(new JCTree.JCExpression[]{arg, this.getRelationalOpEnumConst(make, tree)}));
                        methodCall = this.configMethod(tree, operatorMethod, methodCall);
                    }
                } else {
                    methodCall = make.Apply(List.nil(), IDynamicJdk.instance().Select(make, receiver, operatorMethod), List.of(arg));
                    methodCall = this.configMethod(tree, operatorMethod, methodCall);
                }
                this.result = expr == null ? methodCall : expr;
            }
        }
    }

    private JCTree[] tempify(JCTree.JCExpression tree, TreeMaker make, JCTree.JCExpression expr, Context ctx, Symbol owner, String varName) {
        return ExtensionTransformer.tempify(false, tree, make, expr, ctx, owner, varName, this.tempVarIndex);
    }

    private JCTree[] tempify(boolean force, JCTree.JCExpression tree, TreeMaker make, JCTree.JCExpression expr, Context ctx, Symbol owner, String varName) {
        return ExtensionTransformer.tempify(force, tree, make, expr, ctx, owner, varName, this.tempVarIndex);
    }

    public static JCTree[] tempify(boolean force, JCTree.JCExpression tree, TreeMaker make, JCTree.JCExpression expr, Context ctx, Symbol owner, String varName, int tempVarIndex) {
        switch (expr.getTag()) {
            case LITERAL: 
            case IDENT: {
                if (force) break;
                return null;
            }
        }
        JCTree.JCVariableDecl tempVar = make.VarDef(make.Modifiers(4112L), Names.instance(ctx).fromString(varName + tempVarIndex), make.Type(expr.type), expr);
        tempVar.sym = new Symbol.VarSymbol(4112L, tempVar.name, expr.type, owner);
        tempVar.type = tempVar.sym.type;
        tempVar.pos = tree.pos;
        JCTree.JCExpression ident = make.Ident(tempVar);
        ident.type = expr.type;
        ident.pos = tree.pos;
        return new JCTree[]{tempVar, ident};
    }

    private JCTree.JCMethodInvocation configMethod(JCTree.JCExpression tree, Symbol.MethodSymbol operatorMethod, JCTree.JCMethodInvocation methodCall) {
        methodCall.setPos(tree.pos);
        methodCall.type = operatorMethod.getReturnType();
        methodCall = this.maybeReplaceWithExtensionMethod(methodCall);
        methodCall = this.maybeReplaceWithStructuralCall(methodCall);
        methodCall.type = tree.type;
        return methodCall;
    }

    private String relOpString(JCTree.Tag tag) {
        switch (tag) {
            case LT: {
                return "<";
            }
            case LE: {
                return "<=";
            }
            case GT: {
                return ">";
            }
            case GE: {
                return ">=";
            }
        }
        throw new IllegalStateException("Expecting only relational op, but found: " + (Object)((Object)tag));
    }

    private Symbol.MethodSymbol favorStringsWithNumberCoercion(JCTree.JCBinary tree, Symbol.MethodSymbol operatorMethod) {
        String operatorMethodName = operatorMethod.name.toString();
        if (!operatorMethodName.equals("postfixBind")) {
            return operatorMethod;
        }
        if (tree.lhs instanceof JCTree.JCLiteral && (tree.lhs.getKind() == Tree.Kind.FLOAT_LITERAL || tree.lhs.getKind() == Tree.Kind.DOUBLE_LITERAL)) {
            Type rhsType = tree.rhs.type;
            Symbol.MethodSymbol postfixBinding_string = ManAttr.getMethodSymbol(this._tp.getTypes(), rhsType, this._tp.getSymtab().stringType, operatorMethodName, (Symbol.ClassSymbol)rhsType.tsym, 1);
            if (postfixBinding_string != null && ((Symbol.VarSymbol)((List)postfixBinding_string.getParameters()).get((int)0)).type.tsym == this._tp.getSymtab().stringType.tsym && postfixBinding_string.getReturnType().equals(operatorMethod.getReturnType())) {
                int end;
                int start;
                CharSequence source = ParserFactoryFiles.getSource(this._tp.getCompilationUnit().getSourceFile());
                String token = source.subSequence(start = tree.lhs.pos, end = tree.lhs.pos().getEndPosition(((JCTree.JCCompilationUnit)this._tp.getCompilationUnit()).endPositions)).toString();
                if (token.endsWith("d") || token.endsWith("f")) {
                    token = token.substring(0, token.length() - 1);
                }
                JCTree.JCLiteral temp = (JCTree.JCLiteral)tree.lhs;
                tree.lhs = this._tp.getTreeMaker().Literal(token);
                tree.lhs.type = this._tp.getSymtab().stringType;
                tree.lhs.pos = temp.pos;
                return postfixBinding_string;
            }
        }
        return operatorMethod;
    }

    private JCTree.JCExpression getRelationalOpEnumConst(TreeMaker make, JCTree tree) {
        Symbol.ClassSymbol opClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), ComparableUsing.Operator.class.getCanonicalName());
        Names names = Names.instance(this._tp.getContext());
        Symbol.VarSymbol operatorSym = this.resolveField(tree.pos(), this._tp.getContext(), names.fromString(tree.getTag().name()), opClassSym.type);
        JCTree.JCFieldAccess opEnumConst = (JCTree.JCFieldAccess)ExtensionTransformer.memberAccess(make, this._tp.getElementUtil(), ComparableUsing.Operator.class.getName() + "." + tree.getTag().name());
        opEnumConst.type = operatorSym.type;
        opEnumConst.sym = operatorSym;
        opEnumConst.pos = tree.pos;
        this.assignTypes(opEnumConst.selected, opClassSym);
        opEnumConst.selected.pos = tree.pos;
        return opEnumConst;
    }

    <T extends JCTree> T boxUnboxIfNeeded(Types types, TreeMaker make, Names names, T tree, Type type) {
        boolean havePrimitive = tree.type.isPrimitive();
        if (havePrimitive == type.isPrimitive()) {
            return tree;
        }
        if (havePrimitive) {
            Type unboxedTarget = types.unboxedType(type);
            if (!unboxedTarget.hasTag(TypeTag.NONE)) {
                if (!types.isSubtype(tree.type, unboxedTarget)) {
                    tree.type = unboxedTarget.constType(tree.type.constValue());
                }
                return (T)this.boxPrimitive(types, make, names, (JCTree.JCExpression)tree, type);
            }
            tree = this.boxPrimitive(types, make, names, (JCTree.JCExpression)tree);
        } else {
            tree = ExtensionTransformer.unbox(types, make, names, this._tp.getContext(), this._tp.getCompilationUnit(), (JCTree.JCExpression)tree, type);
        }
        return tree;
    }

    private JCTree.JCExpression boxPrimitive(Types types, TreeMaker make, Names names, JCTree.JCExpression tree) {
        return this.boxPrimitive(types, make, names, tree, types.boxedClass((Type)tree.type).type);
    }

    private JCTree.JCExpression boxPrimitive(Types types, TreeMaker make, Names names, JCTree.JCExpression tree, Type box) {
        make.at(tree.pos());
        Symbol.MethodSymbol valueOfSym = this.resolveMethod(tree.pos(), names.valueOf, box, List.nil().prepend(tree.type));
        return make.App(make.QualIdent(valueOfSym), List.of(tree));
    }

    public static JCTree.JCExpression unbox(Types types, TreeMaker make, Names names, Context context, CompilationUnitTree compUnit, JCTree.JCExpression tree, Type primitive) {
        Type unboxedType = types.unboxedType(tree.type);
        if (unboxedType.hasTag(TypeTag.NONE)) {
            unboxedType = primitive;
            if (!unboxedType.isPrimitive()) {
                throw new AssertionError(unboxedType);
            }
            make.at(tree.pos());
            tree = make.TypeCast(types.boxedClass((Type)unboxedType).type, tree);
        } else if (!types.isSubtype(unboxedType, primitive)) {
            throw new AssertionError(tree);
        }
        make.at(tree.pos());
        Symbol.MethodSymbol valueSym = ExtensionTransformer.resolveMethod(tree.pos(), context, (JCTree.JCCompilationUnit)compUnit, unboxedType.tsym.name.append(names.Value), tree.type, List.nil());
        return make.App(IDynamicJdk.instance().Select(make, tree, valueSym));
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        super.visitIdent(tree);
        if (!(!this._tp.isGenerate() || this.shouldProcessForGeneration() || this.shouldProcessForLambdaGeneration() && this._parameter != null)) {
            return;
        }
        if (TypesUtil.isStructuralInterface(this._tp.getTypes(), tree.sym) && !this.isReceiver(tree)) {
            Symbol.ClassSymbol objectSym = this.getObjectClass();
            JCTree.JCVariableDecl parent = this._parameter != null ? this._parameter : this._tp.getParent(tree);
            JCTree.JCIdent objIdent = this._tp.getTreeMaker().Ident(objectSym);
            if (parent instanceof JCTree.JCVariableDecl) {
                parent.type = objectSym.type;
                long parameterModifier = 0x200000000L;
                if ((parent.mods.flags & parameterModifier) != 0L) {
                    objIdent.type = objectSym.type;
                    parent.sym.type = objectSym.type;
                    parent.vartype = objIdent;
                }
            } else if (parent instanceof JCTree.JCWildcard) {
                JCTree.JCWildcard wildcard = (JCTree.JCWildcard)((Object)parent);
                wildcard.type = new Type.WildcardType(objectSym.type, wildcard.kind.kind, wildcard.type.tsym);
            }
            tree = objIdent;
            tree.type = objectSym.type;
        }
        this.result = tree;
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        super.visitLambda(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        tree.type = this.eraseStructureType(tree.type);
        ArrayList<Type> types = new ArrayList<Type>();
        for (Type target : IDynamicJdk.instance().getTargets(tree)) {
            types.add(this.eraseStructureType(target));
        }
        IDynamicJdk.instance().setTargets(tree, List.from(types));
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        super.visitSelect(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (TypesUtil.isStructuralInterface(this._tp.getTypes(), tree.sym) && !this.isReceiver(tree)) {
            Symbol.ClassSymbol objectSym = this.getObjectClass();
            JCTree.JCIdent objIdent = this._tp.getTreeMaker().Ident(objectSym);
            Tree parent = this._tp.getParent(tree);
            if (parent instanceof JCTree.JCVariableDecl) {
                ((JCTree.JCVariableDecl)parent).type = objectSym.type;
                long parameterModifier = 0x200000000L;
                if ((((JCTree.JCVariableDecl)parent).mods.flags & parameterModifier) != 0L) {
                    objIdent.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).sym.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).vartype = objIdent;
                }
            } else if (parent instanceof JCTree.JCWildcard) {
                JCTree.JCWildcard wildcard = (JCTree.JCWildcard)parent;
                wildcard.type = new Type.WildcardType(objectSym.type, wildcard.kind.kind, wildcard.type.tsym);
            }
            this.result = objIdent;
        } else {
            this.result = ExtensionTransformer.isJailbreakReceiver(tree) ? this.replaceWithReflection(tree) : tree;
        }
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        super.visitAssign(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (this.handleIndexedAssignment(tree)) {
            return;
        }
        this.result = ExtensionTransformer.isJailbreakReceiver(tree) ? this.replaceWithReflection(tree) : tree;
    }

    private boolean handleIndexedAssignment(JCTree.JCAssign tree) {
        if (!(tree.lhs instanceof JCTree.JCArrayAccess)) {
            return false;
        }
        JCTree.JCArrayAccess lhs = (JCTree.JCArrayAccess)tree.lhs;
        if (this._tp.getTypes().isArray(lhs.indexed.type)) {
            return false;
        }
        Symbol.MethodSymbol operatorMethod = ManAttr.resolveIndexSetMethod(this._tp.getTypes(), lhs.indexed.type, lhs.index.type);
        Context ctx = JavacPlugin.instance().getContext();
        if (operatorMethod != null) {
            TreeMaker make = this._tp.getTreeMaker();
            ++this.tempVarIndex;
            List<Object> tempVars = List.nil();
            JCTree.JCExpression rhs = tree.rhs;
            JCTree[] rhsTemp = this.tempify(tree, make, rhs, ctx, this.getEnclosingSymbol(tree, ctx), "setRhsTempVar" + this.tempVarIndex);
            if (rhsTemp != null) {
                tempVars = tempVars.append((JCTree.JCVariableDecl)rhsTemp[0]);
                rhs = (JCTree.JCExpression)rhsTemp[1];
            }
            JCTree.JCExpression receiver = lhs.indexed;
            JCTree.JCExpression arg = lhs.index;
            Type parameterizedMethod = this._tp.getTypes().memberType(lhs.indexed.type, operatorMethod);
            while (parameterizedMethod instanceof Type.ForAll) {
                parameterizedMethod = parameterizedMethod.asMethodType();
            }
            arg = this.boxUnboxIfNeeded(this._tp.getTypes(), this._tp.getTreeMaker(), Names.instance(this._tp.getContext()), arg, parameterizedMethod.getParameterTypes().get(0));
            JCTree.JCMethodInvocation setCall = make.Apply(List.nil(), IDynamicJdk.instance().Select(make, receiver, operatorMethod), List.of(arg, rhs));
            setCall = this.configMethod(lhs, operatorMethod, setCall);
            JCTree[] setCallTemp = this.tempify(true, tree, make, setCall, ctx, this.getEnclosingSymbol(tree, ctx), "$setCallTempVar" + this.tempVarIndex);
            tempVars = tempVars.append((JCTree.JCVariableDecl)setCallTemp[0]);
            JCTree.LetExpr letExpr = ILetExpr.makeLetExpr(make, tempVars, rhs, lhs.type, tree.pos);
            this.result = letExpr;
            return true;
        }
        return false;
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        super.visitAssignop(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (ExtensionTransformer.isJailbreakReceiver(tree)) {
            this._tp.report(tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_COMPOUND_OP_NOT_ALLOWED_REFLECTION.get(new Object[0]));
            Types types = Types.instance(((BasicJavacTask)this._tp.getJavacTask()).getContext());
            tree.type = types.createErrorType(tree.type);
            this.result = tree;
        } else {
            this.result = tree;
        }
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        Tree.Kind kind;
        super.visitUnary(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        Symbol op = IDynamicJdk.instance().getOperator(tree);
        boolean isOverload = op instanceof OverloadOperatorSymbol;
        TreeMaker make = this._tp.getTreeMaker();
        if (!(op instanceof Symbol.MethodSymbol)) {
            return;
        }
        Symbol.MethodSymbol operatorMethod = (Symbol.MethodSymbol)op;
        while (operatorMethod instanceof OverloadOperatorSymbol) {
            operatorMethod = ((OverloadOperatorSymbol)operatorMethod).getMethod();
        }
        JCTree.Tag tag = tree.getTag();
        if (isOverload && operatorMethod != null && (JCTree.Tag.NEG == tag || JCTree.Tag.NOT == tag || JCTree.Tag.COMPL == tag)) {
            this.genUnary(tree, make, operatorMethod);
            return;
        }
        if (isOverload && operatorMethod != null || tree.arg instanceof JCTree.JCArrayAccess && !this._tp.getTypes().isArray(((JCTree.JCArrayAccess)tree.arg).indexed.type)) {
            switch (tree.getTag()) {
                case POSTDEC: 
                case POSTINC: 
                case PREDEC: 
                case PREINC: {
                    this.genUnaryIncDec(tree, make, isOverload ? operatorMethod : null);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return;
        }
        if (ExtensionTransformer.isJailbreakReceiver(tree) && ((kind = tree.getKind()) == Tree.Kind.POSTFIX_INCREMENT || kind == Tree.Kind.POSTFIX_DECREMENT || kind == Tree.Kind.PREFIX_INCREMENT || kind == Tree.Kind.PREFIX_DECREMENT)) {
            this._tp.report(tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_INCREMENT_OP_NOT_ALLOWED_REFLECTION.get(new Object[0]));
            Types types = Types.instance(((BasicJavacTask)this._tp.getJavacTask()).getContext());
            tree.type = types.createErrorType(tree.type);
        }
        this.result = tree;
    }

    private void genUnaryIncDec(JCTree.JCUnary tree, TreeMaker make, Symbol.MethodSymbol operatorMethod) {
        JCTree.JCExpression answer;
        boolean isPost = tree.getTag() == JCTree.Tag.POSTDEC || tree.getTag() == JCTree.Tag.POSTINC;
        ++this.tempVarIndex;
        List<Object> tempVars = List.nil();
        JCTree.JCExpression receiver = tree.arg;
        Context ctx = JavacPlugin.instance().getContext();
        if (receiver instanceof JCTree.JCArrayAccess) {
            JCTree[] oldValTemp;
            JCTree.JCExpression index = ((JCTree.JCArrayAccess)receiver).index;
            JCTree[] indexTemp = this.tempify(tree, make, index, ctx, this.getEnclosingSymbol(tree, ctx), "$indexExprTemp" + this.tempVarIndex);
            if (indexTemp != null) {
                tempVars = tempVars.append((JCTree.JCVariableDecl)indexTemp[0]);
                index = (JCTree.JCExpression)indexTemp[1];
            }
            JCTree[] indexedTemp = this.tempify(true, tree, make, ((JCTree.JCArrayAccess)receiver).indexed, ctx, this.getEnclosingSymbol(tree, ctx), "$indexedExprTemp" + this.tempVarIndex);
            tempVars = tempVars.append((JCTree.JCVariableDecl)indexedTemp[0]);
            receiver = (JCTree.JCExpression)indexedTemp[1];
            Symbol.MethodSymbol indexedGetMethod = ManAttr.resolveIndexGetMethod(this._tp.getTypes(), receiver.type, index.type);
            if (indexedGetMethod != null) {
                JCTree.JCMethodInvocation methodCall = make.Apply(List.nil(), IDynamicJdk.instance().Select(make, receiver, indexedGetMethod), List.of(index));
                methodCall.setPos(tree.pos);
                methodCall.type = tree.arg.type;
                methodCall = this.maybeReplaceWithExtensionMethod(methodCall);
                oldValTemp = this.tempify(true, tree, make, methodCall, ctx, this.getEnclosingSymbol(tree, ctx), "$oldValueTemp" + this.tempVarIndex);
                tempVars = tempVars.append((JCTree.JCVariableDecl)oldValTemp[0]);
                answer = (JCTree.JCExpression)oldValTemp[1];
            } else {
                JCTree.JCArrayAccess arrayAccess = make.Indexed(receiver, index);
                arrayAccess.setPos(tree.pos);
                arrayAccess.type = tree.arg.type;
                oldValTemp = this.tempify(true, tree, make, arrayAccess, ctx, this.getEnclosingSymbol(tree, ctx), "$oldValueTemp" + this.tempVarIndex);
                tempVars = tempVars.append((JCTree.JCVariableDecl)oldValTemp[0]);
                answer = (JCTree.JCExpression)oldValTemp[1];
            }
            JCTree.JCExpression incDecValue = this.makeUnaryIncDecCall(tree, make, operatorMethod, answer);
            Symbol.MethodSymbol indexedSetMethod = ManAttr.resolveIndexSetMethod(this._tp.getTypes(), receiver.type, index.type);
            if (indexedSetMethod != null) {
                JCTree[] incDecTempValue = this.tempify(true, tree, make, incDecValue, ctx, this.getEnclosingSymbol(tree, ctx), "$assignExprTemp2" + this.tempVarIndex);
                tempVars = tempVars.append((JCTree.JCVariableDecl)incDecTempValue[0]);
                incDecValue = (JCTree.JCExpression)incDecTempValue[1];
                JCTree.JCMethodInvocation setCall = make.Apply(List.nil(), IDynamicJdk.instance().Select(make, receiver, indexedSetMethod), List.of(index, incDecValue));
                setCall.setPos(tree.pos);
                setCall.type = tree.arg.type;
                setCall = this.maybeReplaceWithExtensionMethod(setCall);
                if (!isPost) {
                    answer = incDecValue;
                }
                incDecValue = setCall;
            } else {
                JCTree.JCArrayAccess arrayAccess = make.Indexed(receiver, index);
                arrayAccess.setPos(tree.pos);
                arrayAccess.type = tree.arg.type;
                JCTree.JCAssign assign = make.Assign(arrayAccess, incDecValue);
                assign.type = arrayAccess.type;
                assign.setPos(tree.pos);
                JCTree[] assignTempVar = this.tempify(true, tree, make, assign, ctx, this.getEnclosingSymbol(tree, ctx), "$assignExprTemp2" + this.tempVarIndex);
                tempVars = tempVars.append((JCTree.JCVariableDecl)assignTempVar[0]);
                if (!isPost) {
                    answer = (JCTree.JCExpression)assignTempVar[1];
                }
                incDecValue = assign;
            }
            JCTree[] assignTempVar = this.tempify(true, tree, make, incDecValue, ctx, this.getEnclosingSymbol(tree, ctx), "$assignExprTemp" + this.tempVarIndex);
            tempVars = tempVars.append((JCTree.JCVariableDecl)assignTempVar[0]);
        } else {
            JCTree[] oldValTemp = this.tempify(true, tree, make, receiver, ctx, this.getEnclosingSymbol(tree, ctx), "$oldValueTemp" + this.tempVarIndex);
            tempVars = tempVars.append((JCTree.JCVariableDecl)oldValTemp[0]);
            answer = (JCTree.JCExpression)oldValTemp[1];
            JCTree.JCExpression methodCall = this.makeUnaryIncDecCall(tree, make, operatorMethod, answer);
            JCTree.JCAssign assign = make.Assign(receiver, methodCall);
            assign.type = answer.type;
            assign.setPos(tree.pos);
            JCTree[] assignTempVar = this.tempify(true, tree, make, assign, ctx, this.getEnclosingSymbol(tree, ctx), "$assignExprTemp" + this.tempVarIndex);
            tempVars = tempVars.append((JCTree.JCVariableDecl)assignTempVar[0]);
            if (!isPost) {
                answer = (JCTree.JCExpression)assignTempVar[1];
            }
        }
        this.result = ILetExpr.makeLetExpr(make, tempVars, answer, tree.arg.type, tree.pos);
    }

    public JCTree.JCMethodInvocation maybeReplaceWithExtensionMethod(JCTree.JCMethodInvocation methodCall) {
        boolean[] isSmartStatic = new boolean[]{false};
        InterceptType[] interceptType = new InterceptType[]{null};
        Symbol.MethodSymbol extMethod = this.findExtMethod(methodCall, isSmartStatic, interceptType);
        if (extMethod != null) {
            methodCall = this.replaceExtCall(methodCall, extMethod, isSmartStatic[0], interceptType[0]);
        }
        return methodCall;
    }

    public JCTree.JCMethodInvocation maybeReplaceWithStructuralCall(JCTree.JCMethodInvocation methodCall) {
        if (this.isStructuralMethod(methodCall)) {
            methodCall = this.replaceStructuralCall(methodCall);
        }
        return methodCall;
    }

    private JCTree.JCExpression makeUnaryIncDecCall(JCTree.JCUnary tree, TreeMaker make, Symbol.MethodSymbol operatorMethod, JCTree.JCExpression operand) {
        if (operatorMethod == null) {
            Type unboxedType = this._tp.getTypes().unboxedType(operand.type);
            if (unboxedType != null && !unboxedType.hasTag(TypeTag.NONE)) {
                operand = ExtensionTransformer.unbox(this._tp.getTypes(), this._tp.getTreeMaker(), Names.instance(JavacPlugin.instance().getContext()), this._tp.getContext(), this._tp.getCompilationUnit(), operand, unboxedType);
            }
            JCTree.JCExpression one = make.Literal(1);
            one.pos = tree.pos;
            one = make.TypeCast(operand.type, one);
            one.pos = tree.pos;
            JCTree.JCBinary binary = make.Binary(tree.getTag() == JCTree.Tag.PREINC || tree.getTag() == JCTree.Tag.POSTINC ? JCTree.Tag.PLUS : JCTree.Tag.MINUS, operand, one);
            binary.pos = tree.pos;
            binary.type = operand.type;
            AttrContextEnv env = new AttrContextEnv((JCTree)tree, new AttrContext());
            env.toplevel = (JCTree.JCCompilationUnit)this._tp.getCompilationUnit();
            env.enclClass = this.getEnclosingClass(tree);
            if (JreUtil.isJava8()) {
                binary.operator = this.resolveMethod(tree.pos(), Names.instance(this._tp.getContext()).fromString(binary.getTag() == JCTree.Tag.PLUS ? "+" : "-"), this._tp.getSymtab().predefClass.type, List.of(binary.lhs.type, binary.rhs.type));
            } else {
                Object operators = ReflectUtil.method("com.sun.tools.javac.comp.Operators", "instance", Context.class).invokeStatic(this._tp.getContext());
                ReflectUtil.field(binary, "operator").set(ReflectUtil.method(operators, "resolveBinary", JCDiagnostic.DiagnosticPosition.class, JCTree.Tag.class, Type.class, Type.class).invoke(new Object[]{tree.pos(), binary.getTag(), binary.lhs.type, binary.rhs.type}));
            }
            return binary;
        }
        JCTree.JCMethodInvocation methodCall = make.Apply(List.nil(), IDynamicJdk.instance().Select(make, operand, operatorMethod), List.nil());
        methodCall.setPos(tree.pos);
        methodCall.type = operatorMethod.getReturnType();
        methodCall = this.maybeReplaceWithExtensionMethod(methodCall);
        return methodCall;
    }

    private void genUnaryPreIncDec(JCTree.JCUnary tree, TreeMaker make, Symbol.MethodSymbol operatorMethod) {
        JCTree.JCMethodInvocation methodCall = make.Apply(List.nil(), IDynamicJdk.instance().Select(make, tree.arg, operatorMethod), List.nil());
        methodCall.setPos(tree.pos);
        methodCall.type = operatorMethod.getReturnType();
        methodCall = this.maybeReplaceWithExtensionMethod(methodCall);
        JCTree.JCAssign assign = make.Assign(tree.arg, methodCall);
        assign.type = tree.arg.type;
        assign.setPos(tree.pos);
        this.result = assign;
    }

    public void genUnary(JCTree.JCUnary tree, TreeMaker make, Symbol.MethodSymbol operatorMethod) {
        JCTree.JCExpression receiver = tree.getExpression();
        JCTree.JCMethodInvocation methodCall = make.Apply(List.nil(), IDynamicJdk.instance().Select(make, receiver, operatorMethod), List.nil());
        methodCall.setPos(tree.pos);
        methodCall.type = operatorMethod.getReturnType();
        methodCall = this.maybeReplaceWithExtensionMethod(methodCall);
        this.result = methodCall;
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        super.visitNewClass(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        this.result = ExtensionTransformer.isJailbreakReceiver(tree) ? this.replaceWithReflection(tree) : tree;
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        super.visitConditional(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (TypesUtil.isStructuralInterface(this._tp.getTypes(), tree.type.tsym)) {
            Symbol.ClassSymbol objectSym = this.getObjectClass();
            tree.type = objectSym.type;
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        if (this.shouldProcessForLambdaGeneration() && (tree.getModifiers().flags & 0x200000000L) != 0L) {
            this._parameter = tree;
        }
        try {
            super.visitVarDef(tree);
        }
        finally {
            this._parameter = null;
        }
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        JCTree.JCExpression vartype = tree.vartype;
        if (vartype instanceof JCTree.JCAnnotatedType && ((JCTree.JCAnnotatedType)tree.vartype).getAnnotations().stream().anyMatch(anno -> Jailbreak.class.getTypeName().equals(anno.attribute.type.toString()))) {
            tree.type = ((JCTree.JCAnnotatedType)tree.vartype).underlyingType.type;
            tree.sym.type = this._tp.getSymtab().objectType;
        }
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        super.visitTypeCast(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            this.eraseCompilerGeneratedCast(tree);
            return;
        }
        if (TypesUtil.isStructuralInterface(this._tp.getTypes(), tree.type.tsym)) {
            Type objectType = this._tp.getSymtab().objectType;
            tree.expr = this.makeCast(tree.getExpression(), objectType);
            tree.type = objectType;
        } else {
            JCTree.JCAnnotatedType annoType;
            JCTree castType = tree.clazz;
            if (castType instanceof JCTree.JCAnnotatedType && (annoType = (JCTree.JCAnnotatedType)castType).getAnnotations().stream().anyMatch(anno -> Jailbreak.class.getTypeName().equals(anno.attribute.type.toString()))) {
                tree.clazz.type = tree.type = tree.expr.type;
                annoType.underlyingType.type = tree.type;
                if (annoType.underlyingType instanceof JCTree.JCFieldAccess) {
                    ((JCTree.JCFieldAccess)annoType.underlyingType).sym.type = tree.type;
                }
            }
        }
        this.result = tree;
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        super.visitLiteral(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        this.result = tree.typetag.getKindLiteral() == Tree.Kind.STRING_LITERAL ? this.replaceStringLiteral(tree) : tree;
    }

    private JCTree replaceStringLiteral(JCTree.JCLiteral tree) {
        HostKind hostKind;
        String literal = (String)tree.getValue();
        if (!literal.trim().startsWith("[") || !literal.contains("/]")) {
            return tree;
        }
        if (this._tp.getParent(tree) instanceof JCTree.JCBinary) {
            return tree;
        }
        JCTree.JCClassDecl enclosingClass = this.getEnclosingClass(tree);
        CharSequence source = ParserFactoryFiles.getSource(enclosingClass.sym.sourcefile);
        CharSequence chars = source.subSequence(tree.pos().getStartPosition(), tree.pos().getEndPosition(((JCTree.JCCompilationUnit)this._tp.getCompilationUnit()).endPositions));
        HostKind hostKind2 = hostKind = chars.length() > 3 && chars.charAt(1) == '\"' ? HostKind.TEXT_BLOCK_LITERAL : HostKind.DOUBLE_QUOTE_LITERAL;
        if (ManAttr.checkConcatenation(tree, chars, hostKind, null)) {
            return tree;
        }
        FragmentProcessor.Fragment fragment = FragmentProcessor.instance().parseFragment(tree.pos().getStartPosition(), chars.toString(), hostKind);
        if (fragment != null && this.isHandledFileExtension(fragment.getExt())) {
            String fragClass = enclosingClass.sym.packge().toString() + '.' + fragment.getName();
            Symbol.ClassSymbol fragSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), fragClass);
            for (Attribute.Compound annotation : fragSym.getAnnotationMirrors()) {
                if (!annotation.type.toString().equals(FragmentValue.class.getName())) continue;
                return this.replaceStringLiteral(fragSym, tree, annotation);
            }
        }
        return tree;
    }

    private boolean isHandledFileExtension(String fileExt) {
        return this._tp.getHost().getSingleModule().getTypeManifolds().stream().filter(tm -> tm.getContributorKind() != ContributorKind.Supplemental).anyMatch(tm -> tm.handlesFileExtension(fileExt.toLowerCase()));
    }

    private JCTree replaceStringLiteral(Symbol.ClassSymbol fragSym, JCTree.JCLiteral tree, Attribute.Compound attribute) {
        if (attribute == null) {
            return tree;
        }
        String methodName = null;
        String type = null;
        for (com.sun.tools.javac.util.Pair<Symbol.MethodSymbol, Attribute> pair : attribute.values) {
            javax.lang.model.element.Name argName = ((Symbol.MethodSymbol)pair.fst).getSimpleName();
            if (((Name)argName).toString().equals("methodName")) {
                methodName = (String)((Attribute)pair.snd).getValue();
                continue;
            }
            if (!((Name)argName).toString().equals("type")) continue;
            type = (String)((Attribute)pair.snd).getValue();
        }
        if (type != null) {
            return this.replaceStringLiteral(fragSym, tree, methodName, type);
        }
        return tree;
    }

    private JCTree.JCExpression replaceStringLiteral(Symbol.ClassSymbol fragSym, JCTree tree, String methodName, String type) {
        TreeMaker make = this._tp.getTreeMaker();
        Names names = Names.instance(this._tp.getContext());
        Symbol.MethodSymbol fragmentValueMethod = this.resolveMethod(tree.pos(), names.fromString(methodName), fragSym.type, List.nil());
        JCTree.JCMethodInvocation fragmentValueCall = make.Apply(List.nil(), ExtensionTransformer.memberAccess(make, this._tp.getElementUtil(), fragSym.getQualifiedName() + "." + methodName), List.nil());
        fragmentValueCall.type = fragmentValueMethod.getReturnType();
        fragmentValueCall.setPos(tree.pos);
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)fragmentValueCall.getMethodSelect();
        newMethodSelect.sym = fragmentValueMethod;
        newMethodSelect.type = fragmentValueMethod.type;
        this.assignTypes(newMethodSelect.selected, fragSym);
        return fragmentValueCall;
    }

    private void eraseCompilerGeneratedCast(JCTree.JCTypeCast tree) {
        if (TypesUtil.isStructuralInterface(this._tp.getTypes(), tree.type.tsym) && !this.isConstructProxyCall(tree.getExpression())) {
            tree.type = this.getObjectClass().type;
            TreeMaker make = this._tp.getTreeMaker();
            tree.clazz = make.Type(this.getObjectClass().type);
        }
    }

    private boolean isConstructProxyCall(JCTree.JCExpression expression) {
        if (expression instanceof JCTree.JCMethodInvocation) {
            JCTree.JCExpression meth = ((JCTree.JCMethodInvocation)expression).meth;
            return meth instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)meth).getIdentifier().toString().equals("constructProxy");
        }
        return expression instanceof JCTree.JCTypeCast && this.isConstructProxyCall(((JCTree.JCTypeCast)expression).getExpression());
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        super.visitApply(tree);
        this.eraseGenericStructuralVarargs(tree);
        if (this._tp.isGenerate() && !this.isStructuralIteratorCall(tree)) {
            return;
        }
        boolean[] isSmartStatic = new boolean[]{false};
        InterceptType[] interceptType = new InterceptType[]{null};
        Symbol.MethodSymbol method = this.findExtMethod(tree, isSmartStatic, interceptType);
        this.result = method != null ? this.replaceExtCall(tree, method, isSmartStatic[0], interceptType[0]) : (this.isStructuralMethod(tree) ? this.replaceStructuralCall(tree) : (ExtensionTransformer.isJailbreakReceiver(tree) ? this.replaceWithReflection(tree) : tree));
    }

    private boolean isStructuralIteratorCall(JCTree.JCMethodInvocation tree) {
        return tree.meth instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree.meth).sym.name.toString().equals("iterator") && this.isStructuralMethod(tree);
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        if (this.isExtensionMethod(tree.sym) || this.isStructuralMethod(tree.sym)) {
            this.visitLambda(MethodRefToLambda.convert(this._tp, tree));
        } else {
            super.visitReference(tree);
        }
    }

    private boolean isStructuralMethod(Symbol sym) {
        if (sym != null && !sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC) && !this.isObjectMethod(sym)) {
            return TypesUtil.isStructuralInterface(this._tp.getTypes(), sym.owner);
        }
        return false;
    }

    private boolean isExtensionMethod(Symbol sym) {
        if (sym instanceof Symbol.MethodSymbol) {
            for (Attribute.Compound annotation : sym.getAnnotationMirrors()) {
                if (!annotation.type.toString().equals(ExtensionMethod.class.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isJailbreakReceiver(JCTree tree) {
        if (tree instanceof JCTree.JCFieldAccess) {
            return ExtensionTransformer.isJailbreakReceiver((JCTree.JCFieldAccess)tree);
        }
        if (tree instanceof JCTree.JCMethodInvocation) {
            JCTree.JCExpression methodSelect = ((JCTree.JCMethodInvocation)tree).getMethodSelect();
            return ExtensionTransformer.isJailbreakReceiver(methodSelect);
        }
        if (tree instanceof JCTree.JCAssign) {
            JCTree.JCExpression lhs = ((JCTree.JCAssign)tree).lhs;
            return ExtensionTransformer.isJailbreakReceiver(lhs);
        }
        if (tree instanceof JCTree.JCAssignOp) {
            JCTree.JCExpression lhs = ((JCTree.JCAssignOp)tree).lhs;
            return ExtensionTransformer.isJailbreakReceiver(lhs);
        }
        if (tree instanceof JCTree.JCUnary) {
            JCTree.JCExpression arg = ((JCTree.JCUnary)tree).arg;
            return ExtensionTransformer.isJailbreakReceiver(arg);
        }
        if (tree instanceof JCTree.JCVariableDecl) {
            JCTree.JCExpression initializer = ((JCTree.JCVariableDecl)tree).init;
            return ExtensionTransformer.isJailbreakReceiver(initializer);
        }
        if (tree instanceof JCTree.JCTypeCast && ((JCTree.JCTypeCast)tree).clazz instanceof JCTree.JCAnnotatedType) {
            JCTree.JCAnnotatedType annotatedType = (JCTree.JCAnnotatedType)((JCTree.JCTypeCast)tree).clazz;
            return annotatedType.getAnnotations().stream().anyMatch(anno -> Jailbreak.class.getTypeName().equals(anno.attribute.type.toString()));
        }
        if (tree instanceof JCTree.JCNewClass) {
            return ExtensionTransformer.isJailbreakReceiver((JCTree.JCNewClass)tree);
        }
        return false;
    }

    public static boolean isJailbreakReceiver(JCTree.JCFieldAccess fieldAccess) {
        Symbol sym = null;
        JCTree.JCExpression selected = fieldAccess.selected;
        if (selected instanceof JCTree.JCIdent) {
            sym = ((JCTree.JCIdent)selected).sym;
        } else {
            if (selected instanceof JCTree.JCParens) {
                return ExtensionTransformer.isJailbreakReceiver(((JCTree.JCParens)selected).expr);
            }
            if (selected instanceof JCTree.JCMethodInvocation) {
                if (((JCTree.JCMethodInvocation)selected).meth instanceof JCTree.JCFieldAccess) {
                    sym = ((JCTree.JCFieldAccess)((JCTree.JCMethodInvocation)selected).meth).sym;
                } else if (((JCTree.JCMethodInvocation)selected).meth instanceof JCTree.JCIdent) {
                    sym = ((JCTree.JCIdent)((JCTree.JCMethodInvocation)selected).meth).sym;
                }
            }
        }
        return ExtensionTransformer.isJailbreakSymbol(sym);
    }

    public static boolean isJailbreakSymbol(Symbol sym) {
        if (sym == null) {
            return false;
        }
        SymbolMetadata metadata = sym.getMetadata();
        if (metadata == null || metadata.isTypesEmpty() && metadata.isEmpty()) {
            return false;
        }
        List<Attribute.TypeCompound> typeAttributes = metadata.getTypeAttributes();
        if (!typeAttributes.isEmpty()) {
            return typeAttributes.stream().anyMatch(attr -> attr.type.toString().equals(Jailbreak.class.getTypeName()));
        }
        List<Attribute.Compound> attributes = metadata.getDeclarationAttributes();
        if (!attributes.isEmpty()) {
            return attributes.stream().anyMatch(attr -> attr.type.toString().equals(Jailbreak.class.getTypeName()));
        }
        return false;
    }

    private static boolean isJailbreakReceiver(JCTree.JCNewClass newExpr) {
        JCTree.JCExpression classExpr = newExpr.clazz;
        if (classExpr instanceof JCTree.JCAnnotatedType) {
            return ((JCTree.JCAnnotatedType)classExpr).annotations.stream().anyMatch(e -> Jailbreak.class.getTypeName().equals(e.attribute.type.toString()));
        }
        return false;
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        super.visitForeachLoop(tree);
        Type iterableType = this._tp.getTypes().erasure(this._tp.getSymtab().iterableType);
        if (TypesUtil.isStructuralInterface(this._tp.getTypes(), iterableType.tsym) && this._tp.getTypes().isAssignable(tree.expr.type.tsym.type, iterableType)) {
            Names names = Names.instance(this._tp.getContext());
            Symbol.ClassSymbol runtimeMethodsClassSym = this.getRtClassSym(RuntimeMethods.class);
            Symbol.MethodSymbol makeIterableMethod = this.resolveMethod(tree.expr.pos(), names.fromString("makeIterable"), runtimeMethodsClassSym.type, List.from(new Type[]{this._tp.getSymtab().iteratorType}));
            TreeMaker make = this._tp.getTreeMaker();
            JavacElements javacElems = this._tp.getElementUtil();
            Symbol.MethodSymbol iteratorMethSym = this.resolveMethod(tree.expr.pos(), names.fromString("iterator"), tree.expr.type, List.nil());
            JCTree.JCFieldAccess iterMethAccess = make.Select(tree.expr, names.fromString("iterator"));
            iterMethAccess.type = this.getIteratorType(names, tree.expr.type);
            iterMethAccess.sym = iteratorMethSym;
            JCTree.JCMethodInvocation iteratorCall = make.Apply(List.nil(), iterMethAccess, List.nil());
            iteratorCall.setPos(tree.expr.pos);
            iteratorCall.type = iterMethAccess.type;
            ((JCTree.JCFieldAccess)iteratorCall.meth).sym = iteratorMethSym;
            iteratorCall = this.maybeReplaceWithExtensionMethod(iteratorCall);
            iteratorCall = this.maybeReplaceWithStructuralCall(iteratorCall);
            JCTree.JCMethodInvocation makeIterableCall = make.Apply(List.nil(), ExtensionTransformer.memberAccess(make, javacElems, RuntimeMethods.class.getTypeName() + ".makeIterable"), List.of(iteratorCall));
            makeIterableCall.setPos(tree.expr.pos);
            makeIterableCall.type = iterableType;
            JCTree.JCFieldAccess methodSelect = (JCTree.JCFieldAccess)makeIterableCall.getMethodSelect();
            methodSelect.sym = makeIterableMethod;
            methodSelect.type = makeIterableMethod.type;
            methodSelect.pos = tree.expr.pos;
            this.assignTypes(methodSelect.selected, runtimeMethodsClassSym);
            methodSelect.selected.pos = tree.expr.pos;
            tree.expr = makeIterableCall;
        }
    }

    private Type getIteratorType(Names names, Type type) {
        Iterable<Symbol> matches = IDynamicJdk.instance().getMembersByName((Symbol.ClassSymbol)type.tsym, names.fromString("iterator"));
        for (Symbol s : matches) {
            if (!(s instanceof Symbol.MethodSymbol) || !((Symbol.MethodSymbol)s).params().isEmpty()) continue;
            return this._tp.getTypes().memberType(type, s).getReturnType();
        }
        return this._tp.getTypes().erasure(this._tp.getSymtab().iteratorType);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        super.visitAnnotation(tree);
        if (tree.getAnnotationType().type == null || !Self.class.getTypeName().equals(tree.getAnnotationType().type.tsym.toString())) {
            return;
        }
        if (!this.isSelfInMethodDeclOrFieldDecl(tree, tree)) {
            this._tp.report(tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_SELF_NOT_ALLOWED_HERE.get(new Object[0]));
        } else {
            this.verifySelfOnThis(tree, tree);
        }
    }

    private void verifySelfOnThis(JCTree annotated, JCTree.JCAnnotation selfAnno) {
        String fqn;
        if (annotated instanceof JCTree.JCAnnotatedType) {
            fqn = ((JCTree.JCAnnotatedType)annotated).getUnderlyingType().type.tsym.getQualifiedName().toString();
        } else if (annotated instanceof JCTree.JCMethodDecl) {
            fqn = ((JCTree.JCMethodDecl)annotated).getReturnType().type.tsym.getQualifiedName().toString();
        } else {
            return;
        }
        try {
            JCTree.JCClassDecl enclosingClass = this._tp.getClassDecl(annotated);
            if (!this.isDeclaringClassOrExtension(annotated, fqn, enclosingClass) && !fqn.equals("Array")) {
                this._tp.report(selfAnno, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_SELF_NOT_ON_CORRECT_TYPE.get(fqn, enclosingClass.sym.getQualifiedName()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isDeclaringClassOrExtension(JCTree annotated, String fqn, JCTree.JCClassDecl enclosingClass) {
        if (enclosingClass.sym.getQualifiedName().toString().equals(fqn) || this._tp.getTypes().isAssignable((Type)IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), fqn).asType(), enclosingClass.sym.type)) {
            return true;
        }
        return this.isOnExtensionMethod(annotated, fqn, enclosingClass);
    }

    private boolean isOnExtensionMethod(JCTree annotated, String fqn, JCTree.JCClassDecl enclosingClass) {
        JCTree.JCMethodDecl declMethod;
        String extendedClassName;
        if (this.isExtensionClass(enclosingClass) && (extendedClassName = this.getExtendedClassName()) != null && extendedClassName.equals(fqn) && (declMethod = this.findDeclMethod(annotated)) != null) {
            java.util.List parameters = declMethod.getParameters();
            for (JCTree.JCVariableDecl param : parameters) {
                if (!this.hasAnnotation((List<JCTree.JCAnnotation>)param.getModifiers().getAnnotations(), This.class)) continue;
                return true;
            }
        }
        return false;
    }

    private JCTree.JCMethodDecl findDeclMethod(Tree annotated) {
        if (annotated == null) {
            return null;
        }
        if (annotated instanceof JCTree.JCMethodDecl) {
            return (JCTree.JCMethodDecl)annotated;
        }
        return this.findDeclMethod(this._tp.getParent(annotated));
    }

    private boolean isSelfInMethodDeclOrFieldDecl(Tree tree, JCTree.JCAnnotation anno) {
        Tree container;
        if (tree == null) {
            return false;
        }
        Tree parent = this._tp.getParent(tree);
        if (parent instanceof JCTree.JCMethodDecl) {
            return true;
        }
        if (parent instanceof JCTree.JCVariableDecl && (container = this._tp.getParent(parent)) instanceof JCTree.JCClassDecl) {
            return true;
        }
        return this.isSelfInMethodDeclOrFieldDecl(parent, anno);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        super.visitClassDef(tree);
        this.verifyExtensionInterfaces(tree);
        this.checkExtensionClassError(tree);
        this.precompileClasses(tree);
        this.compileGeneratedProxyFactoryClasses(tree);
        this.incrementalCompileClasses(tree);
    }

    private void precompileClasses(JCTree.JCClassDecl tree) {
        HashMap<String, Set<String>> typeNames = new HashMap<String, Set<String>>();
        for (JCTree.JCAnnotation anno : tree.getModifiers().getAnnotations()) {
            if (!anno.getAnnotationType().type.toString().equals(Precompile.class.getCanonicalName())) continue;
            this.getTypesToCompile(anno, typeNames);
        }
        if (!typeNames.isEmpty()) {
            this.precompile(typeNames);
        }
    }

    private void getTypesToCompile(JCTree.JCAnnotation precompileAnno, Map<String, Set<String>> typeNames) {
        Attribute.Compound attribute = precompileAnno.attribute;
        if (attribute == null) {
            return;
        }
        String typeManifoldClassName = null;
        String regex = ".*";
        String ext = "*";
        for (com.sun.tools.javac.util.Pair<Symbol.MethodSymbol, Attribute> pair : attribute.values) {
            javax.lang.model.element.Name argName = ((Symbol.MethodSymbol)pair.fst).getSimpleName();
            switch (((Name)argName).toString()) {
                case "typeManifold": {
                    typeManifoldClassName = ((Attribute)pair.snd).getValue().toString();
                    break;
                }
                case "fileExtension": {
                    ext = ((Attribute)pair.snd).getValue().toString();
                    break;
                }
                case "typeNames": {
                    regex = ((Attribute)pair.snd).getValue().toString();
                }
            }
        }
        this.addToPrecompile(typeNames, typeManifoldClassName, ext, regex);
    }

    private void addToPrecompile(Map<String, Set<String>> typeNames, String typeManifoldClassName, String ext, String regex) {
        if (typeManifoldClassName != null) {
            Set regexes = typeNames.computeIfAbsent(typeManifoldClassName, tm -> new HashSet());
            regexes.add(regex);
        } else {
            boolean all = "*".equals(ext);
            this._tp.getHost().getSingleModule().getTypeManifolds().stream().filter(tm -> tm.getContributorKind() != ContributorKind.Supplemental).forEach(tm -> {
                if (all || tm.handlesFileExtension(ext)) {
                    String classname = tm.getClass().getTypeName();
                    Set regexes = typeNames.computeIfAbsent(classname, e -> new HashSet());
                    regexes.add(regex);
                }
            });
        }
    }

    private void precompile(Map<String, Set<String>> typeNames) {
        block0: for (ITypeManifold tm : this._tp.getHost().getSingleModule().getTypeManifolds()) {
            for (Map.Entry<String, Set<String>> entry : typeNames.entrySet()) {
                String typeManifoldClassName = entry.getKey();
                if (!tm.getClass().getName().equals(typeManifoldClassName)) continue;
                Collection<String> namesToPrecompile = this.computeNamesToPrecompile(tm.getAllTypeNames(), entry.getValue());
                for (String fqn : namesToPrecompile) {
                    IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), fqn);
                }
                continue block0;
            }
        }
    }

    private Collection<String> computeNamesToPrecompile(Collection<String> allTypeNames, Set<String> regexes) {
        HashSet<String> matchingTypes = new HashSet<String>();
        for (String fqn : allTypeNames) {
            if (!regexes.stream().anyMatch(fqn::matches)) continue;
            matchingTypes.add(fqn);
        }
        return matchingTypes;
    }

    private void compileGeneratedProxyFactoryClasses(JCTree.JCClassDecl tree) {
        if (this.isExtensionClass(tree)) {
            StaticCompiler.instance().surfaceGeneratedProxyFactoryClasses(this._tp.getContext(), this._tp.getCompilationUnit());
        }
    }

    private void incrementalCompileClasses(JCTree.JCClassDecl tree) {
        if (this._tp.isGenerate()) {
            return;
        }
        this.mapResourceFileToTargetClassFiles(tree);
        this.incrementalCompile(tree);
    }

    private Set<Object> findDrivers(JCTree.JCClassDecl tree) {
        if (this.isIncremental()) {
            HashSet<Object> drivers = new HashSet<Object>();
            for (JCTree.JCAnnotation anno : tree.getModifiers().getAnnotations()) {
                if (!anno.getAnnotationType().type.toString().equals(IncrementalCompile.class.getCanonicalName())) continue;
                this.getIncrementalCompileDrivers(anno, drivers);
            }
            this._tp.addDrivers(drivers);
        }
        return this._tp.getDrivers();
    }

    private boolean isIncremental() {
        JavacPlugin javacPlugin = JavacPlugin.instance();
        return javacPlugin != null && javacPlugin.isIncremental();
    }

    private void getIncrementalCompileDrivers(JCTree.JCAnnotation anno, Set<Object> drivers) {
        Attribute.Compound attribute = anno.attribute;
        if (attribute == null) {
            return;
        }
        String fqnDriver = null;
        Integer driverId = null;
        for (com.sun.tools.javac.util.Pair<Symbol.MethodSymbol, Attribute> pair : attribute.values) {
            javax.lang.model.element.Name argName = ((Symbol.MethodSymbol)pair.fst).getSimpleName();
            if (((Name)argName).toString().equals("driverInstance")) {
                driverId = (int)((Integer)((Attribute)pair.snd).getValue());
                continue;
            }
            if (!((Name)argName).toString().equals("driverClass")) continue;
            fqnDriver = (String)((Attribute)pair.snd).getValue();
        }
        if (driverId != null) {
            Object driver = ReflectUtil.method(fqnDriver, "getInstance", Integer.TYPE).invokeStatic(driverId);
            drivers.add(driver);
        }
    }

    private void incrementalCompile(JCTree.JCClassDecl tree) {
        Set<Object> drivers = this.findDrivers(tree);
        for (Object driver : drivers) {
            JavacPlugin.instance().setIncremental();
            Collection changedFiles = (Collection)ReflectUtil.method(driver, "getChangedFiles", new Class[0]).invoke(new Object[0]);
            if (changedFiles == null || changedFiles.isEmpty()) continue;
            IManifoldHost host = this._tp.getHost();
            Set changes = changedFiles.stream().map(f -> host.getFileSystem().getIFile((File)f)).collect(Collectors.toSet());
            for (ITypeManifold tm : host.getSingleModule().getTypeManifolds()) {
                for (IFile file : changes) {
                    Set types = Arrays.stream(tm.getTypesForFile(file)).collect(Collectors.toSet());
                    if (types.size() <= 0) continue;
                    Map<File, Set<String>> typesToFile = this.getTypesToFile();
                    if (typesToFile != null) {
                        typesToFile.put(file.toJavaFile(), types);
                    }
                    for (String fqn : types) {
                        Symbol.ClassSymbol classSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), fqn);
                        assert (classSym != null);
                        changedFiles.remove(file.toJavaFile());
                    }
                }
            }
        }
    }

    private void mapResourceFileToTargetClassFiles(JCTree.JCClassDecl tree) {
        if (tree.sym == null) {
            return;
        }
        Name qualifiedName = tree.sym.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        JavaFileObject sourcefile = tree.sym.sourcefile;
        if (!(sourcefile instanceof GeneratedJavaStubFileObject)) {
            return;
        }
        HashMap<File, Set<String>> typesCompiledByFile = new HashMap<File, Set<String>>();
        Set<IFile> resourceFiles = ((GeneratedJavaStubFileObject)sourcefile).getResourceFiles();
        for (IFile ifile : resourceFiles) {
            File file;
            try {
                while (ifile instanceof IFileFragment) {
                    ifile = ((IFileFragment)ifile).getEnclosingFile();
                }
                file = ifile.toJavaFile();
            }
            catch (Exception e) {
                continue;
            }
            ConcurrentHashSet types = (ConcurrentHashSet)typesCompiledByFile.get(file);
            if (types == null) {
                types = new ConcurrentHashSet();
                typesCompiledByFile.put(file, types);
            }
            StringBuilder sb = new StringBuilder();
            this.make$name(tree.sym, sb);
            types.add(sb.toString());
        }
        this.mapResourceFileToTargetClassFiles(typesCompiledByFile);
    }

    private void make$name(Symbol.ClassSymbol sym, StringBuilder sb) {
        Element enclosingElement = sym.getEnclosingElement();
        if (enclosingElement instanceof Symbol.ClassSymbol) {
            this.make$name((Symbol.ClassSymbol)enclosingElement, sb);
            sb.append('$').append(sym.getSimpleName());
        } else {
            sb.append(sym.getQualifiedName().toString());
        }
    }

    private void mapResourceFileToTargetClassFiles(Map<File, Set<String>> typesCompiledByFile) {
        if (typesCompiledByFile.isEmpty()) {
            return;
        }
        Map<File, Set<String>> typesToFile = this.getTypesToFile();
        if (typesToFile != null) {
            typesCompiledByFile.forEach((file, types) -> {
                Set existingTypes = (Set)typesToFile.get(file);
                if (existingTypes != null) {
                    existingTypes.addAll(types);
                } else {
                    typesToFile.put((File)file, (Set<String>)types);
                }
            });
        }
    }

    private Map<File, Set<String>> getTypesToFile() {
        Class<?> type = ReflectUtil.type("manifold.ij.jps.IjChangedResourceFiles");
        if (type == null) {
            return null;
        }
        return (Map)ReflectUtil.method(type, "getTypesToFile", new Class[0]).invokeStatic(new Object[0]);
    }

    private void verifyExtensionInterfaces(JCTree.JCClassDecl tree) {
        if (!this.hasAnnotation((List<JCTree.JCAnnotation>)tree.getModifiers().getAnnotations(), Extension.class)) {
            return;
        }
        block0: for (JCTree.JCExpression iface : tree.getImplementsClause()) {
            Symbol.TypeSymbol ifaceSym = iface.type.tsym;
            if (ifaceSym == this._tp.getSymtab().objectType.tsym) continue;
            for (Attribute.Compound anno : ifaceSym.getAnnotationMirrors()) {
                if (!anno.type.toString().equals(Structural.class.getName())) continue;
                continue block0;
            }
            this._tp.report(iface, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_ONLY_STRUCTURAL_INTERFACE_ALLOWED_HERE.get(iface.toString()));
        }
    }

    private boolean shouldProcessForGeneration() {
        return this._bridgeMethod;
    }

    private boolean shouldProcessForLambdaGeneration() {
        return this._lambdaMethod;
    }

    private boolean isBridgeMethod(JCTree.JCMethodDecl tree) {
        long modifiers = tree.getModifiers().flags;
        return (0x80000000L & modifiers) != 0L;
    }

    private boolean isLambdaMethod(JCTree.JCMethodDecl tree) {
        long modifiers = tree.getModifiers().flags;
        return (0x1000L & modifiers) != 0L;
    }

    private Type eraseStructureType(Type type) {
        return (Type)new StructuralTypeEraser(this).visit(type);
    }

    private boolean isReceiver(JCTree tree) {
        Tree parent = this._tp.getParent(tree);
        if (parent instanceof JCTree.JCFieldAccess) {
            return ((JCTree.JCFieldAccess)parent).getExpression() == tree;
        }
        return false;
    }

    Symbol.ClassSymbol getObjectClass() {
        Symtab symbols = Symtab.instance(this._tp.getContext());
        return (Symbol.ClassSymbol)symbols.objectType.tsym;
    }

    private void eraseGenericStructuralVarargs(JCTree.JCMethodInvocation tree) {
        if (tree.varargsElement instanceof Type.ClassType && TypesUtil.isStructuralInterface(this._tp.getTypes(), tree.varargsElement.tsym)) {
            tree.varargsElement = this._tp.getSymtab().objectType;
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        if (this.isBridgeMethod(tree)) {
            this._bridgeMethod = true;
        }
        if (this.isLambdaMethod(tree)) {
            this._lambdaMethod = true;
        }
        try {
            if (!this._tp.isGenerate() && !this._bridgeMethod) {
                this.unproxyStructuralArgsIfDefaultMethod(tree);
            }
            super.visitMethodDef(tree);
            if (this._lambdaMethod) {
                this.updateMethodSymbolParamTypes(tree);
            }
        }
        finally {
            this._bridgeMethod = false;
            this._lambdaMethod = false;
        }
        if (this._tp.isGenerate()) {
            return;
        }
        if (tree.sym.owner.isAnonymous()) {
            JCTree.JCClassDecl anonymousClassDef = (JCTree.JCClassDecl)this._tp.getTreeUtil().getTree(tree.sym.owner);
            this._tp.preserveInnerClassForGenerationPhase(anonymousClassDef);
        }
        this.verifyExtensionMethod(tree);
        this.result = tree;
    }

    private void updateMethodSymbolParamTypes(JCTree.JCMethodDecl tree) {
        if (!tree.getName().toString().contains("lambda")) {
            return;
        }
        List<JCTree.JCVariableDecl> params = tree.params;
        List<Symbol.VarSymbol> newSyms = List.nil();
        List<Type> newTypes = List.nil();
        for (int i = 0; i < params.size(); ++i) {
            JCTree.JCVariableDecl param = params.get(i);
            newSyms = newSyms.append(param.sym);
            newTypes = newTypes.append(param.type);
        }
        tree.sym.params = newSyms;
        ((Type.MethodType)tree.sym.type).argtypes = newTypes;
    }

    private void unproxyStructuralArgsIfDefaultMethod(JCTree.JCMethodDecl tree) {
        if (tree.sym == null || !tree.sym.isDefault()) {
            return;
        }
        for (JCTree.JCVariableDecl param : tree.getParameters()) {
            if (!TypesUtil.isStructuralInterface(this._tp.getTypes(), param.type.tsym)) continue;
            TreeMaker make = TreeMaker.instance(this._tp.getContext());
            JavacElements javacElems = this._tp.getElementUtil();
            Symtab symbols = this._tp.getSymtab();
            int bodyPos = tree.getBody().pos;
            if (param.type.isPrimitive()) continue;
            JCTree.JCIdent proxiedParam = make.Ident(param.sym);
            proxiedParam.pos = bodyPos;
            Names names = Names.instance(this._tp.getContext());
            Symbol.ClassSymbol runtimeMethodsClassSym = this.getRtClassSym(RuntimeMethods.class);
            Symbol.MethodSymbol unproxyMethod = this.resolveMethod(tree.pos(), names.fromString("unFakeProxy"), runtimeMethodsClassSym.type, List.from(new Type[]{symbols.objectType}));
            JCTree.JCMethodInvocation unproxyCall = make.Apply(List.nil(), ExtensionTransformer.memberAccess(make, javacElems, RuntimeMethods.class.getTypeName() + ".unFakeProxy"), List.of(proxiedParam));
            unproxyCall.setPos(bodyPos);
            unproxyCall.type = symbols.objectType;
            JCTree.JCFieldAccess methodSelect = (JCTree.JCFieldAccess)unproxyCall.getMethodSelect();
            methodSelect.sym = unproxyMethod;
            methodSelect.type = unproxyMethod.type;
            methodSelect.pos = bodyPos;
            this.assignTypes(methodSelect.selected, runtimeMethodsClassSym);
            methodSelect.selected.pos = bodyPos;
            JCTree.JCTypeCast castedUnproxyCall = make.TypeCast(param.type, (JCTree.JCExpression)unproxyCall);
            castedUnproxyCall.pos = bodyPos;
            JCTree.JCIdent lhs = make.Ident(param.sym);
            lhs.pos = bodyPos;
            JCTree.JCAssign unproxy = make.Assign(lhs, castedUnproxyCall);
            unproxy.pos = bodyPos;
            unproxy.type = symbols.objectType;
            JCTree.JCExpressionStatement unproxyStmt = make.Exec(unproxy);
            unproxyStmt.pos = bodyPos;
            unproxyStmt.type = unproxy.type;
            JCTree.JCBlock body = tree.getBody();
            tree.body = make.Block(0L, List.of(unproxyStmt, body));
            tree.body.pos = bodyPos;
        }
    }

    private Symbol.ClassSymbol getRtClassSym(Class cls) {
        Symbol.ClassSymbol sym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), cls.getTypeName());
        if (sym == null) {
            sym = JavacElements.instance(this._tp.getContext()).getTypeElement(cls.getTypeName());
        }
        return sym;
    }

    private void checkExtensionClassError(JCTree.JCClassDecl typeDecl) {
        JavacPlugin javacPlugin = JavacPlugin.instance();
        if (javacPlugin == null) {
            return;
        }
        if (!this.isExtensionClass(typeDecl)) {
            return;
        }
        String extendedFqn = this.getExtendedClassName();
        if (javacPlugin.getJavaInputFiles().stream().anyMatch(pair -> !(pair.getSecond() instanceof GeneratedJavaStubFileObject) && ((String)pair.getFirst()).equals(extendedFqn))) {
            this._tp.report(typeDecl, Diagnostic.Kind.WARNING, ExtIssueMsg.MSG_CANNOT_EXTEND_SOURCE_FILE.get(extendedFqn));
        }
    }

    private void verifyExtensionMethod(JCTree.JCMethodDecl tree) {
        if (!this.isExtensionClass(this._tp.getParent(tree))) {
            return;
        }
        String extendedClassName = this.getExtendedClassName();
        if (extendedClassName == null) {
            return;
        }
        boolean thisAnnoFound = false;
        java.util.List parameters = tree.getParameters();
        for (int i = 0; i < ((List)parameters).size(); ++i) {
            JCTree.JCVariableDecl param = (JCTree.JCVariableDecl)((List)parameters).get(i);
            long methodModifiers = tree.getModifiers().flags;
            boolean This2 = this.hasAnnotation((List<JCTree.JCAnnotation>)param.getModifiers().getAnnotations(), This.class);
            if (This2 || this.hasAnnotation((List<JCTree.JCAnnotation>)param.getModifiers().getAnnotations(), ThisClass.class)) {
                thisAnnoFound = true;
                if (i != 0) {
                    this._tp.report(param, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_THIS_FIRST.get(new Object[0]));
                }
                if (This2 && extendedClassName.equals(Array.class.getTypeName())) {
                    if (param.type.tsym.getQualifiedName().toString().equals(Object.class.getName())) continue;
                    this._tp.report(param, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_EXPECTING_OBJECT_FOR_THIS.get(Object.class.getSimpleName()));
                    continue;
                }
                if (!(!This2 || param.type.tsym instanceof Symbol.ClassSymbol && ((Symbol.ClassSymbol)param.type.tsym).className().equals(extendedClassName))) {
                    Symbol.ClassSymbol extendClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), extendedClassName);
                    if (extendClassSym == null || TypesUtil.isStructuralInterface(this._tp.getTypes(), extendClassSym) || TypeUtil.isAssignableFromErased(this._tp.getContext(), extendClassSym, param.type.tsym) || tree.sym.enclClass() != null && param.type.tsym.isEnclosedBy(extendClassSym)) continue;
                    this._tp.report(param, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_EXPECTING_TYPE_FOR_THIS.get(extendedClassName));
                    continue;
                }
                if (This2 || param.type.tsym instanceof Symbol.ClassSymbol && ((Symbol.ClassSymbol)param.type.tsym).className().equals(Class.class.getTypeName())) continue;
                this._tp.report(param, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_EXPECTING_CLASS_TYPE_FOR_THISCLASS.get(extendedClassName));
                continue;
            }
            if (i != 0 || !Modifier.isStatic((int)methodModifiers) || !Modifier.isPublic((int)methodModifiers) || !param.type.toString().equals(extendedClassName)) continue;
            this._tp.report(param, Diagnostic.Kind.WARNING, ExtIssueMsg.MSG_MAYBE_MISSING_THIS.get(new Object[0]));
        }
        if (thisAnnoFound || this.hasAnnotation((List<JCTree.JCAnnotation>)tree.getModifiers().getAnnotations(), Extension.class)) {
            long methodModifiers = tree.getModifiers().flags;
            if (!Modifier.isStatic((int)methodModifiers)) {
                this._tp.report(tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_MUST_BE_STATIC.get(tree.getName()));
            }
            if (Modifier.isPrivate((int)methodModifiers)) {
                this._tp.report(tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_MUST_NOT_BE_PRIVATE.get(tree.getName()));
            }
        }
    }

    private String getExtendedClassName() {
        String extendedClassName = this._tp.getCompilationUnit().getPackageName().toString();
        int iExt = extendedClassName.indexOf("extensions.");
        if (iExt < 0) {
            return null;
        }
        extendedClassName = extendedClassName.substring(iExt + "extensions".length() + 1);
        return extendedClassName;
    }

    private boolean isExtensionClass(Tree parent) {
        if (parent instanceof JCTree.JCClassDecl) {
            return this.hasAnnotation((List<JCTree.JCAnnotation>)((JCTree.JCClassDecl)parent).getModifiers().getAnnotations(), Extension.class);
        }
        return false;
    }

    public JCTree.JCClassDecl getEnclosingClass(Tree tree) {
        return ExtensionTransformer.getEnclosingClass(tree, child -> this._tp.getParent((Tree)child));
    }

    public static JCTree.JCClassDecl getEnclosingClass(Tree tree, Function<Tree, Tree> parentOf) {
        if (tree == null) {
            return null;
        }
        if (tree instanceof JCTree.JCClassDecl) {
            return (JCTree.JCClassDecl)tree;
        }
        return ExtensionTransformer.getEnclosingClass(parentOf.apply(tree), parentOf);
    }

    private Symbol getEnclosingSymbol(Tree tree, Context ctx) {
        return ExtensionTransformer.getEnclosingSymbol(tree, ctx, child -> this._tp.getParent((Tree)child));
    }

    public static Symbol getEnclosingSymbol(Tree tree, Context ctx, Function<Tree, Tree> parentOf) {
        Tree parent;
        if (tree == null) {
            return null;
        }
        if (tree instanceof JCTree.JCClassDecl) {
            return new Symbol.MethodSymbol(0x100008L, Names.instance((Context)ctx).empty, null, ((JCTree.JCClassDecl)tree).sym);
        }
        if (tree instanceof JCTree.JCMethodDecl) {
            return ((JCTree.JCMethodDecl)tree).sym;
        }
        if (tree instanceof JCTree.JCVariableDecl && (parent = parentOf.apply(tree)) instanceof JCTree.JCClassDecl) {
            return new Symbol.MethodSymbol(((JCTree.JCVariableDecl)tree).mods.flags & 8L | 0x100000L, Names.instance((Context)ctx).empty, null, ((JCTree.JCClassDecl)parent).sym);
        }
        return ExtensionTransformer.getEnclosingSymbol(parentOf.apply(tree), ctx, parentOf);
    }

    private boolean hasAnnotation(List<JCTree.JCAnnotation> annotations, Class<? extends Annotation> annoClass) {
        for (JCTree.JCAnnotation anno : annotations) {
            if (!anno.getAnnotationType().type.toString().equals(annoClass.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private JCTree.JCMethodInvocation replaceStructuralCall(JCTree.JCMethodInvocation theCall) {
        JCTree.JCExpression methodSelect = theCall.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            int pos = theCall.pos;
            Symtab symbols = this._tp.getSymtab();
            Names names = Names.instance(this._tp.getContext());
            Symbol.ClassSymbol reflectMethodClassSym = this.getRtClassSym(RuntimeMethods.class);
            Symbol.MethodSymbol makeInterfaceProxyMethod = this.resolveMethod(theCall.pos(), names.fromString("constructProxy"), reflectMethodClassSym.type, List.from(new Type[]{symbols.objectType, symbols.classType}));
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            TreeMaker make = this._tp.getTreeMaker();
            JavacElements javacElems = this._tp.getElementUtil();
            JCTree.JCExpression thisArg = m.selected;
            ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
            newArgs.add(thisArg);
            JCTree.JCFieldAccess ifaceClassExpr = (JCTree.JCFieldAccess)ExtensionTransformer.memberAccess(make, javacElems, thisArg.type.tsym.getQualifiedName().toString() + ".class");
            ifaceClassExpr.type = symbols.classType;
            ifaceClassExpr.sym = symbols.classType.tsym;
            ifaceClassExpr.pos = pos;
            this.assignTypes(ifaceClassExpr.selected, thisArg.type.tsym);
            ifaceClassExpr.selected.pos = pos;
            newArgs.add(ifaceClassExpr);
            JCTree.JCMethodInvocation makeProxyCall = make.Apply(List.nil(), ExtensionTransformer.memberAccess(make, javacElems, RuntimeMethods.class.getName() + ".constructProxy"), List.from(newArgs));
            makeProxyCall.setPos(pos);
            makeProxyCall.type = thisArg.type;
            JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)makeProxyCall.getMethodSelect();
            newMethodSelect.sym = makeInterfaceProxyMethod;
            newMethodSelect.type = makeInterfaceProxyMethod.type;
            newMethodSelect.pos = pos;
            this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
            newMethodSelect.selected.pos = pos;
            JCTree.JCTypeCast cast = make.TypeCast(thisArg.type, (JCTree.JCExpression)makeProxyCall);
            cast.type = thisArg.type;
            cast.pos = pos;
            ((JCTree.JCFieldAccess)theCall.meth).selected = cast;
            theCall.pos = pos;
            return theCall;
        }
        return null;
    }

    private JCTree.JCTypeCast makeCast(JCTree.JCExpression expression, Type type) {
        TreeMaker make = this._tp.getTreeMaker();
        JCTree.JCTypeCast castCall = make.TypeCast(type, expression);
        castCall.type = type;
        castCall.pos = expression.pos;
        return castCall;
    }

    private JCTree.JCMethodInvocation replaceExtCall(JCTree.JCMethodInvocation tree, Symbol.MethodSymbol method, boolean isSmartStatic, InterceptType interceptType) {
        if (interceptType == InterceptType.NONE) {
            return tree;
        }
        if (interceptType == InterceptType.REFLECTION) {
            TreeMaker make = this._tp.getTreeMaker();
            Names names = Names.instance(this._tp.getContext());
            Types types = Types.instance(this._tp.getContext());
            JavacElements elements = JavacElements.instance(this._tp.getContext());
            Symbol.ClassSymbol reflectUtilClassSymbol = elements.getTypeElement(ReflectUtil.class.getName());
            JCTree.JCIdent reflectUtilIdent = make.Ident(reflectUtilClassSymbol.name);
            reflectUtilIdent.sym = reflectUtilClassSymbol;
            reflectUtilIdent.type = reflectUtilClassSymbol.type;
            JCTree.JCFieldAccess invokeDefaultSelect = make.Select((JCTree.JCExpression)reflectUtilIdent, names.fromString("invokeDefault"));
            Symbol.MethodSymbol invokeDefaultSym = null;
            for (Symbol sym : reflectUtilClassSymbol.getEnclosedElements()) {
                Symbol.MethodSymbol ms;
                if (!(sym instanceof Symbol.MethodSymbol) || !sym.getSimpleName().contentEquals("invokeDefault") || ((List)(ms = (Symbol.MethodSymbol)sym).getParameters()).size() != 5 || !Object.class.getName().equals(((Symbol.VarSymbol)((List)ms.getParameters()).get((int)0)).type.tsym.toString()) || !Class.class.getName().equals(((Symbol.VarSymbol)((List)ms.getParameters()).get((int)1)).type.tsym.toString()) || !String.class.getName().equals(((Symbol.VarSymbol)((List)ms.getParameters()).get((int)2)).type.tsym.toString()) || !"java.lang.Class<?>[]".equals(((Symbol.VarSymbol)((List)ms.getParameters()).get((int)3)).type.toString()) || !"java.lang.Object[]".equals(((Symbol.VarSymbol)((List)ms.getParameters()).get((int)4)).type.toString())) continue;
                invokeDefaultSym = ms;
                break;
            }
            if (invokeDefaultSym == null) {
                throw new IllegalStateException("Cannot resolve method 'invokeDefault' in ReflectUtil");
            }
            invokeDefaultSelect.sym = invokeDefaultSym;
            invokeDefaultSelect.type = invokeDefaultSym.type;
            JCTree.JCFieldAccess meth = (JCTree.JCFieldAccess)tree.meth;
            JCTree.JCIdent receiver = (JCTree.JCIdent)meth.getExpression();
            JCTree.JCExpression receiverType = make.Type(receiver.sym.type.unannotatedType());
            JCTree.JCFieldAccess receiverClassExpr = make.Select(receiverType, names.fromString("class"));
            Type classType = types.erasure((Type)elements.getTypeElement("java.lang.Class").asType());
            receiverClassExpr.type = new Type.ClassType(classType.getEnclosingType(), List.of(receiver.sym.type.unannotatedType()), classType.tsym);
            receiverClassExpr.sym = receiverClassExpr.type.tsym;
            JCTree.JCLiteral methodNameExpr = make.Literal(meth.name.toString());
            List<JCTree.JCExpression> paramTypesList = List.nil();
            for (Type paramType : meth.type.getParameterTypes()) {
                JCTree.JCFieldAccess paramTypeLiteral = make.Select(make.Type(paramType), names.fromString("class"));
                paramTypeLiteral.type = paramTypeLiteral.selected.type;
                paramTypeLiteral.sym = paramTypeLiteral.selected.type.tsym;
                paramTypesList = paramTypesList.append(paramTypeLiteral);
            }
            Symbol.ClassSymbol classSymbol = elements.getTypeElement("java.lang.Class");
            JCTree.JCIdent classIdent = make.Ident(names.fromString("Class"));
            classIdent.sym = classSymbol;
            classIdent.type = classSymbol.type;
            JCTree.JCNewArray parameterArray = make.NewArray(classIdent, List.nil(), paramTypesList);
            parameterArray.type = types.erasure(types.makeArrayType(classSymbol.type));
            Symbol.ClassSymbol objectSymbol = elements.getTypeElement("java.lang.Object");
            JCTree.JCIdent objectIdent = make.Ident(names.fromString("Object"));
            objectIdent.sym = objectSymbol;
            objectIdent.type = objectSymbol.type;
            JCTree.JCNewArray argumentArray = make.NewArray(objectIdent, List.nil(), tree.args);
            argumentArray.type = types.makeArrayType(objectSymbol.type);
            List<JCTree.JCExpression> args = List.of(receiver, receiverClassExpr, methodNameExpr, new JCTree.JCExpression[]{parameterArray, argumentArray});
            JCTree.JCMethodInvocation methodInvocation = make.Apply(List.nil(), invokeDefaultSelect, args);
            methodInvocation.type = objectSymbol.type;
            return methodInvocation;
        }
        Symtab symTab = this._tp.getSymtab();
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            boolean isPublic;
            ArrayList<JCTree.JCExpression> newArgs;
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            boolean isStatic = m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
            TreeMaker make = this._tp.getTreeMaker();
            JavacElements javacElems = this._tp.getElementUtil();
            JCTree.JCExpression thisArg = m.selected;
            String extensionFqn = ((Symbol)method.getEnclosingElement()).asType().tsym.toString();
            m.selected = ExtensionTransformer.memberAccess(make, javacElems, extensionFqn);
            BasicJavacTask javacTask = (BasicJavacTask)this._tp.getJavacTask();
            Symbol.ClassSymbol extensionClassSym = ClassSymbols.instance(this._sp.getModule()).getClassSymbol(javacTask, this._tp, extensionFqn).getFirst();
            this.assignTypes(m.selected, extensionClassSym);
            m.selected.pos = tree.pos;
            m.sym = method;
            m.type = method.type;
            if (!isStatic) {
                newArgs = new ArrayList<JCTree.JCExpression>(tree.args);
                newArgs.add(0, thisArg);
                tree.args = List.from(newArgs);
            } else if (isSmartStatic) {
                newArgs = new ArrayList<JCTree.JCExpression>(tree.args);
                JCTree.JCFieldAccess classExpr = (JCTree.JCFieldAccess)ExtensionTransformer.memberAccess(make, javacElems, thisArg.type.tsym.getQualifiedName().toString() + ".class");
                classExpr.type = symTab.classType;
                classExpr.sym = symTab.classType.tsym;
                classExpr.pos = tree.pos;
                this.assignTypes(classExpr.selected, thisArg.type.tsym);
                classExpr.selected.pos = tree.pos;
                newArgs.add(0, classExpr);
                tree.args = List.from(newArgs);
            }
            boolean bl = isPublic = (method.flags_field & 7L) == 1L;
            if (!isPublic) {
                tree = this.replaceWithReflection(tree);
            }
            return tree;
        }
        if (methodSelect instanceof JCTree.JCIdent) {
            boolean isPublic;
            JCTree.JCIdent m = (JCTree.JCIdent)methodSelect;
            boolean isStatic = m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
            TreeMaker make = this._tp.getTreeMaker();
            JavacElements javacElems = this._tp.getElementUtil();
            String extensionFqn = ((Symbol)method.getEnclosingElement()).asType().tsym.toString();
            ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>(tree.args);
            if (!isStatic) {
                JCTree.JCExpression thisArg = make.This(this._tp.getClassDecl((Tree)tree).type);
                newArgs.add(0, thisArg);
            } else if (isSmartStatic) {
                JCTree.JCClassDecl classDecl = this._tp.getClassDecl(tree);
                JCTree.JCFieldAccess classExpr = (JCTree.JCFieldAccess)ExtensionTransformer.memberAccess(make, javacElems, classDecl.getSimpleName().toString() + ".class");
                classExpr.type = symTab.classType;
                classExpr.sym = symTab.classType.tsym;
                classExpr.pos = tree.pos;
                this.assignTypes(classExpr.selected, classDecl.type.tsym);
                classExpr.selected.pos = tree.pos;
                newArgs.add(0, classExpr);
            }
            JCTree.JCMethodInvocation extCall = make.Apply(List.nil(), ExtensionTransformer.memberAccess(make, javacElems, extensionFqn), List.from(newArgs));
            extCall.setPos(tree.pos);
            extCall.type = tree.type;
            extCall.varargsElement = tree.varargsElement;
            JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)extCall.getMethodSelect();
            newMethodSelect.sym = method;
            newMethodSelect.type = method.type;
            newMethodSelect.pos = tree.pos;
            this.assignTypes(newMethodSelect.selected, method.owner);
            boolean bl = isPublic = (method.flags_field & 7L) == 1L;
            if (!isPublic) {
                extCall = this.replaceWithReflection(extCall);
            }
            return extCall;
        }
        return tree;
    }

    private JCTree.JCMethodInvocation replaceWithReflection(JCTree.JCMethodInvocation tree) {
        Type type = tree.getMethodSelect().type;
        if (type instanceof Type.ErrorType) {
            return tree;
        }
        TreeMaker make = this._tp.getTreeMaker();
        JavacElements javacElems = this._tp.getElementUtil();
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            boolean isStatic = m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
            if (!(m.sym instanceof Symbol.MethodSymbol)) {
                return tree;
            }
            Type returnType = ((Symbol.MethodSymbol)m.sym).getReturnType();
            Symbol.MethodSymbol reflectMethodSym = this.findReflectUtilMethod(tree, returnType, isStatic);
            java.util.List parameters = ((Symbol.MethodSymbol)m.sym).getParameters();
            ArrayList<JCTree.JCExpression> paramTypes = new ArrayList<JCTree.JCExpression>();
            for (Symbol.VarSymbol param : parameters) {
                JCTree.JCExpression classExpr = this.makeClassExpr(tree, this._tp.getTypes().erasure(param.type));
                paramTypes.add(classExpr);
            }
            Symtab symTab = this._tp.getSymtab();
            JCTree.JCNewArray paramTypesArray = make.NewArray(make.Type(symTab.classType), List.nil(), List.from(paramTypes));
            paramTypesArray.type = new Type.ArrayType(symTab.classType, symTab.arrayClass);
            JCTree.JCNewArray argsArray = make.NewArray(make.Type(symTab.objectType), List.nil(), (List<JCTree.JCExpression>)tree.getArguments());
            argsArray.type = new Type.ArrayType(symTab.objectType, symTab.arrayClass);
            ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
            newArgs.add(isStatic ? this.makeClassExpr(tree, m.selected.type) : m.selected);
            newArgs.add(make.Literal(m.sym.flatName().toString()));
            newArgs.add(paramTypesArray);
            newArgs.add(argsArray);
            Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
            JCTree.JCMethodInvocation reflectCall = make.Apply(List.nil(), ExtensionTransformer.memberAccess(make, javacElems, ReflectionRuntimeMethods.class.getName() + "." + reflectMethodSym.flatName().toString()), List.from(newArgs));
            reflectCall.setPos(tree.pos);
            reflectCall.type = returnType;
            reflectCall.pos = tree.pos;
            JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)reflectCall.getMethodSelect();
            newMethodSelect.sym = reflectMethodSym;
            newMethodSelect.type = reflectMethodSym.type;
            this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
            newMethodSelect.pos = tree.pos;
            return reflectCall;
        }
        return tree;
    }

    private JCTree replaceWithReflection(JCTree.JCFieldAccess tree) {
        Tree.Kind kind;
        TreeMaker make = this._tp.getTreeMaker();
        JavacElements javacElems = this._tp.getElementUtil();
        boolean isStatic = tree.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
        if (tree.sym instanceof Symbol.MethodSymbol) {
            return tree;
        }
        Tree parent = this._tp.getParent(tree);
        if (parent instanceof JCTree.JCAssign && ((JCTree.JCAssign)parent).lhs == tree || parent instanceof JCTree.JCAssignOp && ((JCTree.JCAssignOp)parent).lhs == tree) {
            return tree;
        }
        if (parent instanceof JCTree.JCUnary && ((JCTree.JCUnary)parent).arg == tree && (kind = parent.getKind()) != Tree.Kind.UNARY_MINUS && kind != Tree.Kind.UNARY_PLUS && kind != Tree.Kind.LOGICAL_COMPLEMENT && kind != Tree.Kind.BITWISE_COMPLEMENT) {
            this._tp.report((JCTree)parent, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_INCREMENT_OP_NOT_ALLOWED_REFLECTION.get(new Object[0]));
            return tree;
        }
        Type type = tree.sym.type;
        if (type instanceof Type.ErrorType) {
            return tree;
        }
        Symbol.MethodSymbol reflectMethodSym = this.findFieldAccessReflectUtilMethod(tree, type, isStatic, false);
        ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
        newArgs.add(isStatic ? this.makeClassExpr(tree, tree.selected.type) : tree.selected);
        newArgs.add(make.Literal(tree.sym.flatName().toString()));
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        JCTree.JCMethodInvocation reflectCall = make.Apply(List.nil(), ExtensionTransformer.memberAccess(make, javacElems, ReflectionRuntimeMethods.class.getName() + "." + reflectMethodSym.flatName().toString()), List.from(newArgs));
        reflectCall.setPos(tree.pos);
        reflectCall.type = type;
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)reflectCall.getMethodSelect();
        newMethodSelect.sym = reflectMethodSym;
        newMethodSelect.type = reflectMethodSym.type;
        this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
        return reflectCall;
    }

    private JCTree replaceWithReflection(JCTree.JCAssign assignTree) {
        JCTree.JCFieldAccess tree = (JCTree.JCFieldAccess)assignTree.lhs;
        TreeMaker make = this._tp.getTreeMaker();
        JavacElements javacElems = this._tp.getElementUtil();
        boolean isStatic = tree.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
        if (tree.sym instanceof Symbol.MethodSymbol) {
            return assignTree;
        }
        Type type = tree.sym.type;
        Symbol.MethodSymbol reflectMethodSym = this.findFieldAccessReflectUtilMethod(tree, type, isStatic, true);
        ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
        newArgs.add(isStatic ? this.makeClassExpr(tree, tree.selected.type) : tree.selected);
        newArgs.add(make.Literal(tree.sym.flatName().toString()));
        newArgs.add(assignTree.rhs);
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        JCTree.JCMethodInvocation reflectCall = make.Apply(List.nil(), ExtensionTransformer.memberAccess(make, javacElems, ReflectionRuntimeMethods.class.getName() + "." + reflectMethodSym.flatName().toString()), List.from(newArgs));
        reflectCall.setPos(tree.pos);
        reflectCall.type = type;
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)reflectCall.getMethodSelect();
        newMethodSelect.sym = reflectMethodSym;
        newMethodSelect.type = reflectMethodSym.type;
        this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
        return reflectCall;
    }

    private JCTree replaceWithReflection(JCTree.JCNewClass tree) {
        if (tree.constructor == null) {
            return tree;
        }
        TreeMaker make = this._tp.getTreeMaker();
        JavacElements javacElems = this._tp.getElementUtil();
        Type type = ((JCTree.JCAnnotatedType)tree.clazz).underlyingType.type;
        if (tree.constructor instanceof Symbol.ClassSymbol) {
            return tree;
        }
        java.util.List parameters = ((Symbol.MethodSymbol)tree.constructor).getParameters();
        ArrayList<JCTree.JCExpression> paramTypes = new ArrayList<JCTree.JCExpression>();
        for (Symbol.VarSymbol param : parameters) {
            paramTypes.add(this.makeClassExpr(tree, this._tp.getTypes().erasure(param.type)));
        }
        Symtab symTab = this._tp.getSymtab();
        JCTree.JCNewArray paramTypesArray = make.NewArray(make.Type(symTab.classType), List.nil(), List.from(paramTypes));
        paramTypesArray.type = new Type.ArrayType(symTab.classType, symTab.arrayClass);
        JCTree.JCNewArray argsArray = make.NewArray(make.Type(symTab.objectType), List.nil(), (List<JCTree.JCExpression>)tree.getArguments());
        argsArray.type = new Type.ArrayType(symTab.objectType, symTab.arrayClass);
        ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
        newArgs.add(this.makeClassExpr(tree, type));
        newArgs.add(paramTypesArray);
        newArgs.add(argsArray);
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        Symbol.MethodSymbol reflectMethodSym = this.findReflectUtilConstructor(tree);
        JCTree.JCMethodInvocation reflectCall = make.Apply(List.nil(), ExtensionTransformer.memberAccess(make, javacElems, ReflectionRuntimeMethods.class.getName() + "." + reflectMethodSym.flatName().toString()), List.from(newArgs));
        reflectCall.setPos(tree.pos);
        reflectCall.type = type;
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)reflectCall.getMethodSelect();
        newMethodSelect.sym = reflectMethodSym;
        newMethodSelect.type = reflectMethodSym.type;
        this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
        return reflectCall;
    }

    private JCTree.JCExpression makeClassExpr(JCTree tree, Type type) {
        JCTree.JCExpression classExpr;
        BasicJavacTask javacTask = (BasicJavacTask)this._tp.getJavacTask();
        Types types = Types.instance(javacTask.getContext());
        type = types.erasure(type);
        if (this.isPrimitiveOrPrimitiveArray(type) || JreUtil.isJava8() && type.tsym.getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
            classExpr = this._tp.getTreeMaker().ClassLiteral(type);
            classExpr.pos = tree.pos;
        } else {
            classExpr = this.classForNameCall(type, tree);
        }
        return classExpr;
    }

    private boolean isPrimitiveOrPrimitiveArray(Type type) {
        while (type instanceof Type.ArrayType) {
            type = ((Type.ArrayType)type).getComponentType();
        }
        return type.isPrimitive();
    }

    private JCTree.JCExpression classForNameCall(Type type, JCTree tree) {
        TreeMaker make = this._tp.getTreeMaker();
        JavacElements javacElems = this._tp.getElementUtil();
        JCTree.JCMethodInvocation typeCall = make.Apply(List.nil(), ExtensionTransformer.memberAccess(make, javacElems, ReflectUtil.class.getName() + ".type"), List.of(make.Literal(this.makeLiteralName(type))));
        typeCall.setPos(-1);
        typeCall.type = this._tp.getSymtab().classType;
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)typeCall.getMethodSelect();
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), ReflectUtil.class.getName());
        Symbol.MethodSymbol typeMethodSymbol = this.resolveMethod(tree.pos(), Names.instance(this._tp.getContext()).fromString("type"), reflectMethodClassSym.type, List.of(this._tp.getSymtab().stringType));
        newMethodSelect.sym = typeMethodSymbol;
        newMethodSelect.type = typeMethodSymbol.type;
        newMethodSelect.pos = tree.pos;
        this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
        return typeCall;
    }

    private String makeLiteralName(Type type) {
        StringBuilder sb = new StringBuilder();
        while (type instanceof Type.ArrayType) {
            sb.append("[]");
            type = ((Type.ArrayType)type).getComponentType();
        }
        return type.tsym.flatName() + sb.toString();
    }

    private void assignTypes(JCTree.JCExpression m, Symbol symbol) {
        if (m instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)m;
            fieldAccess.sym = symbol;
            fieldAccess.type = symbol.type;
            this.assignTypes(fieldAccess.selected, symbol.owner);
        } else if (m instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)m;
            ident.sym = symbol;
            ident.type = symbol.type;
        }
    }

    private Symbol.MethodSymbol findExtMethod(JCTree.JCMethodInvocation tree, boolean[] isSmartStatic, InterceptType[] interceptType) {
        Symbol sym = null;
        if (tree.meth instanceof JCTree.JCFieldAccess) {
            sym = ((JCTree.JCFieldAccess)tree.meth).sym;
        } else if (tree.meth instanceof JCTree.JCIdent) {
            sym = ((JCTree.JCIdent)tree.meth).sym;
        }
        if (sym == null) {
            return null;
        }
        if (!(sym.hasAnnotations() || (sym = sym.baseSymbol()) != null && sym.hasAnnotations())) {
            return null;
        }
        for (Attribute.Compound annotation : sym.getAnnotationMirrors()) {
            if (!annotation.type.toString().equals(ExtensionMethod.class.getName())) continue;
            String extensionClass = (String)((Attribute)annotation.values.get((int)0).snd).getValue();
            boolean isStatic = (Boolean)((Attribute)annotation.values.get((int)1).snd).getValue();
            isSmartStatic[0] = (Boolean)((Attribute)annotation.values.get((int)2).snd).getValue();
            boolean isIntercept = (Boolean)((Attribute)annotation.values.get((int)3).snd).getValue();
            interceptType[0] = isIntercept ? this.getInterceptType(tree, sym) : null;
            BasicJavacTask javacTask = (BasicJavacTask)this._tp.getJavacTask();
            Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> classSymbol = ClassSymbols.instance(this._sp.getModule()).getClassSymbol(javacTask, this._tp, extensionClass);
            if (classSymbol == null) continue;
            Symbol.ClassSymbol extClassSym = classSymbol.getFirst();
            if (extClassSym == null) {
                return null;
            }
            Types types = Types.instance(javacTask.getContext());
            block1: for (Symbol elem : IDynamicJdk.instance().getMembers(extClassSym)) {
                int thisOffset;
                if (!(elem instanceof Symbol.MethodSymbol) || !elem.flatName().toString().equals(sym.name.toString())) continue;
                Symbol.MethodSymbol extMethodSym = (Symbol.MethodSymbol)elem;
                java.util.List extParams = extMethodSym.getParameters();
                java.util.List calledParams = ((Symbol.MethodSymbol)sym).getParameters();
                int n = thisOffset = isStatic && !isSmartStatic[0] ? 0 : 1;
                if (((List)extParams).size() - thisOffset != ((List)calledParams).size()) continue;
                for (int i = thisOffset; i < ((List)extParams).size(); ++i) {
                    Symbol.VarSymbol extParam = (Symbol.VarSymbol)((List)extParams).get(i);
                    Symbol.VarSymbol calledParam = (Symbol.VarSymbol)((List)calledParams).get(i - thisOffset);
                    if (!types.isSameType(types.erasure(extParam.type), types.erasure(calledParam.type))) continue block1;
                }
                return extMethodSym;
            }
        }
        return null;
    }

    private InterceptType getInterceptType(JCTree.JCMethodInvocation tree, Symbol sym) {
        Tree parent = this._tp.getParent(tree);
        while (!(parent instanceof JCTree.JCMethodDecl)) {
            parent = this._tp.getParent(parent);
        }
        JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)parent;
        if (!methodDecl.name.toString().equals(sym.name.toString())) {
            return InterceptType.NORMAL;
        }
        int paramsToSubtract = 0;
        if (!methodDecl.params.isEmpty() && ((JCTree.JCVariableDecl)((List)methodDecl.getParameters()).get(0)).getModifiers().getAnnotations().stream().map(annotation -> annotation.getAnnotationType().type.toString()).anyMatch(annotationFqn -> This.class.getTypeName().equals(annotationFqn) || ThisClass.class.getTypeName().equals(annotationFqn))) {
            String objectName = methodDecl.params.get((int)0).name.toString();
            if (!tree.toString().split("\\.", 2)[0].equals(objectName)) {
                return InterceptType.NORMAL;
            }
            paramsToSubtract = 1;
        }
        if (methodDecl.params.length() - paramsToSubtract != tree.args.length()) {
            return InterceptType.NORMAL;
        }
        for (int i = 1; i < methodDecl.params.length(); ++i) {
            if (methodDecl.params.get((int)i).type.tsym.equals(tree.args.get((int)(i - paramsToSubtract)).type.tsym)) continue;
            return InterceptType.NORMAL;
        }
        boolean isInterceptMethod = ((JCTree.JCMethodDecl)parent).getModifiers().annotations.stream().anyMatch(anno -> Intercept.class.getName().equals(anno.type.toString()));
        boolean isStatic = ((JCTree.JCFieldAccess)tree.meth).sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
        if (isInterceptMethod && !isStatic) {
            return InterceptType.REFLECTION;
        }
        if ("super".equals(((JCTree.JCFieldAccess)tree.meth).selected.toString())) {
            return InterceptType.NORMAL;
        }
        return InterceptType.NONE;
    }

    private Symbol.MethodSymbol findReflectUtilMethod(JCTree tree, Type returnType, boolean isStatic) {
        String name = "invoke" + (isStatic ? "Static" : "") + '_' + this.typeForReflect(returnType);
        Symtab symtab = this._tp.getSymtab();
        Type.ArrayType classArrayType = new Type.ArrayType(symtab.classType, symtab.arrayClass);
        Type.ArrayType objectArrayType = new Type.ArrayType(symtab.objectType, symtab.arrayClass);
        List<Type> paramTypes = isStatic ? List.of(symtab.classType, symtab.stringType, classArrayType, new Type[]{objectArrayType}) : List.of(symtab.objectType, symtab.stringType, classArrayType, new Type[]{objectArrayType});
        Names names = Names.instance(this._tp.getContext());
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        return this.resolveMethod(tree.pos(), names.fromString(name), reflectMethodClassSym.type, paramTypes);
    }

    private Symbol.MethodSymbol findFieldAccessReflectUtilMethod(JCTree tree, Type type, boolean isStatic, boolean setter) {
        String name = (setter ? "set" : "get") + "Field" + (isStatic ? "Static" : "") + '_' + this.typeForReflect(type);
        Symtab symtab = this._tp.getSymtab();
        List<Type> paramTypes = setter ? List.of(isStatic ? symtab.classType : symtab.objectType, symtab.stringType, type) : List.of(isStatic ? symtab.classType : symtab.objectType, symtab.stringType);
        Names names = Names.instance(this._tp.getContext());
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        return this.resolveMethod(tree.pos(), names.fromString(name), reflectMethodClassSym.type, paramTypes);
    }

    private Symbol.MethodSymbol findReflectUtilConstructor(JCTree.JCNewClass tree) {
        Symtab symtab = this._tp.getSymtab();
        Type.ArrayType classArrayType = new Type.ArrayType(symtab.classType, symtab.arrayClass);
        Type.ArrayType objectArrayType = new Type.ArrayType(symtab.objectType, symtab.arrayClass);
        List<Type> paramTypes = List.of(symtab.classType, classArrayType, objectArrayType);
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        Names names = Names.instance(this._tp.getContext());
        return this.resolveMethod(tree.pos(), names.fromString("construct"), reflectMethodClassSym.type, paramTypes);
    }

    private String typeForReflect(Type returnType) {
        if (returnType.isPrimitive()) {
            return ((Name)returnType.tsym.getSimpleName()).toString();
        }
        return "Object";
    }

    private boolean isStructuralMethod(JCTree.JCMethodInvocation tree) {
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            if (m.sym != null && !m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC) && !this.isObjectMethod(m.sym)) {
                JCTree.JCExpression thisArg = m.selected;
                return TypesUtil.isStructuralInterface(this._tp.getTypes(), thisArg.type.tsym);
            }
        }
        return false;
    }

    private boolean isObjectMethod(Symbol sym) {
        return sym.owner != null && sym.owner.type == this._tp.getSymtab().objectType;
    }

    public static JCTree.JCExpression memberAccess(TreeMaker make, JavacElements javacElems, String path) {
        return ExtensionTransformer.memberAccess(make, javacElems, path.split("\\."));
    }

    public static JCTree.JCExpression memberAccess(TreeMaker make, JavacElements node, String ... components) {
        JCTree.JCExpression expr = make.Ident(node.getName(components[0]));
        for (int i = 1; i < components.length; ++i) {
            expr = make.Select(expr, node.getName(components[i]));
        }
        return expr;
    }

    public Symbol.MethodSymbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Name name, Type qual, List<Type> args) {
        return ExtensionTransformer.resolveMethod(this._tp.getContext(), this._tp.getCompilationUnit(), pos, name, qual, args);
    }

    public static Symbol.MethodSymbol resolveMethod(Context context, CompilationUnitTree compUnit, JCDiagnostic.DiagnosticPosition pos, Name name, Type qual, List<Type> args) {
        return ExtensionTransformer.resolveMethod(pos, context, (JCTree.JCCompilationUnit)compUnit, name, qual, args);
    }

    private static Symbol.MethodSymbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Context ctx, JCTree.JCCompilationUnit compUnit, Name name, Type qual, List<Type> args) {
        Resolve rs = Resolve.instance(ctx);
        AttrContext attrContext = new AttrContext();
        AttrContextEnv env = new AttrContextEnv(pos.getTree(), attrContext);
        env.toplevel = compUnit;
        return rs.resolveInternalMethod(pos, env, qual, name, args, null);
    }

    private Symbol.VarSymbol resolveField(JCDiagnostic.DiagnosticPosition pos, Context ctx, Name name, Type qual) {
        Resolve rs = Resolve.instance(ctx);
        AttrContext attrContext = new AttrContext();
        AttrContextEnv env = new AttrContextEnv(pos.getTree(), attrContext);
        env.toplevel = (JCTree.JCCompilationUnit)this._tp.getCompilationUnit();
        return rs.resolveInternalField(pos, env, qual, name);
    }

    private static enum InterceptType {
        NONE,
        NORMAL,
        REFLECTION;

    }
}

