/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.type;

import manifold.api.host.IModule;

public class TypeName
implements Comparable {
    public final String name;
    public final Kind kind;
    public final Visibility visibility;
    public final IModule module;

    public TypeName(String name, IModule module, Kind kind, Visibility visibility) {
        this.name = name;
        this.module = module;
        this.kind = kind;
        this.visibility = visibility;
    }

    public int compareTo(Object o) {
        return -(this.kind.ordinal() - ((TypeName)o).kind.ordinal());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeName typeName = (TypeName)o;
        if (this.kind != typeName.kind) {
            return false;
        }
        if (this.module != null ? !this.module.equals(typeName.module) : typeName.module != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(typeName.name) : typeName.name != null) {
            return false;
        }
        return this.visibility == typeName.visibility;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
        result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
        result = 31 * result + (this.module != null ? this.module.hashCode() : 0);
        return result;
    }

    public IModule getModule() {
        return this.module;
    }

    public String toString() {
        return (Object)((Object)this.kind) + " " + this.name + ": " + (Object)((Object)this.visibility);
    }

    public static enum Visibility {
        PUBLIC,
        PROTECTED,
        PRIVATE;

    }

    public static enum Kind {
        TYPE,
        NAMESPACE;

    }
}

