/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.gen;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcElement;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcType;

public abstract class SrcAnnotated<T extends SrcAnnotated<T>>
extends SrcElement {
    private List<SrcAnnotationExpression> _annotations = new ArrayList<SrcAnnotationExpression>();
    private long _modifiers;
    private String _name;
    private List<SrcParameter> _parameters = new ArrayList<SrcParameter>();
    private Map<String, Object> _userData = Collections.emptyMap();

    public SrcAnnotated() {
    }

    public SrcAnnotated(SrcAnnotated owner) {
        super(owner);
    }

    public T addAnnotation(SrcAnnotationExpression anno) {
        this._annotations.add(anno);
        return (T)this;
    }

    public T addAnnotation(Class<?> anno) {
        this._annotations.add(new SrcAnnotationExpression(anno));
        return (T)this;
    }

    public T addAnnotation(String fqn) {
        this._annotations.add(new SrcAnnotationExpression(fqn));
        return (T)this;
    }

    public T modifiers(long modifiers) {
        this._modifiers = modifiers;
        return (T)this;
    }

    public T modifiers(Set<Modifier> modifiers) {
        this._modifiers = SrcAnnotated.modifiersFrom(modifiers);
        return (T)this;
    }

    public static long modifiersFrom(Set<Modifier> modifiers) {
        long mods = 0L;
        for (Modifier mod : modifiers) {
            switch (mod) {
                case PUBLIC: {
                    mods |= 1L;
                    break;
                }
                case PROTECTED: {
                    mods |= 4L;
                    break;
                }
                case PRIVATE: {
                    mods |= 2L;
                    break;
                }
                case ABSTRACT: {
                    mods |= 0x400L;
                    break;
                }
                case DEFAULT: {
                    mods |= 0x80000000000L;
                    break;
                }
                case STATIC: {
                    mods |= 8L;
                    break;
                }
                case FINAL: {
                    mods |= 0x10L;
                    break;
                }
                case TRANSIENT: {
                    mods |= 0x80L;
                    break;
                }
                case VOLATILE: {
                    mods |= 0x40L;
                    break;
                }
                case SYNCHRONIZED: {
                    mods |= 0x20L;
                    break;
                }
                case NATIVE: {
                    mods |= 0x100L;
                    break;
                }
                case STRICTFP: {
                    mods |= 0x800L;
                }
            }
        }
        return mods;
    }

    public T name(String simpleName) {
        this._name = simpleName;
        return (T)this;
    }

    public T addParam(SrcParameter param) {
        this._parameters.add(param);
        param.setOwner(this);
        return (T)this;
    }

    public T addParam(String name, Class type) {
        SrcParameter param = new SrcParameter(name, type);
        param.setOwner(this);
        this._parameters.add(param);
        return (T)this;
    }

    public T addParam(String name, String type) {
        SrcParameter param = new SrcParameter(name, type);
        param.setOwner(this);
        this._parameters.add(param);
        return (T)this;
    }

    public T addParam(String name, SrcType type) {
        SrcParameter param = new SrcParameter(name, type);
        param.setOwner(this);
        this._parameters.add(param);
        return (T)this;
    }

    public T insertParam(String name, SrcType type, int pos) {
        SrcParameter param = new SrcParameter(name, type);
        param.setOwner(this);
        this._parameters.add(pos, param);
        return (T)this;
    }

    public List<SrcAnnotationExpression> getAnnotations() {
        return this._annotations;
    }

    public SrcAnnotationExpression getAnnotation(Class<? extends Annotation> annoClass) {
        for (SrcAnnotationExpression anno : this.getAnnotations()) {
            if (!anno.getAnnotationType().equals(annoClass.getName())) continue;
            return anno;
        }
        return null;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annoClass) {
        return this.hasAnnotation(annoClass.getCanonicalName());
    }

    public boolean hasAnnotation(String fqn) {
        for (SrcAnnotationExpression anno : this.getAnnotations()) {
            if (!anno.getAnnotationType().equals(fqn)) continue;
            return true;
        }
        return false;
    }

    public long getModifiers() {
        return this._modifiers;
    }

    public String getSimpleName() {
        return this._name;
    }

    public List<SrcParameter> getParameters() {
        return this._parameters;
    }

    public void forwardParameters(StringBuilder sb) {
        List<SrcParameter> parameters = this.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            SrcParameter param = parameters.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(param.getSimpleName());
        }
    }

    public T withUserData(String tag, Object value) {
        if (this._userData.isEmpty()) {
            this._userData = new HashMap<String, Object>();
        }
        this._userData.put(tag, value);
        return (T)this;
    }

    public Object getUserData(String tag) {
        return this._userData.isEmpty() ? null : this._userData.get(tag);
    }

    public Object computeOrGetUserData(String tag, Function<String, ?> supplier) {
        if (this._userData.isEmpty()) {
            this._userData = new HashMap<String, Object>();
        }
        return this._userData.computeIfAbsent(tag, supplier);
    }

    public Object removeUserData(String tag) {
        if (this._userData.isEmpty()) {
            return null;
        }
        return this._userData.remove(tag);
    }

    public void clearUserData() {
        this._userData = Collections.emptyMap();
    }

    protected void renderAnnotations(StringBuilder sb, int indent, boolean sameLine) {
        this.renderAnnotations(sb, indent, sameLine, Collections.emptyList());
    }

    protected void renderAnnotations(StringBuilder sb, int indent, boolean sameLine, List<SrcAnnotationExpression> blackList) {
        for (SrcAnnotationExpression anno : this._annotations) {
            if (!blackList.stream().noneMatch(e -> e.getAnnotationType().equals(anno.getAnnotationType()))) continue;
            anno.render(sb, indent, sameLine);
        }
    }

    protected String renderParameters(StringBuilder sb) {
        return this.renderParameters(sb, false);
    }

    protected String renderParameters(StringBuilder sb, boolean forSignature) {
        sb.append('(');
        for (int i = 0; i < this._parameters.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            SrcParameter param = this._parameters.get(i);
            boolean isVarArgs = i == this._parameters.size() - 1 && (this.getModifiers() & 0x80L) != 0L;
            param.render(sb, 0, isVarArgs, forSignature);
        }
        sb.append(')');
        return "";
    }

    public StringBuilder renderArgumenets(StringBuilder sb, List<SrcArgument> arguments, int indent, boolean sameLine) {
        sb.append('(');
        for (int i = 0; i < arguments.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            SrcArgument arg = arguments.get(i);
            arg.render(sb, 0);
        }
        sb.append(')').append(sameLine ? "" : "\n");
        return sb;
    }

    String renderTypeVars(List<SrcType> typeVars, StringBuilder sb) {
        if (typeVars.size() > 0) {
            sb.append('<');
            for (int i = 0; i < typeVars.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                typeVars.get(i).render(sb, 0);
            }
            sb.append('>');
        }
        return "";
    }

    protected String renderModifiers(StringBuilder sb, boolean isDefault, int defModifier) {
        return this.renderModifiers(sb, this._modifiers, isDefault, defModifier);
    }

    protected String renderModifiers(StringBuilder sb, long modifiers, boolean isDefault, int defModifier) {
        if (isDefault) {
            sb.append("default ");
        }
        if ((modifiers & 1L) != 0L) {
            sb.append("public ");
        } else if ((modifiers & 4L) != 0L) {
            sb.append("protected ");
        } else if ((modifiers & 2L) != 0L) {
            sb.append("private ");
        } else if (defModifier != 0) {
            this.renderModifiers(sb, defModifier, false, 0);
        }
        if ((modifiers & 0x400L) != 0L) {
            sb.append("abstract ");
        }
        if ((modifiers & 8L) != 0L) {
            sb.append("static ");
        }
        if ((modifiers & 0x10L) != 0L) {
            sb.append("final ");
        }
        if ((modifiers & 0x80L) != 0L) {
            sb.append("transient ");
        }
        if ((modifiers & 0x40L) != 0L) {
            sb.append("volatile ");
        }
        if ((modifiers & 0x20L) != 0L) {
            sb.append("synchronized ");
        }
        if ((modifiers & 0x200L) != 0L) {
            sb.append("interface ");
        }
        return "";
    }
}

