/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.net.MalformedURLException;
import java.util.Objects;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.gen.SrcClass;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.api.util.JavacDiagnostic;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.js.JavascriptClass;
import manifold.js.JavascriptModel;
import manifold.js.JavascriptProgram;
import manifold.js.JavascriptTemplate;
import manifold.js.rt.parser.Parser;
import manifold.js.rt.parser.TemplateParser;
import manifold.js.rt.parser.TemplateTokenizer;
import manifold.js.rt.parser.Token;
import manifold.js.rt.parser.Tokenizer;
import manifold.js.rt.parser.tree.ParseError;
import manifold.js.rt.parser.tree.ProgramNode;
import manifold.js.rt.parser.tree.template.JSTNode;

class JavascriptCodeGen {
    private final JavascriptModel _model;
    private final IFile _file;
    private final String _fqn;

    JavascriptCodeGen(JavascriptModel model, String topLevelFqn) {
        this._model = model;
        this._file = model.getFiles().iterator().next();
        this._fqn = topLevelFqn;
    }

    SrcClass make(DiagnosticListener<JavaFileObject> errorHandler) {
        String url;
        try {
            url = this._file.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String content = ResourceFileTypeManifold.getContent(this._file);
        if (Objects.equals(this._file.getExtension(), "jst")) {
            TemplateParser parser = new TemplateParser(new TemplateTokenizer(this._fqn, content, url, true));
            return JavascriptTemplate.genClass(this._model, this._fqn, (JSTNode)parser.parse());
        }
        Parser parser = new Parser(new Tokenizer(content, url));
        ProgramNode programNode = (ProgramNode)parser.parse();
        this.reportErrors(errorHandler, programNode);
        if (parser.isES6Class()) {
            return JavascriptClass.genClass(this._fqn, this._model, programNode, this._file);
        }
        return JavascriptProgram.genProgram(this._fqn, programNode, this._file);
    }

    private void reportErrors(DiagnosticListener<JavaFileObject> errorHandler, ProgramNode programNode) {
        if (programNode.errorCount() > 0) {
            SourceJavaFileObject file;
            try {
                file = new SourceJavaFileObject(this._file.toURI());
            }
            catch (Exception e) {
                file = null;
            }
            for (ParseError error : programNode.getErrorList()) {
                Token token = error.getToken();
                int offset = token.getOffset();
                if (this._file instanceof IFileFragment) {
                    offset += ((IFileFragment)this._file).getOffset();
                }
                errorHandler.report(new JavacDiagnostic(file, Diagnostic.Kind.ERROR, offset, token.getLineNumber(), token.getCol(), error.getMessage()));
            }
        }
    }
}

