/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import manifold.api.host.IManifoldHost;
import manifold.api.type.ICompilerComponent;
import manifold.api.type.ITypeManifold;
import manifold.api.type.ITypeProcessor;
import manifold.internal.javac.CompiledTypeProcessor;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.IssueReporter;
import manifold.rt.api.util.ServiceUtil;
import manifold.util.concurrent.ConcurrentHashSet;

public class TypeProcessor
extends CompiledTypeProcessor {
    private final Set<Object> _drivers = new ConcurrentHashSet<Object>();
    private LinkedHashSet<ICompilerComponent> _compilerComponents;

    TypeProcessor(IManifoldHost host, BasicJavacTask javacTask) {
        super(host, javacTask);
        this.loadCompilerComponents(javacTask);
    }

    private void loadCompilerComponents(BasicJavacTask javacTask) {
        this._compilerComponents = new LinkedHashSet();
        ServiceUtil.loadRegisteredServices(this._compilerComponents, ICompilerComponent.class, this.getClass().getClassLoader());
        this._compilerComponents = new LinkedHashSet<ICompilerComponent>(this.order(new ArrayList<ICompilerComponent>(this._compilerComponents)));
        this._compilerComponents.forEach(cc -> cc.init(javacTask, this));
    }

    private List<ICompilerComponent> order(List<ICompilerComponent> compilerComponents) {
        if (compilerComponents.size() <= 0) {
            return compilerComponents;
        }
        ArrayList<ICompilerComponent> copy = new ArrayList<ICompilerComponent>(compilerComponents);
        for (int i = 0; i < copy.size(); ++i) {
            ICompilerComponent.InitOrder initOrder;
            ICompilerComponent cc;
            int j;
            ICompilerComponent c = (ICompilerComponent)copy.get(i);
            int oldIndex = compilerComponents.indexOf(c);
            compilerComponents.remove(oldIndex);
            int newIndex = -1;
            for (j = compilerComponents.size() - 1; j >= 0; --j) {
                cc = compilerComponents.get(j);
                initOrder = c.initOrder(cc);
                if (initOrder != ICompilerComponent.InitOrder.Before) continue;
                newIndex = j;
            }
            for (j = 0; j < compilerComponents.size(); ++j) {
                cc = compilerComponents.get(j);
                initOrder = c.initOrder(cc);
                if (initOrder != ICompilerComponent.InitOrder.After) continue;
                newIndex = j + 1;
            }
            compilerComponents.add(newIndex >= 0 ? newIndex : oldIndex, c);
        }
        return compilerComponents;
    }

    public Collection<ICompilerComponent> getCompilerComponents() {
        return this._compilerComponents;
    }

    @Override
    public void process(TypeElement element, IssueReporter<JavaFileObject> issueReporter) {
        if (IDynamicJdk.isInitializing()) {
            return;
        }
        for (ITypeManifold sp : this.getHost().getSingleModule().getTypeManifolds()) {
            if (!(sp instanceof ITypeProcessor)) continue;
            try {
                ((ITypeProcessor)((Object)sp)).process(element, this, issueReporter);
            }
            catch (Throwable e) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                issueReporter.reportError("Fatal error processing with Manifold type processor: " + sp.getClass().getName() + "\non type: " + element.getQualifiedName() + "\nPlease report the error with the accompanying stack trace.\n" + stackTrace);
                throw e;
            }
        }
    }

    public void addDrivers(Set<Object> drivers) {
        this._drivers.addAll(drivers);
    }

    public Set<Object> getDrivers() {
        return this._drivers;
    }

    public void addTaskListener(TaskListener listener) {
        this.getJavacTask().removeTaskListener(this);
        this.getJavacTask().addTaskListener(listener);
        this.getJavacTask().addTaskListener(this);
    }
}

