/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import manifold.internal.javac.ParentTreePathScanner;
import manifold.rt.api.util.Pair;

public class ParentMap {
    private final Supplier<CompilationUnitTree> _compilationUnitSupplier;
    private final Map<CompilationUnitTree, Pair<Map<Tree, Tree>, Map<Integer, List<Tree>>>> _parents;

    public ParentMap(Supplier<CompilationUnitTree> compilationUnitSupplier) {
        this._compilationUnitSupplier = compilationUnitSupplier;
        this._parents = new HashMap<CompilationUnitTree, Pair<Map<Tree, Tree>, Map<Integer, List<Tree>>>>();
    }

    public Tree getParent(Tree child) {
        return this.getParent(child, this._compilationUnitSupplier.get());
    }

    public Tree getParent(Tree child, CompilationUnitTree compilationUnitTree) {
        Pair parents = this._parents.computeIfAbsent(compilationUnitTree, cu -> {
            HashMap<Tree, Tree> map = new HashMap<Tree, Tree>();
            HashMap<Integer, List<Tree>> map2 = new HashMap<Integer, List<Tree>>();
            new ParentTreePathScanner(map, map2).scan((Tree)cu, null);
            return new Pair<HashMap<Tree, Tree>, HashMap<Integer, List<Tree>>>(map, map2);
        });
        Tree tree = (Tree)((Map)parents.getFirst()).get(child);
        if (tree == null && child instanceof JCTree) {
            tree = ParentMap.getParentByPos((JCTree)child, parents);
        }
        return tree;
    }

    private static Tree getParentByPos(JCTree child, Pair<Map<Tree, Tree>, Map<Integer, List<Tree>>> parents) {
        Tree tree = null;
        List<Tree> posParents = parents.getSecond().get(child.pos);
        if (posParents != null) {
            tree = posParents.size() == 1 ? posParents.get(0) : (Tree)posParents.stream().filter(t -> t instanceof JCTree && ((JCTree)t).pos != child.pos).findFirst().orElse(null);
        }
        return tree;
    }
}

