/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import javax.tools.JavaFileObject;
import manifold.internal.javac.JavacPlugin;
import manifold.rt.api.IBootstrap;
import manifold.rt.api.NoBootstrap;
import manifold.rt.api.util.ManClassUtil;

class BootstrapInserter
extends TreeTranslator {
    private JavacPlugin _javacPlugin;

    public BootstrapInserter(JavacPlugin javacPlugin) {
        this._javacPlugin = javacPlugin;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        super.visitClassDef(tree);
        if (tree.sym != null && !tree.sym.isInner() && !tree.sym.isInterface() && this.okToInsertBootstrap(tree)) {
            JCTree.JCStatement newNode = this.buildBootstrapStaticBlock();
            ArrayList<JCTree> newDefs = new ArrayList<JCTree>(tree.defs);
            newDefs.add(0, newNode);
            tree.defs = List.from(newDefs);
        }
        this.result = tree;
    }

    private boolean okToInsertBootstrap(JCTree.JCClassDecl tree) {
        return !this.annotatedWith_NoBootstrap((List<JCTree.JCAnnotation>)tree.getModifiers().getAnnotations()) && !JavacPlugin.instance().isNoBootstrapping() && this.isExtensionsEnabled() && !this.alreadyHasBootstrap(tree) && !this.isSideCarClass(tree) && !this.skipForOtherReasons(tree);
    }

    private boolean isSideCarClass(JCTree.JCClassDecl tree) {
        String fileName;
        if (tree.sym.getEnclosingElement() instanceof Symbol.ClassSymbol) {
            return false;
        }
        JavaFileObject sourceFile = tree.sym.sourcefile;
        if (sourceFile == null) {
            return false;
        }
        URI uri = sourceFile.toUri();
        try {
            fileName = new File(uri).getName();
        }
        catch (Exception e) {
            return false;
        }
        if (!fileName.toLowerCase().endsWith(".java")) {
            return false;
        }
        if (!ManClassUtil.isJavaIdentifier(fileName = fileName.substring(0, fileName.toLowerCase().indexOf(".java")))) {
            return false;
        }
        return !fileName.equals(tree.sym.getSimpleName().toString());
    }

    public boolean isExtensionsEnabled() {
        try {
            Class.forName("manifold.ext.rt.api.Extension");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean alreadyHasBootstrap(JCTree.JCClassDecl tree) {
        return tree.defs.stream().anyMatch(def -> {
            if (def instanceof JCTree.JCBlock) {
                String staticBlock = def.toString();
                return staticBlock.startsWith("static") && staticBlock.contains(IBootstrap.class.getSimpleName()) && staticBlock.contains(".dasBoot");
            }
            return false;
        });
    }

    private boolean skipForOtherReasons(JCTree.JCClassDecl tree) {
        if ((tree.getModifiers().flags & 0x2000L) != 0L) {
            return true;
        }
        if (tree.implementing != null) {
            for (JCTree.JCExpression iface : tree.implementing) {
                if (!iface.toString().contains("ManifoldHost")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean annotatedWith_NoBootstrap(List<JCTree.JCAnnotation> annotations) {
        for (JCTree.JCAnnotation anno : annotations) {
            if (!anno.getAnnotationType().toString().endsWith(NoBootstrap.class.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private JCTree.JCStatement buildBootstrapStaticBlock() {
        TreeMaker make = this._javacPlugin.getTreeMaker();
        JavacElements javacElems = this._javacPlugin.getJavacElements();
        JCTree.JCMethodInvocation bootstrapInitCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, IBootstrap.class.getName() + ".dasBoot"), List.nil());
        return make.Block(8L, List.of(make.Exec(bootstrapInitCall)));
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements javacElems, String path) {
        return this.memberAccess(make, javacElems, path.split("\\."));
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements node, String ... components) {
        JCTree.JCExpression expr = make.Ident(node.getName(components[0]));
        for (int i = 1; i < components.length; ++i) {
            expr = make.Select(expr, node.getName(components[i]));
        }
        return expr;
    }
}

