/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.util;

import java.util.ArrayList;

public class IssueMsg {
    public static final IssueMsg MSG_COULD_NOT_FIND_TYPE_FOR_FILE = new IssueMsg("Could not find type for file: {0}");
    public static final IssueMsg MSG_AUTO_CANNOT_INFER_WO_INIT = new IssueMsg("Cannot infer 'auto' variable type without initializer");
    public static final IssueMsg MSG_AUTO_CANNOT_RETURN_AUTO_FROM_ABSTRACT_METHOD = new IssueMsg("Cannot return 'auto' from abstract method");
    public static final IssueMsg MSG_AUTO_RETURN_MORE_SPECIFIC_TYPE = new IssueMsg("Cannot return 'auto', return a more specific type");
    public static final IssueMsg MSG_AUTO_UNABLE_TO_RESOLVE_TYPE = new IssueMsg("Unable to infer 'auto' type here");
    public static final IssueMsg MSG_AUTO_CANNOT_INFER_FROM_NULL = new IssueMsg("'auto' cannot infer from just 'null', cast 'null' or replace 'auto' with a type");
    public static final IssueMsg MSG_ANON_RETURN_METHOD_REF_NOT_SUPPORTED = new IssueMsg("Method reference '{0}' must be invoked as a lambda expression here");
    public static final IssueMsg MSG_OPT_PARAMS_POSITIONAL_BEFORE_NAMED = new IssueMsg("Positional arguments must appear before named arguments");
    public static final IssueMsg MSG_OPT_PARAMS_MISSING_REQ_ARG = new IssueMsg("missing required argument: '{0}'");
    public static final IssueMsg MSG_OPT_PARAMS_NO_MATCHING_PARAMS_FOR_NAMED_ARGS = new IssueMsg("No matching parameters for named argument[s]: '{0}'");
    private final String _msg;

    public IssueMsg(String msg) {
        this._msg = msg;
    }

    public String get(Object ... args) {
        String msg = this._msg;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            msg = msg.replace("{" + i + "}", arg.toString());
        }
        return msg;
    }

    public boolean isMessageSimilar(String message) {
        String raw = this.get(new Object[0]);
        ArrayList<String> parts = new ArrayList<String>();
        int iLast = 0;
        int iClose = 0;
        while (iClose < raw.length()) {
            int iOpen = raw.indexOf(123, iClose);
            if (iOpen < 0) {
                parts.add(raw.substring(iLast));
                break;
            }
            iClose = raw.indexOf(125, iOpen);
            if (iClose < 0) {
                parts.add(raw.substring(iLast));
                break;
            }
            if (!this.isInt(raw.substring(iOpen + 1, iClose))) continue;
            parts.add(raw.substring(iLast, iOpen));
            iLast = iClose + 1;
        }
        int i = 0;
        for (String part2 : parts) {
            if (message.indexOf(part2, i) < 0) {
                return false;
            }
            i += part2.length();
        }
        return true;
    }

    private boolean isInt(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

