/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.ResourcePath;

public class URLFileImpl
implements IFile {
    private final IFileSystem _fileSystem;
    private URL _url;

    public URLFileImpl(IFileSystem fs, URL url) {
        this._fileSystem = fs;
        this._url = url;
    }

    @Override
    public IFileSystem getFileSystem() {
        return this._fileSystem;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this._url.openStream();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream openOutputStreamForAppend() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getExtension() {
        int lastDot = this.getName().lastIndexOf(".");
        if (lastDot != -1) {
            return this.getName().substring(lastDot + 1);
        }
        return "";
    }

    @Override
    public String getBaseName() {
        int lastDot = this.getName().lastIndexOf(".");
        if (lastDot != -1) {
            return this.getName().substring(0, lastDot);
        }
        return this.getName();
    }

    @Override
    public IDirectory getParent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.getPath().getName();
    }

    @Override
    public boolean exists() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean delete() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI toURI() {
        try {
            return this._url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Cannot convert to URI", e);
        }
    }

    @Override
    public ResourcePath getPath() {
        return ResourcePath.parse(this._url.getPath());
    }

    @Override
    public boolean isChildOf(IDirectory dir) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDescendantOf(IDirectory dir) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File toJavaFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isJavaFile() {
        return false;
    }

    @Override
    public boolean isInJar() {
        return false;
    }

    @Override
    public boolean create() {
        throw new UnsupportedOperationException();
    }
}

