/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.def;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.IResource;
import manifold.api.fs.ResourcePath;
import manifold.api.fs.def.JavaDirectoryImpl;

public abstract class JavaResourceImpl
implements IResource,
Serializable {
    private final IFileSystem _fileSystem;
    protected File _file;
    private String _name;
    private IDirectory _parent;
    private URI _uri;
    private ResourcePath _path;
    private int _hash;

    protected JavaResourceImpl(IFileSystem fileSystem, File file) {
        this._fileSystem = fileSystem;
        this._file = file.getAbsoluteFile();
    }

    @Override
    public IFileSystem getFileSystem() {
        return this._fileSystem;
    }

    @Override
    public IDirectory getParent() {
        if (this._parent == null) {
            File parentFile = this._file.getParentFile();
            if (parentFile == null) {
                return null;
            }
            this._parent = this.getFileSystem().getIDirectory(parentFile);
        }
        return this._parent;
    }

    @Override
    public String getName() {
        return this._name == null ? (this._name = this._file.getName()) : this._name;
    }

    @Override
    public boolean delete() throws IOException {
        return this._file.delete();
    }

    @Override
    public URI toURI() {
        return this._uri == null ? (this._uri = this._file.toURI()) : this._uri;
    }

    @Override
    public ResourcePath getPath() {
        return this._path == null ? (this._path = ResourcePath.parse(this._file.getAbsolutePath())) : this._path;
    }

    @Override
    public boolean isChildOf(IDirectory dir) {
        return dir.equals(this.getParent());
    }

    @Override
    public boolean isDescendantOf(IDirectory dir) {
        if (!(dir instanceof JavaDirectoryImpl)) {
            return false;
        }
        File javadir = ((JavaDirectoryImpl)dir)._file;
        for (File javafile = this._file.getParentFile(); javafile != null; javafile = javafile.getParentFile()) {
            if (!javafile.equals(javadir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public File toJavaFile() {
        return this._file;
    }

    @Override
    public boolean isJavaFile() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaResourceImpl) {
            return this._file.equals(((JavaResourceImpl)obj)._file);
        }
        return false;
    }

    public int hashCode() {
        return this._hash == 0 ? (this._hash = this._file.hashCode()) : this._hash;
    }

    public String toString() {
        return this._file.toString();
    }

    @Override
    public boolean create() {
        return false;
    }

    @Override
    public boolean isInJar() {
        return false;
    }
}

