/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import manifold.api.fs.Extensions;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.rt.api.util.StreamUtil;

public class IFileUtil {
    public static String getExtension(IFile file) {
        int lastDot = file.getName().lastIndexOf(".");
        if (lastDot >= 0) {
            return file.getName().substring(lastDot + 1);
        }
        return "";
    }

    public static String getExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        if (lastDot >= 0) {
            return fileName.substring(lastDot + 1);
        }
        return "";
    }

    public static String getBaseName(IFile file) {
        return IFileUtil.getBaseName(file.getName());
    }

    public static String getBaseName(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        if (lastDot >= 0) {
            return fileName.substring(0, lastDot);
        }
        return "";
    }

    public static boolean hasSourceFiles(IDirectory root) {
        if (!root.exists()) {
            return false;
        }
        return !Extensions.containsManifest(root) || !Extensions.getExtensions(root, "Contains-Sources").isEmpty() || root.getName().equals("_wl_cls_gen.jar");
    }

    public static int findOffset(IFile file, int line, int column) {
        try {
            int offset = 0;
            String content = StreamUtil.getContent(new InputStreamReader(file.openInputStream(), StandardCharsets.UTF_8));
            for (int i = 1; i < line; ++i) {
                if (content.length() <= offset) continue;
                offset = content.indexOf(10, offset) + 1;
            }
            return offset + column - 1;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

