/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.List;

@Internal
public class SubscriptionUniqueRootField
extends AbstractRule {
    public SubscriptionUniqueRootField(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDef) {
        if (operationDef.getOperation() == OperationDefinition.Operation.SUBSCRIPTION) {
            List<Selection> subscriptionSelections = operationDef.getSelectionSet().getSelections();
            if (subscriptionSelections.size() > 1) {
                String message = this.i18n(ValidationErrorType.SubscriptionMultipleRootFields, "SubscriptionUniqueRootField.multipleRootFields", operationDef.getName());
                this.addError(ValidationErrorType.SubscriptionMultipleRootFields, operationDef.getSourceLocation(), message);
            } else {
                Selection rootSelection = subscriptionSelections.get(0);
                if (this.isIntrospectionField(rootSelection)) {
                    String message = this.i18n(ValidationErrorType.SubscriptionIntrospectionRootField, "SubscriptionIntrospectionRootField.introspectionRootField", operationDef.getName(), ((Field)rootSelection).getName());
                    this.addError(ValidationErrorType.SubscriptionIntrospectionRootField, rootSelection.getSourceLocation(), message);
                } else if (rootSelection instanceof FragmentSpread) {
                    String fragmentName = ((FragmentSpread)rootSelection).getName();
                    FragmentDefinition fragmentDef = this.getValidationContext().getFragment(fragmentName);
                    List<Selection> fragmentSelections = fragmentDef.getSelectionSet().getSelections();
                    if (fragmentSelections.size() > 1) {
                        String message = this.i18n(ValidationErrorType.SubscriptionMultipleRootFields, "SubscriptionUniqueRootField.multipleRootFieldsWithFragment", operationDef.getName());
                        this.addError(ValidationErrorType.SubscriptionMultipleRootFields, rootSelection.getSourceLocation(), message);
                    } else if (this.isIntrospectionField(fragmentSelections.get(0))) {
                        String message = this.i18n(ValidationErrorType.SubscriptionIntrospectionRootField, "SubscriptionIntrospectionRootField.introspectionRootFieldWithFragment", operationDef.getName(), ((Field)fragmentSelections.get(0)).getName());
                        this.addError(ValidationErrorType.SubscriptionIntrospectionRootField, rootSelection.getSourceLocation(), message);
                    }
                }
            }
        }
    }

    private boolean isIntrospectionField(Selection selection) {
        return selection instanceof Field && ((Field)selection).getName().startsWith("__");
    }
}

