/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Energy;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.Force;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.Mass;
import manifold.science.measures.MassUnit;
import manifold.science.measures.MomentumUnit;
import manifold.science.measures.Time;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.Velocity;
import manifold.science.measures.VelocityUnit;
import manifold.science.util.Rational;

public final class Momentum
extends AbstractMeasure<MomentumUnit, Momentum> {
    public Momentum(Rational value, MomentumUnit unit, MomentumUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Momentum(Rational value, MomentumUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public MomentumUnit getBaseUnit() {
        return MomentumUnit.BASE;
    }

    @Override
    public Momentum make(Rational value, MomentumUnit unit, MomentumUnit displayUnit) {
        return new Momentum(value, unit, displayUnit);
    }

    @Override
    public Momentum make(Rational value, MomentumUnit unit) {
        return new Momentum(value, unit);
    }

    public Energy times(Velocity v) {
        return new Energy(this.toBaseNumber().times(v.toBaseNumber()), EnergyUnit.BASE, ((MomentumUnit)this.getDisplayUnit()).times((VelocityUnit)v.getDisplayUnit()));
    }

    public Velocity div(Mass mass) {
        return new Velocity(this.toBaseNumber().div(mass.toBaseNumber()), VelocityUnit.BASE, ((MomentumUnit)this.getDisplayUnit()).getVelocityUnit());
    }

    public Mass div(Velocity v) {
        return new Mass(this.toBaseNumber().div(v.toBaseNumber()), MassUnit.BASE, ((MomentumUnit)this.getDisplayUnit()).getMassUnit());
    }

    public Force div(Time t) {
        return new Force(this.toBaseNumber().div(t.toBaseNumber()), ForceUnit.BASE, ((MomentumUnit)this.getDisplayUnit()).div((TimeUnit)t.getDisplayUnit()));
    }
}

