/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.definitions;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import manifold.api.fs.IFile;
import manifold.preprocessor.api.SymbolProvider;
import manifold.preprocessor.definitions.Definitions;
import manifold.rt.api.util.ServiceUtil;
import manifold.util.concurrent.ConcurrentWeakHashMap;

public class ServiceDefinitions
extends Definitions {
    public static final Map<ClassLoader, Set<SymbolProvider>> REGISTERED_SYMBOL_PROVIDERS = new ConcurrentWeakHashMap<ClassLoader, Set<SymbolProvider>>();
    private final Definitions _rootDefinitions;

    public ServiceDefinitions(Definitions rootDefinitions) {
        super(rootDefinitions.getSourceFile());
        this._rootDefinitions = rootDefinitions;
    }

    public Definitions getRootDefinitions() {
        return this._rootDefinitions;
    }

    @Override
    protected Definitions loadParentDefinitions() {
        return null;
    }

    @Override
    public boolean isDefined(String def) {
        Set<SymbolProvider> providers = ServiceDefinitions.getSymbolProviders(this.getSourceFile());
        return providers.stream().anyMatch(p -> p.isDefined(this.getRootDefinitions(), this.getSourceFile(), def));
    }

    @Override
    public String getValue(String def) {
        Set<SymbolProvider> providers = ServiceDefinitions.getSymbolProviders(this.getSourceFile());
        return providers.stream().filter(p -> p.isDefined(this.getRootDefinitions(), this.getSourceFile(), def)).map(p -> p.getValue(this.getRootDefinitions(), this.getSourceFile(), def)).map(v -> v == null ? "" : v).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<SymbolProvider> getSymbolProviders(IFile sourceFile) {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = null;
        if (sourceFile != null) {
            cl = sourceFile.getFileSystem().getHost().getClassLoaderForFile(sourceFile);
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        } else {
            cl = currentLoader;
        }
        try {
            cl = cl == null ? ServiceDefinitions.class.getClassLoader() : cl;
            Set set2 = REGISTERED_SYMBOL_PROVIDERS.computeIfAbsent(cl, __ -> {
                HashSet registered = new HashSet();
                ServiceUtil.loadRegisteredServices(registered, SymbolProvider.class, ServiceDefinitions.class.getClassLoader());
                return registered;
            });
            return set2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }
}

