/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Acceleration;
import manifold.science.measures.AccelerationUnit;
import manifold.science.measures.Energy;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.Length;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.Mass;
import manifold.science.measures.MassUnit;
import manifold.science.measures.Momentum;
import manifold.science.measures.MomentumUnit;
import manifold.science.measures.Power;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.Time;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.Velocity;
import manifold.science.measures.VelocityUnit;
import manifold.science.util.Rational;

public final class Force
extends AbstractMeasure<ForceUnit, Force> {
    public Force(Rational value, ForceUnit unit, ForceUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Force(Rational value, ForceUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public ForceUnit getBaseUnit() {
        return ForceUnit.BASE;
    }

    @Override
    public Force make(Rational value, ForceUnit unit, ForceUnit displayUnit) {
        return new Force(value, unit, displayUnit);
    }

    @Override
    public Force make(Rational value, ForceUnit unit) {
        return new Force(value, unit);
    }

    public Power times(Velocity v) {
        return new Power(this.toBaseNumber().times(v.toBaseNumber()), PowerUnit.BASE, ((ForceUnit)this.getDisplayUnit()).times(((VelocityUnit)v.getDisplayUnit()).getLengthUnit()).div(((VelocityUnit)v.getDisplayUnit()).getTimeUnit()));
    }

    public Energy times(Length len) {
        return new Energy(this.toBaseNumber().times(len.toBaseNumber()), EnergyUnit.BASE, ((ForceUnit)this.getDisplayUnit()).times((LengthUnit)len.getDisplayUnit()));
    }

    public Momentum times(Time t) {
        return new Momentum(this.toBaseNumber().times(t.toBaseNumber()), MomentumUnit.BASE, ((ForceUnit)this.getDisplayUnit()).times((TimeUnit)t.getDisplayUnit()));
    }

    public Acceleration div(Mass w) {
        return new Acceleration(this.toBaseNumber().div(w.toBaseNumber()), AccelerationUnit.BASE, ((ForceUnit)this.getDisplayUnit()).getAccUnit());
    }

    public Mass div(Acceleration acc) {
        return new Mass(this.toBaseNumber().div(acc.toBaseNumber()), MassUnit.BASE, ((ForceUnit)this.getDisplayUnit()).getMassUnit());
    }
}

