/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Capacitance;
import manifold.science.measures.CapacitanceUnit;
import manifold.science.measures.ChargeUnit;
import manifold.science.measures.Current;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.Potential;
import manifold.science.measures.PotentialUnit;
import manifold.science.measures.Time;
import manifold.science.measures.TimeUnit;
import manifold.science.util.Rational;

public final class Charge
extends AbstractMeasure<ChargeUnit, Charge> {
    public Charge(Rational value, ChargeUnit unit, ChargeUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Charge(Rational value, ChargeUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public ChargeUnit getBaseUnit() {
        return ChargeUnit.BASE;
    }

    @Override
    public Charge make(Rational value, ChargeUnit unit, ChargeUnit displayUnit) {
        return new Charge(value, unit, displayUnit);
    }

    @Override
    public Charge make(Rational value, ChargeUnit unit) {
        return new Charge(value, unit);
    }

    public Current div(Time time) {
        return new Current(this.toBaseNumber().div(time.toBaseNumber()), CurrentUnit.BASE, CurrentUnit.get((ChargeUnit)this.getDisplayUnit(), (TimeUnit)time.getDisplayUnit()));
    }

    public Time div(Current i) {
        return new Time(this.toBaseNumber().div(i.toBaseNumber()), TimeUnit.BASE, ((CurrentUnit)i.getDisplayUnit()).getTimeUnit());
    }

    public Capacitance div(Potential p) {
        return new Capacitance(this.toBaseNumber().div(p.toBaseNumber()), CapacitanceUnit.BASE, CapacitanceUnit.get((ChargeUnit)this.getDisplayUnit(), (PotentialUnit)p.getDisplayUnit()));
    }

    public Potential div(Capacitance cap) {
        return new Potential(this.toBaseNumber().div(cap.toBaseNumber()), PotentialUnit.BASE, ((CapacitanceUnit)cap.getDisplayUnit()).getPotentialUnit());
    }
}

